/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rpc;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.server.PropertyHandlerMapping;
import org.apache.xmlrpc.server.RequestProcessorFactoryFactory;
import org.apache.xmlrpc.server.XmlRpcHandlerMapping;
import org.apache.xmlrpc.server.XmlRpcServer;
import org.apache.xmlrpc.server.XmlRpcServerConfigImpl;
import org.apache.xmlrpc.webserver.WebServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.rpc.AnalysisRpcException;
import uk.ac.diamond.scisoft.analysis.rpc.FlatteningService;
import uk.ac.diamond.scisoft.analysis.rpc.IAnalysisRpcHandler;
import uk.ac.diamond.scisoft.analysis.rpc.flattening.IRootFlattener;
import uk.ac.diamond.scisoft.analysis.rpc.internal.AnalysisRpcServerHandler;
import uk.ac.diamond.scisoft.analysis.rpc.internal.AnalysisRpcServerHandlerImpl;
import uk.ac.diamond.scisoft.analysis.rpc.internal.AnalysisRpcWebServer;
import uk.ac.diamond.scisoft.analysis.rpc.internal.HandlerRequestProcessorFactoryFactory;

public class AnalysisRpcServer {
    private static final Logger logger = LoggerFactory.getLogger(AnalysisRpcServer.class);
    private XmlRpcServer xmlRpcServer;
    private WebServer webServer;
    private Map<String, IAnalysisRpcHandler> handlers = Collections.synchronizedMap(new HashMap());
    private IRootFlattener flattener = FlatteningService.getFlattener();

    public AnalysisRpcServer(int n) {
        try {
            byte[] byArray = new byte[4];
            byArray[0] = 127;
            byArray[3] = 1;
            this.webServer = new AnalysisRpcWebServer(n, InetAddress.getByAddress(byArray));
        }
        catch (UnknownHostException unknownHostException) {
            logger.error("Failed to get InetAddress of localhost", (Throwable)unknownHostException);
        }
        this.xmlRpcServer = this.webServer.getXmlRpcServer();
        PropertyHandlerMapping propertyHandlerMapping = new PropertyHandlerMapping();
        AnalysisRpcServerHandlerImpl analysisRpcServerHandlerImpl = new AnalysisRpcServerHandlerImpl(this);
        propertyHandlerMapping.setRequestProcessorFactoryFactory((RequestProcessorFactoryFactory)new HandlerRequestProcessorFactoryFactory(analysisRpcServerHandlerImpl));
        try {
            propertyHandlerMapping.addHandler("Analysis", AnalysisRpcServerHandler.class);
        }
        catch (XmlRpcException xmlRpcException) {
            logger.error("Failed to addHandler for 'Analysis' to XML-RPC Server", (Throwable)xmlRpcException);
        }
        this.xmlRpcServer.setHandlerMapping((XmlRpcHandlerMapping)propertyHandlerMapping);
        XmlRpcServerConfigImpl xmlRpcServerConfigImpl = (XmlRpcServerConfigImpl)this.xmlRpcServer.getConfig();
        xmlRpcServerConfigImpl.setEnabledForExtensions(false);
        xmlRpcServerConfigImpl.setContentLengthOptional(false);
    }

    public void addHandler(String string, IAnalysisRpcHandler iAnalysisRpcHandler) {
        this.handlers.put(string, iAnalysisRpcHandler);
    }

    public void removeHandler(String string) {
        this.handlers.remove(string);
    }

    public IAnalysisRpcHandler getHandler(String string) {
        return this.handlers.get(string);
    }

    public void start() throws AnalysisRpcException {
        try {
            this.webServer.start();
        }
        catch (IOException iOException) {
            logger.error("Failed to start AnalysisRPC underlying webServer", (Throwable)iOException);
            throw new AnalysisRpcException(iOException);
        }
    }

    public void shutdown() {
        this.webServer.shutdown();
    }

    public IAnalysisRpcHandler getDestination(String string) {
        return this.handlers.get(string);
    }

    public IRootFlattener getFlattener() {
        return this.flattener;
    }

    public int getPort() {
        return this.webServer.getPort();
    }
}

