/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rpc;

import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.rpc.AnalysisRpcClient;
import uk.ac.diamond.scisoft.analysis.rpc.AnalysisRpcException;
import uk.ac.diamond.scisoft.analysis.rpc.AnalysisRpcServer;
import uk.ac.diamond.scisoft.analysis.rpc.IAnalysisRpcHandler;

public class AnalysisRpcExceptionsTest {
    private static final int PORT = 8614;
    private static final String CAT_TWO_STRINGS = "cat";
    private static AnalysisRpcServer analysisRpcServer;
    private static AnalysisRpcClient analysisRpcClient;

    @BeforeClass
    public static void setupBeforeClass() throws AnalysisRpcException {
        analysisRpcServer = new AnalysisRpcServer(8614);
        analysisRpcServer.start();
        analysisRpcServer.addHandler(CAT_TWO_STRINGS, new IAnalysisRpcHandler(){

            @Override
            public Object run(Object[] objectArray) {
                return String.valueOf((String)objectArray[0]) + (String)objectArray[1];
            }
        });
        analysisRpcClient = new AnalysisRpcClient(8614);
    }

    @AfterClass
    public static void tearDownAfterClass() {
        analysisRpcServer.shutdown();
    }

    @Test
    public void testBasicOperation() throws AnalysisRpcException {
        String string = (String)analysisRpcClient.request(CAT_TWO_STRINGS, new Object[]{"Hello, ", "World!"});
        Assert.assertEquals((Object)"Hello, World!", (Object)string);
    }

    @Test
    public void testHandlerExceptionOperation() {
        try {
            analysisRpcClient.request(CAT_TWO_STRINGS, new Object[]{"Hello, "});
            Assert.fail((String)"No exception raised");
        }
        catch (AnalysisRpcException analysisRpcException) {
            Assert.assertFalse((boolean)(analysisRpcException.getCause() instanceof ArrayIndexOutOfBoundsException));
            Assert.assertEquals(Exception.class, analysisRpcException.getCause().getClass());
        }
    }

    @Test
    public void testInternalExceptionOperation() {
        try {
            analysisRpcClient.request(CAT_TWO_STRINGS, new Object[]{new Object()});
            Assert.fail((String)"No exception raised");
        }
        catch (AnalysisRpcException analysisRpcException) {
            Assert.assertEquals(UnsupportedOperationException.class, analysisRpcException.getCause().getClass());
        }
    }

    @Test
    public void testNoMatchingHandlerException() {
        try {
            analysisRpcClient.request("cat invalid", new Object[]{"Hello, ", "World!"});
            Assert.fail((String)"No exception raised");
        }
        catch (AnalysisRpcException analysisRpcException) {
            Assert.assertFalse((boolean)(analysisRpcException.getCause() instanceof AnalysisRpcException));
            Assert.assertEquals(Exception.class, analysisRpcException.getCause().getClass());
            Assert.assertEquals((Object)"No handler registered for cat invalid", (Object)analysisRpcException.getCause().getMessage());
        }
    }
}

