/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rpc;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.AnalysisRpcServerProvider;
import uk.ac.diamond.scisoft.analysis.rpc.AnalysisRpcException;
import uk.ac.diamond.scisoft.analysis.rpc.IAnalysisRpcHandler;

public class AnalysisRpcDisableTest {
    private static final String DISABLE_PROP = "uk.ac.diamond.scisoft.analysis.analysisrpcserverprovider.disable";
    private String original_disable;

    @Before
    public void setUp() {
        this.original_disable = System.getProperty(DISABLE_PROP);
    }

    @After
    public void tearDown() {
        if (this.original_disable == null) {
            System.clearProperty(DISABLE_PROP);
        } else {
            System.setProperty(DISABLE_PROP, this.original_disable);
        }
    }

    private IAnalysisRpcHandler makeHandler() {
        return new IAnalysisRpcHandler(){

            @Override
            public Object run(Object[] objectArray) throws AnalysisRpcException {
                Assert.fail((String)"Unreachable");
                return null;
            }
        };
    }

    @Test(expected=AnalysisRpcException.class)
    public void testDisableRPCTrue() throws AnalysisRpcException {
        System.setProperty(DISABLE_PROP, "True");
        AnalysisRpcServerProvider.getInstance().addHandler("should_not_register", this.makeHandler());
    }

    @Test
    public void testDisableRPCFalse() throws AnalysisRpcException {
        System.setProperty(DISABLE_PROP, "False");
        AnalysisRpcServerProvider.getInstance().addHandler("should_register", this.makeHandler());
        AnalysisRpcServerProvider.getInstance().addHandler("should_register", null);
    }

    @Test
    public void testDisableRPCClear() throws AnalysisRpcException {
        System.clearProperty(DISABLE_PROP);
        AnalysisRpcServerProvider.getInstance().addHandler("should_register", this.makeHandler());
        AnalysisRpcServerProvider.getInstance().addHandler("should_register", null);
    }
}

