/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rpc;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;
import org.apache.xmlrpc.common.TypeFactory;
import org.apache.xmlrpc.common.XmlRpcController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.rpc.AnalysisRpcException;
import uk.ac.diamond.scisoft.analysis.rpc.FlatteningService;
import uk.ac.diamond.scisoft.analysis.rpc.flattening.IRootFlattener;
import uk.ac.diamond.scisoft.analysis.rpc.internal.AnalysisRpcTypeFactoryImpl;

public class AnalysisRpcClient {
    private static final Logger logger = LoggerFactory.getLogger(AnalysisRpcClient.class);
    private XmlRpcClient client;
    private IRootFlattener flattener = FlatteningService.getFlattener();
    private final int port;

    public AnalysisRpcClient(int n) {
        this.port = n;
        try {
            XmlRpcClientConfigImpl xmlRpcClientConfigImpl = new XmlRpcClientConfigImpl();
            xmlRpcClientConfigImpl.setServerURL(new URL("http://127.0.0.1:" + n + "/RPC2"));
            this.client = new XmlRpcClient();
            this.client.setConfig((XmlRpcClientConfig)xmlRpcClientConfigImpl);
            this.client.setTypeFactory((TypeFactory)new AnalysisRpcTypeFactoryImpl((XmlRpcController)this.client));
        }
        catch (MalformedURLException malformedURLException) {
            logger.error("Failed to create AnalysisRPCClient due to MalformedURLException", (Throwable)malformedURLException);
        }
    }

    public Object request(String string, Object[] objectArray) throws AnalysisRpcException {
        try {
            Object[] objectArray2 = (Object[])this.flattener.flatten(objectArray);
            Object object = this.client.execute("Analysis.handler", new Object[]{string, objectArray2});
            Object object2 = this.flattener.unflatten(object);
            if (object2 instanceof Exception) {
                throw new AnalysisRpcException((Exception)object2);
            }
            return object2;
        }
        catch (XmlRpcException xmlRpcException) {
            throw new AnalysisRpcException(xmlRpcException);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw new AnalysisRpcException(unsupportedOperationException);
        }
    }

    public int getPort() {
        return this.port;
    }
}

