/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rpc;

import org.junit.Assert;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.rpc.AnalysisRpcClient;
import uk.ac.diamond.scisoft.analysis.rpc.AnalysisRpcException;
import uk.ac.diamond.scisoft.analysis.rpc.AnalysisRpcServer;
import uk.ac.diamond.scisoft.analysis.rpc.IAnalysisRpcHandler;

public class AnalysisRpcBasicTest {
    private static final int PORT = 8613;
    private static final String CAT_TWO_STRINGS = "cat";

    @Test
    public void testBasicOperation() throws AnalysisRpcException {
        AnalysisRpcServer analysisRpcServer = new AnalysisRpcServer(8613);
        try {
            analysisRpcServer.addHandler(CAT_TWO_STRINGS, new CatTwoStringsHandler());
            analysisRpcServer.start();
            AnalysisRpcClient analysisRpcClient = new AnalysisRpcClient(8613);
            Object[] objectArray = new Object[]{"Hello, ", "World!"};
            String string = (String)analysisRpcClient.request(CAT_TWO_STRINGS, objectArray);
            Assert.assertEquals((Object)"Hello, World!", (Object)string);
        }
        finally {
            analysisRpcServer.shutdown();
        }
    }

    private final class CatTwoStringsHandler
    implements IAnalysisRpcHandler {
        private CatTwoStringsHandler() {
        }

        @Override
        public Object run(Object[] objectArray) {
            return String.valueOf((String)objectArray[0]) + (String)objectArray[1];
        }
    }
}

