/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rpc;

import org.junit.Assert;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.rpc.AnalysisRpcClient;
import uk.ac.diamond.scisoft.analysis.rpc.AnalysisRpcException;
import uk.ac.diamond.scisoft.analysis.rpc.AnalysisRpcServer;
import uk.ac.diamond.scisoft.analysis.rpc.IAnalysisRpcHandler;

public class AnalysisRpcAdvancedTest {
    static int PORT = 8615;

    @Test
    public void testMultipleHandlers() throws AnalysisRpcException {
        AnalysisRpcServer analysisRpcServer = null;
        try {
            analysisRpcServer = new AnalysisRpcServer(++PORT);
            analysisRpcServer.start();
            analysisRpcServer.addHandler("cat", new IAnalysisRpcHandler(){

                @Override
                public Object run(Object[] objectArray) {
                    return String.valueOf((String)objectArray[0]) + (String)objectArray[1];
                }
            });
            analysisRpcServer.addHandler("len", new IAnalysisRpcHandler(){

                @Override
                public Object run(Object[] objectArray) {
                    return (String.valueOf((String)objectArray[0]) + (String)objectArray[1]).length();
                }
            });
            AnalysisRpcClient analysisRpcClient = new AnalysisRpcClient(PORT);
            String string = (String)analysisRpcClient.request("cat", new Object[]{"Hello, ", "World!"});
            Assert.assertEquals((Object)"Hello, World!", (Object)string);
            int n = (Integer)analysisRpcClient.request("len", new Object[]{"Hello, ", "World!"});
            Assert.assertEquals((long)"Hello, World!".length(), (long)n);
        }
        finally {
            if (analysisRpcServer != null) {
                analysisRpcServer.shutdown();
            }
        }
    }

    @Test
    public void testExceptionOnHandlerFlattening() throws AnalysisRpcException {
        AnalysisRpcServer analysisRpcServer = null;
        try {
            analysisRpcServer = new AnalysisRpcServer(++PORT);
            analysisRpcServer.start();
            analysisRpcServer.addHandler("flaterror", new IAnalysisRpcHandler(){

                @Override
                public Object run(Object[] objectArray) {
                    return new Object();
                }
            });
            AnalysisRpcClient analysisRpcClient = new AnalysisRpcClient(PORT);
            try {
                analysisRpcClient.request("flaterror", new Object[]{"Hello"});
                Assert.fail((String)"No exception raised");
            }
            catch (AnalysisRpcException analysisRpcException) {
                Assert.assertFalse((boolean)(analysisRpcException.getCause() instanceof UnsupportedOperationException));
                Assert.assertEquals(Exception.class, analysisRpcException.getCause().getClass());
            }
        }
        finally {
            if (analysisRpcServer != null) {
                analysisRpcServer.shutdown();
            }
        }
    }

    @Test(expected=AnalysisRpcException.class, timeout=2000L)
    public void testConnectionTimesOutQuicklyEnough() throws AnalysisRpcException {
        AnalysisRpcClient analysisRpcClient = new AnalysisRpcClient(++PORT);
        analysisRpcClient.request("doesnotexist", new Object[]{"Hello"});
    }
}

