/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rpc;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.rpc.AnalysisRpcException;
import uk.ac.diamond.scisoft.analysis.rpc.IAnalysisRpcHandler;
import uk.ac.diamond.scisoft.analysis.rpc.flattening.TypedNone;
import uk.ac.diamond.scisoft.analysis.rpc.internal.TypeHelper;

public abstract class AbstractAnalysisRpcGenericDispatcher
implements IAnalysisRpcHandler {
    private static final Logger logger = LoggerFactory.getLogger(AbstractAnalysisRpcGenericDispatcher.class);
    private Class<?> delegate;

    public AbstractAnalysisRpcGenericDispatcher(Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("Instance must be non-null");
        }
        this.delegate = clazz;
    }

    protected boolean isMethodOk(Method method, String string, Class<?>[] classArray) {
        if (!method.getName().equals(string)) {
            return false;
        }
        Class<?>[] classArray2 = method.getParameterTypes();
        if (classArray2.length != classArray.length) {
            return false;
        }
        boolean bl = true;
        int n = 0;
        while (n < classArray2.length) {
            if (!(classArray[n] == null && !TypeHelper.isPrimitive(classArray2[n]) || classArray[n] != null && classArray2[n].isAssignableFrom(classArray[n]) || classArray[n] != null && TypeHelper.isBoxed(classArray[n], classArray2[n]))) {
                bl = false;
                break;
            }
            ++n;
        }
        return bl;
    }

    protected abstract Object getInvokeObject();

    private Object dispatch(String string, Object[] objectArray) throws AnalysisRpcException {
        Object object;
        Object[] objectArray2 = new Class[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] == null) {
                objectArray2[n] = null;
            } else if (objectArray[n] instanceof TypedNone) {
                objectArray2[n] = ((TypedNone)objectArray[n]).getType();
                objectArray[n] = null;
            } else {
                objectArray2[n] = objectArray[n].getClass();
            }
            ++n;
        }
        Method method = null;
        Method[] methodArray = this.delegate.getMethods();
        int n2 = methodArray.length;
        int n3 = 0;
        while (n3 < n2) {
            object = methodArray[n3];
            if (this.isMethodOk((Method)object, string, (Class<?>[])objectArray2)) {
                method = object;
                break;
            }
            ++n3;
        }
        if (method == null) {
            object = "Failed to find method " + this.delegate.toString() + "." + string + "(" + Arrays.toString(objectArray2) + ")";
            logger.error((String)object);
            throw new AnalysisRpcException((String)object);
        }
        try {
            return this.invoke(method, this.getInvokeObject(), objectArray);
        }
        catch (Exception exception) {
            String string2 = "Failed to invoke method " + this.delegate.toString() + "." + string + "(" + Arrays.toString(objectArray2) + ")";
            logger.error(string2, (Throwable)exception);
            if (exception instanceof InvocationTargetException) {
                throw new AnalysisRpcException(((InvocationTargetException)exception).getTargetException());
            }
            throw new AnalysisRpcException(exception);
        }
    }

    protected Object invoke(Method method, Object object, Object[] objectArray) throws Exception {
        return method.invoke(object, objectArray);
    }

    @Override
    public Object run(Object[] objectArray) throws AnalysisRpcException {
        String string = (String)objectArray[0];
        Object[] objectArray2 = new Object[objectArray.length - 1];
        System.arraycopy(objectArray, 1, objectArray2, 0, objectArray2.length);
        return this.dispatch(string, objectArray2);
    }
}

