/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.roi;

import java.io.Serializable;
import java.util.HashMap;
import uk.ac.diamond.scisoft.analysis.roi.ROIBase;

public class SectorROI
extends ROIBase
implements Serializable {
    private double[] rad;
    private double[] ang;
    private boolean clippingCompensation;
    private boolean combineSymmetry;
    private boolean averageArea = true;
    private double dpp;
    private int symmetry;
    public static final int NONE = 0;
    public static final int FULL = 1;
    public static final int XREFLECT = 2;
    public static final int YREFLECT = 3;
    public static final int CNINETY = 4;
    public static final int ACNINETY = 5;
    public static final int INVERT = 6;
    private static HashMap<Integer, String> symmetryText = new HashMap();

    static {
        symmetryText.put(0, "N");
        symmetryText.put(1, "Full");
        symmetryText.put(2, "L/R");
        symmetryText.put(3, "U/D");
        symmetryText.put(4, "+90");
        symmetryText.put(5, "-90");
        symmetryText.put(6, "I");
    }

    public void setClippingCompensation(boolean bl) {
        this.clippingCompensation = bl;
    }

    public boolean isClippingCompensation() {
        return this.clippingCompensation;
    }

    public void setSymmetry(int n) {
        this.symmetry = n;
    }

    public static int getSymmetry(String string) {
        if (symmetryText.containsValue(string)) {
            for (int n : symmetryText.keySet()) {
                if (!string.equals(symmetryText.get(n))) continue;
                return n;
            }
        }
        return 0;
    }

    public int getSymmetry() {
        return this.symmetry;
    }

    public SectorROI() {
        this(30.0, 120.0, 0.7853981633974483, 2.0943951023931953);
    }

    public SectorROI(double d, double d2, double d3, double d4) {
        this(0.0, 0.0, d, d2, d3, d4);
    }

    public SectorROI(double d, double d2, double d3, double d4, double d5, double d6) {
        this(d, d2, d3, d4, d5, d6, 1.0, false);
    }

    public SectorROI(double d, double d2, double d3, double d4, double d5, double d6, double d7, boolean bl) {
        this(d, d2, d3, d4, d5, d6, d7, bl, 0);
    }

    public SectorROI(double d, double d2, double d3, double d4, double d5, double d6, double d7, boolean bl, int n) {
        this.spt = new double[]{d, d2};
        this.rad = new double[]{d3, d4};
        this.ang = new double[]{d5, d6};
        this.dpp = d7;
        this.clippingCompensation = bl;
        this.symmetry = n;
        this.combineSymmetry = false;
        this.checkAngles();
    }

    public void setRadii(double[] dArray) {
        this.setRadii(dArray[0], dArray[1]);
    }

    public void setRadii(double d, double d2) {
        this.rad[0] = d;
        this.rad[1] = d2;
        this.checkRadii();
    }

    public double[] getRadii() {
        return this.rad;
    }

    public double getRadius(int n) {
        return this.rad[n];
    }

    public int[] getIntRadii() {
        return new int[]{(int)this.rad[0], (int)this.rad[1]};
    }

    public int getIntRadius(int n) {
        return (int)this.rad[n];
    }

    public void setAngles(double d, double d2) {
        this.ang[0] = d;
        this.ang[1] = d2;
        this.checkAngles();
    }

    public void setAngles(double[] dArray) {
        this.setAngles(dArray[0], dArray[1]);
    }

    public double[] getAnglesDegrees() {
        double[] dArray = new double[]{Math.toDegrees(this.ang[0]), Math.toDegrees(this.ang[1])};
        return dArray;
    }

    public double getAngleDegrees(int n) {
        return Math.toDegrees(this.ang[n]);
    }

    public void setAnglesDegrees(double[] dArray) {
        this.setAnglesDegrees(dArray[0], dArray[1]);
    }

    public void setAnglesDegrees(double d, double d2) {
        this.ang[0] = Math.toRadians(d);
        this.ang[1] = Math.toRadians(d2);
        this.checkAngles();
    }

    public double[] getAngles() {
        return this.ang;
    }

    public double getAngle(int n) {
        return this.ang[n];
    }

    public void addAngles(double d) {
        int n = 0;
        while (n < 2) {
            int n2 = n++;
            this.ang[n2] = this.ang[n2] + d;
        }
        if (this.ang[0] > Math.PI * 2) {
            this.ang[0] = this.ang[0] - Math.PI * 2;
            this.ang[1] = this.ang[1] - Math.PI * 2;
        }
        if (this.ang[0] < 0.0) {
            this.ang[0] = this.ang[0] + Math.PI * 2;
            this.ang[1] = this.ang[1] + Math.PI * 2;
        }
    }

    public void addAngle(int n, double d) {
        int n2 = n;
        this.ang[n2] = this.ang[n2] + d;
        this.checkAngles();
    }

    private void checkAngles() {
        while (this.ang[0] >= this.ang[1]) {
            this.ang[1] = this.ang[1] + Math.PI * 2;
        }
        while (this.ang[0] + Math.PI * 2 < this.ang[1]) {
            this.ang[1] = this.ang[1] - Math.PI * 2;
        }
        while (this.ang[0] < 0.0) {
            this.ang[0] = this.ang[0] + Math.PI * 2;
            this.ang[1] = this.ang[1] + Math.PI * 2;
        }
        while (this.ang[0] > Math.PI * 2) {
            this.ang[0] = this.ang[0] - Math.PI * 2;
            this.ang[1] = this.ang[1] - Math.PI * 2;
        }
    }

    public void addRadii(double d) {
        if (this.rad[0] + d < 0.0) {
            d = -this.rad[0];
        }
        if (this.rad[1] + d < 0.0) {
            d = -this.rad[1];
        }
        this.rad[0] = this.rad[0] + d;
        this.rad[1] = this.rad[1] + d;
    }

    public void addRadius(int n, double d) {
        int n2 = n;
        this.rad[n2] = this.rad[n2] + d;
        this.checkRadii();
    }

    private void checkRadii() {
        if (this.rad[0] < 0.0) {
            this.rad[0] = 0.0;
        }
        if (this.rad[1] < 0.0) {
            this.rad[1] = 0.0;
        }
        if (this.rad[0] > this.rad[1]) {
            this.rad[0] = this.rad[1];
        }
    }

    @Override
    public SectorROI copy() {
        SectorROI sectorROI = new SectorROI(this.spt[0], this.spt[1], this.rad[0], this.rad[1], this.ang[0], this.ang[1], this.dpp, this.clippingCompensation, this.symmetry);
        sectorROI.setCombineSymmetry(this.combineSymmetry);
        sectorROI.setPlot(this.plot);
        return sectorROI;
    }

    public boolean checkSymmetry(int n) {
        boolean bl = false;
        switch (n) {
            case 0: 
            case 1: {
                bl = true;
                break;
            }
            case 2: {
                if (0.0 <= this.ang[0] && this.ang[0] < 1.5707963267948966 && this.ang[0] <= this.ang[1] && this.ang[1] <= 1.5707963267948966) {
                    bl = true;
                    break;
                }
                if (1.5707963267948966 <= this.ang[0] && this.ang[0] <= 4.71238898038469 && this.ang[0] <= this.ang[1] && this.ang[1] <= 4.71238898038469) {
                    bl = true;
                    break;
                }
                if (!(4.71238898038469 <= this.ang[0]) || !(this.ang[0] <= Math.PI * 2) || !(this.ang[0] <= this.ang[1]) || !(this.ang[1] <= 7.853981633974483)) break;
                bl = true;
                break;
            }
            case 3: {
                if (0.0 <= this.ang[0] && this.ang[0] < Math.PI && this.ang[0] <= this.ang[1] && this.ang[1] <= Math.PI) {
                    bl = true;
                    break;
                }
                if (!(Math.PI <= this.ang[0]) || !(this.ang[0] <= Math.PI * 2) || !(this.ang[0] <= this.ang[1]) || !(this.ang[1] <= Math.PI * 2)) break;
                bl = true;
                break;
            }
            case 4: {
                if (!(this.ang[1] <= this.ang[0] + 1.5707963267948966)) break;
                bl = true;
                break;
            }
            case 5: {
                if (!(this.ang[0] >= this.ang[1] - 1.5707963267948966)) break;
                bl = true;
                break;
            }
            case 6: {
                if (!(this.ang[1] <= this.ang[0] + Math.PI)) break;
                bl = true;
            }
        }
        return bl;
    }

    public double[] getSymmetryAngles() {
        double[] dArray = new double[]{0.0, Math.PI * 2};
        switch (this.symmetry) {
            case 2: {
                dArray[0] = Math.PI - this.ang[1];
                dArray[1] = Math.PI - this.ang[0];
                break;
            }
            case 3: {
                dArray[0] = Math.PI * 2 - this.ang[1];
                dArray[1] = Math.PI * 2 - this.ang[0];
                break;
            }
            case 4: {
                dArray[0] = this.ang[0] + 1.5707963267948966;
                dArray[1] = this.ang[1] + 1.5707963267948966;
                break;
            }
            case 5: {
                dArray[0] = this.ang[0] - 1.5707963267948966;
                dArray[1] = this.ang[1] - 1.5707963267948966;
                break;
            }
            case 6: {
                dArray[0] = this.ang[0] + Math.PI;
                dArray[1] = this.ang[1] + Math.PI;
            }
        }
        return dArray;
    }

    public String getSymmetryText() {
        if (symmetryText.containsKey(this.symmetry)) {
            return symmetryText.get(this.symmetry);
        }
        return "N";
    }

    public void setCombineSymmetry(boolean bl) {
        this.combineSymmetry = bl;
    }

    public boolean isCombineSymmetry() {
        return this.combineSymmetry;
    }

    public double getDpp() {
        return this.dpp;
    }

    public void setDpp(double d) {
        this.dpp = d;
    }

    public boolean isAverageArea() {
        return this.averageArea;
    }

    public void setAverageArea(boolean bl) {
        this.averageArea = bl;
    }

    public boolean hasSeparateRegions() {
        return this.symmetry != 0 && this.symmetry != 1 && !this.combineSymmetry;
    }

    @Override
    public void downsample(double d) {
        this.spt[0] = this.spt[0] / d;
        this.spt[1] = this.spt[1] / d;
        this.rad[0] = this.rad[0] / d;
        this.rad[1] = this.rad[1] / d;
    }

    public String toString() {
        return String.format("Centre (%g, %g) Radii (%g,%g) Angles (%g, %g)", this.spt[0], this.spt[1], this.rad[0], this.rad[1], this.getAngleDegrees(0), this.getAngleDegrees(1));
    }
}

