/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.roi;

import org.junit.Assert;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.roi.GridPreferences;
import uk.ac.diamond.scisoft.analysis.roi.GridROI;
import uk.ac.diamond.scisoft.analysis.roi.LinearROI;
import uk.ac.diamond.scisoft.analysis.roi.ROIProfile;
import uk.ac.diamond.scisoft.analysis.roi.RectangularROI;
import uk.ac.diamond.scisoft.analysis.roi.SectorROI;

public class ROIProfileTest {
    @Test
    public void testLine() {
        DoubleDataset doubleDataset = new DoubleDataset(new double[]{1.0, 2.0, 3.0, 4.0}, 2, 2);
        LinearROI linearROI = new LinearROI(new double[]{0.0, 0.0}, new double[]{0.0, 1.0});
        AbstractDataset[] abstractDatasetArray = ROIProfile.line(doubleDataset, linearROI, 1.0);
        int n = 0;
        while (n < abstractDatasetArray.length) {
            DoubleDataset doubleDataset2 = (DoubleDataset)abstractDatasetArray[n];
            if (doubleDataset2 != null) {
                int n2 = 0;
                while (n2 < doubleDataset2.getSize()) {
                    Assert.assertTrue((String)"positive numbers expected in integration over positive dataset", (doubleDataset2.getAbs(n2) > 0.0 ? 1 : 0) != 0);
                    ++n2;
                }
            }
            ++n;
        }
    }

    @Test
    public void testBox() {
        DoubleDataset doubleDataset = new DoubleDataset(new double[]{0.0, 1.0, 2.0, 3.0}, 2, 2);
        RectangularROI rectangularROI = new RectangularROI(0.0, 0.0, 1.0, 1.0, 0.0);
        AbstractDataset[] abstractDatasetArray = ROIProfile.box(doubleDataset, rectangularROI);
        int n = 0;
        while (n < abstractDatasetArray.length) {
            DoubleDataset doubleDataset2 = (DoubleDataset)abstractDatasetArray[n];
            if (doubleDataset2 != null) {
                int n2 = 0;
                while (n2 < doubleDataset2.getSize()) {
                    Assert.assertTrue((String)"negative number in integration over non-negative dataset", (doubleDataset2.getAbs(n2) >= 0.0 ? 1 : 0) != 0);
                    ++n2;
                }
            }
            ++n;
        }
    }

    @Test
    public void testSector() {
        DoubleDataset doubleDataset = new DoubleDataset(new double[]{0.0, 1.0, 1.0, 1.0}, 2, 2);
        SectorROI sectorROI = new SectorROI(0.0, 0.0, 0.0, 3.0, 0.0, Math.PI * 2);
        AbstractDataset[] abstractDatasetArray = ROIProfile.sector(doubleDataset, sectorROI);
        int n = 0;
        while (n < abstractDatasetArray.length) {
            DoubleDataset doubleDataset2 = (DoubleDataset)abstractDatasetArray[n];
            if (doubleDataset2 != null) {
                int n2 = 0;
                while (n2 < doubleDataset2.getSize()) {
                    Assert.assertTrue((String)"negative number in integration over non-negative dataset", (doubleDataset2.getAbs(n2) >= 0.0 ? 1 : 0) != 0);
                    ++n2;
                }
            }
            ++n;
        }
    }

    @Test
    public void testGrid() {
        DoubleDataset doubleDataset = new DoubleDataset(new double[]{0.0, 1.0, 2.0, 3.0}, 2, 2);
        GridROI gridROI = new GridROI(0.0, 0.0, 1.0, 1.0, 0.0, 10.0, 10.0, false, false, new GridPreferences());
        AbstractDataset[] abstractDatasetArray = ROIProfile.box(doubleDataset, gridROI);
        int n = 0;
        while (n < abstractDatasetArray.length) {
            DoubleDataset doubleDataset2 = (DoubleDataset)abstractDatasetArray[n];
            if (doubleDataset2 != null) {
                int n2 = 0;
                while (n2 < doubleDataset2.getSize()) {
                    Assert.assertTrue((String)"negative number in integration over non-negative dataset", (doubleDataset2.getAbs(n2) >= 0.0 ? 1 : 0) != 0);
                    ++n2;
                }
            }
            ++n;
        }
    }
}

