/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.roi;

import java.io.Serializable;
import uk.ac.diamond.scisoft.analysis.roi.GridPreferences;
import uk.ac.diamond.scisoft.analysis.roi.RectangularROI;

public class GridROI
extends RectangularROI
implements Serializable {
    double xSpacing = 7.0;
    double ySpacing = 7.0;
    boolean midPointOn = true;
    boolean gridLinesOn = false;
    private GridPreferences gridPref = new GridPreferences();

    private GridROI() {
    }

    private GridROI(double d, double d2) {
        super(d, d2);
    }

    private GridROI(double d, double d2, double d3) {
        super(d, d2, d3);
    }

    private GridROI(double d, double d2, double d3, double d4, double d5) {
        super(d, d2, d3, d4, d5);
    }

    private GridROI(double d, double d2, double d3, double d4, double d5, boolean bl) {
        super(d, d2, d3, d4, d5, bl);
    }

    private GridROI(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        super(d, d2, d3, d4, d5, false);
        this.xSpacing = d6;
        this.ySpacing = d7;
    }

    public GridROI(double d, double d2, double d3, double d4, double d5, double d6, double d7, boolean bl, boolean bl2, GridPreferences gridPreferences) {
        this(d, d2, d3, d4, d5, d6, d7);
        this.gridLinesOn = bl;
        this.midPointOn = bl2;
        this.gridPref = gridPreferences;
    }

    public GridROI(GridPreferences gridPreferences) {
        this.gridPref = gridPreferences;
    }

    @Override
    public GridROI copy() {
        GridROI gridROI = new GridROI(this.getPoint()[0], this.getPoint()[1], this.getLengths()[0], this.getLengths()[1], this.getAngle(), this.xSpacing, this.ySpacing, this.gridLinesOn, this.midPointOn, this.gridPref);
        gridROI.setPlot(this.plot);
        return gridROI;
    }

    public double[] getSpacing() {
        return new double[]{this.xSpacing, this.ySpacing};
    }

    public int[] getIntSpacing() {
        return new int[]{(int)this.xSpacing, (int)this.ySpacing};
    }

    public double[][] getGridPoints() {
        double[] dArray = this.getLengths();
        double[] dArray2 = this.getPoint();
        int n = (int)(dArray[0] / this.xSpacing + 0.5);
        int n2 = (int)(dArray[1] / this.ySpacing + 0.5);
        double[] dArray3 = new double[n];
        double[] dArray4 = new double[n2];
        if (n != 0 && n2 != 0) {
            dArray3[0] = dArray2[0] + this.xSpacing / 2.0;
            dArray4[0] = dArray2[1] + this.ySpacing / 2.0;
            int n3 = 1;
            while (n3 < n) {
                dArray3[n3] = dArray3[0] + this.xSpacing * (double)n3;
                ++n3;
            }
            n3 = 1;
            while (n3 < n2) {
                dArray4[n3] = dArray4[0] + this.ySpacing * (double)n3;
                ++n3;
            }
        }
        double[][] dArrayArray = new double[][]{dArray3, dArray4};
        return dArrayArray;
    }

    public double[][] getGridLines() {
        double[][] dArray = this.getGridPoints();
        int n = dArray[0].length;
        int n2 = dArray[1].length;
        double[][] dArrayArray = new double[2][];
        if (this.getSpacing()[0] * (double)n >= this.getLengths()[0]) {
            if (--n < 0) {
                n = 0;
            }
            dArrayArray[0] = new double[n];
        } else {
            dArrayArray[0] = dArray[0];
        }
        if (this.getSpacing()[1] * (double)n2 >= this.getLengths()[1]) {
            if (--n2 < 0) {
                n2 = 0;
            }
            dArrayArray[1] = new double[n2];
        } else {
            dArrayArray[1] = dArray[1];
        }
        int n3 = 0;
        while (n3 < n) {
            dArrayArray[0][n3] = dArray[0][n3] + this.xSpacing / 2.0;
            ++n3;
        }
        n3 = 0;
        while (n3 < n2) {
            dArrayArray[1][n3] = dArray[1][n3] + this.ySpacing / 2.0;
            ++n3;
        }
        return dArrayArray;
    }

    public double getxSpacing() {
        return this.xSpacing;
    }

    public double getySpacing() {
        return this.ySpacing;
    }

    public void setxySpacing(double d, double d2) {
        this.xSpacing = d;
        this.ySpacing = d2;
    }

    public boolean isMidPointOn() {
        return this.midPointOn;
    }

    public void setMidPointOn(boolean bl) {
        this.midPointOn = bl;
    }

    public boolean isGridLineOn() {
        return this.gridLinesOn;
    }

    public void setGridLineOn(boolean bl) {
        this.gridLinesOn = bl;
    }

    public int getNumberOfPoints() {
        int[] nArray = this.getDimensions();
        return nArray[0] * nArray[1];
    }

    public int[] getDimensions() {
        double[][] dArray = this.getGridPoints();
        return new int[]{dArray[0].length, dArray[1].length};
    }

    public double[][] getPhysicalGridPoints() {
        double[][] dArray = this.getGridPoints();
        double[][] dArray2 = new double[this.getNumberOfPoints()][2];
        double d = Math.cos(this.getAngle());
        double d2 = Math.sin(this.getAngle());
        double[] dArray3 = this.getPoint();
        double[] dArray4 = this.getBeamCentre();
        double[] dArray5 = new double[]{this.gridPref.getResolutionX(), this.gridPref.getResolutionY()};
        int n = 0;
        double[] dArray6 = dArray[0];
        int n2 = dArray6.length;
        int n3 = 0;
        while (n3 < n2) {
            double d3 = dArray6[n3];
            double[] dArray7 = dArray[1];
            int n4 = dArray7.length;
            int n5 = 0;
            while (n5 < n4) {
                double d4 = dArray7[n5];
                dArray2[n][0] = dArray3[0] + (d3 - dArray3[0]) * d - (d4 - dArray3[1]) * d2;
                double[] dArray8 = dArray2[n];
                dArray8[0] = dArray8[0] - dArray4[0];
                double[] dArray9 = dArray2[n];
                dArray9[0] = dArray9[0] / dArray5[0];
                dArray2[n][1] = dArray3[1] + (d4 - dArray3[1]) * d + (d3 - dArray3[0]) * d2;
                double[] dArray10 = dArray2[n];
                dArray10[1] = dArray10[1] - dArray4[1];
                double[] dArray11 = dArray2[n];
                dArray11[1] = dArray11[1] / dArray5[1];
                ++n;
                ++n5;
            }
            ++n3;
        }
        return dArray2;
    }

    public double[] getBeamCentre() {
        return new double[]{this.gridPref.getBeamlinePosX(), this.gridPref.getBeamlinePosY()};
    }

    public double[] getPixelSizeM() {
        return new double[]{0.001 / this.gridPref.getResolutionX(), 0.001 / this.gridPref.getResolutionY()};
    }

    @Override
    public String toString() {
        String string = super.toString();
        return String.format("%s Spacing (%g, %g)", string, this.xSpacing, this.ySpacing);
    }

    public GridPreferences getGridPreferences() {
        return this.gridPref;
    }

    public void setGridPreferences(GridPreferences gridPreferences) {
        this.gridPref = gridPreferences;
    }
}

