/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.roi;

import java.io.Serializable;

public class GridPreferences
implements Serializable {
    private double gridScanResolutionX;
    private double gridScanResolutionY;
    private double gridScanBeamlinePosX;
    private double gridScanBeamlinePosY;

    public GridPreferences(double d, double d2, double d3, double d4) {
        this.gridScanResolutionX = d;
        this.gridScanResolutionY = d2;
        this.gridScanBeamlinePosX = d3;
        this.gridScanBeamlinePosY = d4;
    }

    public GridPreferences(GridPreferences gridPreferences) {
        this(gridPreferences.gridScanResolutionX, gridPreferences.gridScanResolutionY, gridPreferences.gridScanBeamlinePosX, gridPreferences.gridScanBeamlinePosY);
    }

    public GridPreferences() {
        this(10000.0, 10000.0, 0.0, 0.0);
    }

    public double getResolutionX() {
        return this.gridScanResolutionX;
    }

    public void setResolutionX(double d) {
        this.gridScanResolutionX = d;
    }

    public double getResolutionY() {
        return this.gridScanResolutionY;
    }

    public void setResolutionY(double d) {
        this.gridScanResolutionY = d;
    }

    public double getBeamlinePosX() {
        return this.gridScanBeamlinePosX;
    }

    public void setBeamlinePosX(double d) {
        this.gridScanBeamlinePosX = d;
    }

    public double getBeamlinePosY() {
        return this.gridScanBeamlinePosY;
    }

    public void setBeamlinePosY(double d) {
        this.gridScanBeamlinePosY = d;
    }

    public double getXPixelsPerMicron() {
        return this.getResolutionX() / 1000.0;
    }

    public double getYPixelsPerMicron() {
        return this.getResolutionY() / 1000.0;
    }

    public double getXMicronsFromPixelsCoord(double d) {
        return (d - this.getBeamlinePosX()) / this.getXPixelsPerMicron();
    }

    public double getYMicronsFromPixelsCoord(double d) {
        return (d - this.getBeamlinePosY()) / this.getYPixelsPerMicron();
    }

    public double getXPixelsFromMicronsCoord(double d) {
        return d * this.getXPixelsPerMicron() + this.getBeamlinePosX();
    }

    public double getYPixelsFromMicronsCoord(double d) {
        return d * this.getYPixelsPerMicron() + this.getBeamlinePosY();
    }

    public double getXMicronsFromPixelsLen(double d) {
        return d / this.getXPixelsPerMicron();
    }

    public double getYMicronsFromPixelsLen(double d) {
        return d / this.getYPixelsPerMicron();
    }

    public double getXPixelsFromMicronsLen(double d) {
        return d * this.getXPixelsPerMicron();
    }

    public double getYPixelsFromMicronsLen(double d) {
        return d * this.getYPixelsPerMicron();
    }
}

