/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.plotserver;

import gda.observable.IObserver;
import gda.observable.ObservableComponent;
import java.io.File;
import uk.ac.diamond.scisoft.analysis.plotserver.AbstractPlotServer;
import uk.ac.diamond.scisoft.analysis.plotserver.DataBean;
import uk.ac.diamond.scisoft.analysis.plotserver.FileOperationBean;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiBean;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiParameters;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiPlotMode;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiUpdate;

public class SimplePlotServer
extends AbstractPlotServer {
    private ObservableComponent observableComponent = new ObservableComponent();
    private String basePath = System.getProperty("gda.data");

    public void setBasePath(String string) {
        this.basePath = string;
    }

    protected String getDefaultDataDir() {
        return String.valueOf(this.basePath) + File.separator;
    }

    @Override
    public void setData(String string, DataBean dataBean) throws Exception {
        super.setData(string, dataBean);
        this.notifyIObservers(this, string);
    }

    @Override
    public void updateData(String string) throws Exception {
        this.notifyIObservers(this, string);
    }

    @Override
    public void updateGui(String string, GuiBean guiBean) throws Exception {
        super.updateGui(string, guiBean);
        this.respondToGui(string, guiBean);
        GuiUpdate guiUpdate = new GuiUpdate(string, guiBean);
        this.notifyIObservers(this, guiUpdate);
    }

    protected void respondToGui(String string, GuiBean guiBean) throws Exception {
        FileOperationBean fileOperationBean = null;
        fileOperationBean = (FileOperationBean)guiBean.get(GuiParameters.FILEOPERATION);
        if (fileOperationBean != null) {
            switch (fileOperationBean.getMode()) {
                case 1: {
                    break;
                }
                case 2: {
                    if (!guiBean.containsKey(GuiParameters.DISPLAYFILEONVIEW)) break;
                    String string2 = (String)((Object)guiBean.get(GuiParameters.DISPLAYFILEONVIEW));
                    DataBean dataBean = fileOperationBean.loadImage(false);
                    if (dataBean == null) break;
                    GuiBean guiBean2 = this.getGuiState(string);
                    if (!fileOperationBean.hasMultiplyFiles()) {
                        if (!guiBean2.containsKey(GuiParameters.PLOTMODE) || !guiBean2.get(GuiParameters.PLOTMODE).equals(GuiPlotMode.TWOD)) {
                            guiBean2 = new GuiBean();
                            guiBean2.put(GuiParameters.PLOTMODE, GuiPlotMode.TWOD);
                        }
                    } else if (!guiBean2.containsKey(GuiParameters.PLOTMODE) || !guiBean2.get(GuiParameters.PLOTMODE).equals(GuiPlotMode.MULTI2D)) {
                        guiBean2 = new GuiBean();
                        guiBean2.put(GuiParameters.PLOTMODE, GuiPlotMode.MULTI2D);
                    }
                    guiBean2.remove(GuiParameters.FILEOPERATION);
                    this.updateGui(string2, guiBean2);
                    this.setData(string2, dataBean);
                    break;
                }
                case 3: {
                    DataBean dataBean = fileOperationBean.loadImage(true);
                    if (dataBean == null) break;
                    this.setData(string, dataBean);
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    guiBean.put(GuiParameters.FILEOPERATION, fileOperationBean.chDir(this.basePath));
                    break;
                }
                case 7: {
                    fileOperationBean.deleteDir(String.valueOf(this.getDefaultDataDir()) + "GRIDVIEWDATA/");
                    break;
                }
            }
        }
    }

    public void addIObserver(IObserver iObserver) {
        this.observableComponent.addIObserver(iObserver);
    }

    public void deleteIObserver(IObserver iObserver) {
        this.observableComponent.deleteIObserver(iObserver);
    }

    public void deleteIObservers() {
        this.observableComponent.deleteIObservers();
    }

    public void notifyIObservers(Object object, Object object2) {
        this.observableComponent.notifyIObservers(object, object2);
    }

    @Override
    public boolean isServerLocal() {
        return true;
    }
}

