/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.plotserver;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.plotserver.AxisMapBean;
import uk.ac.diamond.scisoft.analysis.plotserver.DataBean;
import uk.ac.diamond.scisoft.analysis.plotserver.DataBeanException;
import uk.ac.diamond.scisoft.analysis.plotserver.DataSetWithAxisInformation;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiPlotMode;
import uk.ac.diamond.scisoft.analysis.utils.ImageThumbnailLoader;

public class FileOperationBean
implements Serializable {
    private String parent = null;
    private List<String> children = null;
    private String next = null;
    private String cwp = null;
    private List<String> files = null;
    private int mode;
    public static final int NOOP = 0;
    public static final int GETFILE = 1;
    public static final int GETIMAGEFILE = 2;
    public static final int GETIMAGEFILE_THUMB = 3;
    public static final int GETDIR = 4;
    public static final int UPDIR = 5;
    public static final int DNDIR = 6;
    public static final int DELETEGRIDIMGTEMPDIR = 7;

    public FileOperationBean() {
    }

    public FileOperationBean(int n) {
        this.mode = n;
    }

    public void setFiles(List<String> list) {
        this.files = list;
    }

    public List<String> getFiles() {
        return this.files;
    }

    public boolean hasMultiplyFiles() {
        return this.files != null && this.files.size() > 1;
    }

    public void setParent(String string) {
        this.parent = string;
    }

    public String getParent() {
        return this.parent;
    }

    public void setChildren(List<String> list) {
        this.children = list;
    }

    public List<String> getChildren() {
        return this.children;
    }

    public String getChild(int n) {
        return this.children.get(n);
    }

    public void setNext(String string) {
        this.next = string;
    }

    public String getNext() {
        return this.next;
    }

    public String getCwp() {
        return this.cwp;
    }

    public void setCwp(String string) {
        this.cwp = string;
    }

    public void setMode(int n) {
        this.mode = n;
    }

    public int getMode() {
        return this.mode;
    }

    public DataBean loadImage(boolean bl) {
        DataBean dataBean = new DataBean(GuiPlotMode.TWOD);
        for (String string : this.files) {
            AbstractDataset abstractDataset = ImageThumbnailLoader.loadImage(string, bl);
            DataSetWithAxisInformation dataSetWithAxisInformation = new DataSetWithAxisInformation();
            AxisMapBean axisMapBean = new AxisMapBean(AxisMapBean.DIRECT);
            dataSetWithAxisInformation.setData(abstractDataset);
            dataSetWithAxisInformation.setAxisMap(axisMapBean);
            try {
                dataBean.addData(dataSetWithAxisInformation);
            }
            catch (DataBeanException dataBeanException) {
                dataBeanException.printStackTrace();
            }
        }
        return dataBean;
    }

    public FileOperationBean chDir(String string) {
        Object object;
        try {
            string = new File(string).getCanonicalPath();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        FileOperationBean fileOperationBean = new FileOperationBean();
        File file = null;
        switch (this.mode) {
            case 4: {
                if (this.next == null) {
                    file = new File(string);
                    break;
                }
                file = new File(string, this.next);
                break;
            }
            case 5: {
                if (this.parent != null) {
                    file = new File(string, this.parent);
                    break;
                }
                if (this.cwp != null) {
                    file = new File(string);
                    break;
                }
                return this;
            }
            case 6: {
                if (this.cwp == null) {
                    file = new File(string, this.next);
                    break;
                }
                file = new File(string, this.cwp);
                try {
                    file = new File(file.getCanonicalPath(), this.next);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                break;
            }
            default: {
                return this;
            }
        }
        try {
            object = file.getCanonicalPath();
            if (((String)object).startsWith(string)) {
                if (((String)object).length() > string.length()) {
                    fileOperationBean.setCwp(((String)object).substring(string.length() + 1));
                }
            } else {
                fileOperationBean.setCwp((String)object);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (fileOperationBean.getCwp() != null) {
            try {
                object = file.getParentFile().getCanonicalPath();
                if (((String)object).startsWith(string)) {
                    if (((String)object).length() > string.length()) {
                        fileOperationBean.setParent(((String)object).substring(string.length() + 1));
                    }
                } else {
                    fileOperationBean.setParent((String)object);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        object = new ArrayList();
        ArrayList<String> arrayList = new ArrayList<String>();
        File[] fileArray = file.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file2 = fileArray[n2];
            if (file2.isDirectory()) {
                ((ArrayList)object).add(file2.getName());
            } else if (file2.isFile()) {
                arrayList.add(file2.getName());
            }
            ++n2;
        }
        fileOperationBean.setFiles(arrayList);
        fileOperationBean.setChildren((List<String>)object);
        fileOperationBean.setMode(0);
        return fileOperationBean;
    }

    public void deleteDir(String string) {
        File file = new File(string);
        if (file.exists()) {
            File[] fileArray = file.listFiles();
            int n = 0;
            while (n < fileArray.length) {
                fileArray[n].delete();
                ++n;
            }
            file.delete();
        }
    }
}

