/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.plotserver;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5File;
import uk.ac.diamond.scisoft.analysis.plotserver.AxisMapBean;
import uk.ac.diamond.scisoft.analysis.plotserver.DataBeanException;
import uk.ac.diamond.scisoft.analysis.plotserver.DataSetWithAxisInformation;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiBean;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiParameters;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiPlotMode;

public class DataBean
implements Serializable {
    private static final long serialVersionUID = -2033109932408452451L;
    protected List<DataSetWithAxisInformation> data;
    protected Map<String, AbstractDataset> axisData;
    protected List<HDF5File> hdf5Trees;
    protected GuiPlotMode guiPlotMode;
    protected GuiBean plotParameters;

    public DataBean(GuiPlotMode guiPlotMode) {
        this.guiPlotMode = guiPlotMode;
        this.data = new ArrayList<DataSetWithAxisInformation>();
        this.axisData = new HashMap<String, AbstractDataset>();
        this.hdf5Trees = new ArrayList<HDF5File>();
    }

    public DataBean() {
        this.guiPlotMode = null;
        this.data = new ArrayList<DataSetWithAxisInformation>();
        this.axisData = new HashMap<String, AbstractDataset>();
        this.hdf5Trees = new ArrayList<HDF5File>();
    }

    public DataBean copy() {
        DataBean dataBean = new DataBean();
        dataBean.data.addAll(this.data);
        dataBean.axisData.putAll(this.axisData);
        dataBean.hdf5Trees.addAll(this.hdf5Trees);
        dataBean.guiPlotMode = this.guiPlotMode;
        return dataBean;
    }

    public void addData(DataSetWithAxisInformation dataSetWithAxisInformation) throws DataBeanException {
        AxisMapBean axisMapBean = dataSetWithAxisInformation.getAxisMap();
        String[] stringArray = axisMapBean.getAxisID();
        if (stringArray != null) {
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray2[n2];
                if (!this.axisData.containsKey(string)) {
                    throw new DataBeanException();
                }
                ++n2;
            }
        }
        this.data.add(dataSetWithAxisInformation);
    }

    public void addAxis(String string, IDataset iDataset) {
        this.axisData.put(string, DatasetUtils.convertToAbstractDataset(iDataset));
    }

    public void addHDF5Tree(HDF5File hDF5File) {
        this.hdf5Trees.add(hDF5File);
    }

    public AbstractDataset getAxis(String string) {
        return this.axisData.get(string);
    }

    public List<DataSetWithAxisInformation> getData() {
        return this.data;
    }

    public void setData(List<DataSetWithAxisInformation> list) {
        this.data = list;
    }

    public List<HDF5File> getHDF5Trees() {
        return this.hdf5Trees;
    }

    public void setHDF5Trees(List<HDF5File> list) {
        this.hdf5Trees = list;
    }

    public Map<String, AbstractDataset> getAxisData() {
        return this.axisData;
    }

    public void setAxisData(Map<String, AbstractDataset> map) {
        this.axisData = map;
    }

    public GuiPlotMode getGuiPlotMode() {
        return this.guiPlotMode;
    }

    public void setGuiPlotMode(GuiPlotMode guiPlotMode) {
        this.guiPlotMode = guiPlotMode;
    }

    public void putGuiParameter(GuiParameters guiParameters, Serializable serializable) {
        if (this.plotParameters == null) {
            this.plotParameters = new GuiBean();
        }
        this.plotParameters.put(guiParameters, serializable);
    }

    public GuiBean getGuiParameters() {
        return this.plotParameters;
    }

    public String toString() {
        return "data =" + this.data.toString() + "\n" + "axisData = " + this.axisData.toString();
    }
}

