/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.optimize;

import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.fitting.functions.IFunction;
import uk.ac.diamond.scisoft.analysis.optimize.IOptimizer;

public class NelderMead
implements IOptimizer {
    double accuracy = 0.1;
    private static final Logger logger = LoggerFactory.getLogger(NelderMead.class);
    private double alpha = 1.0;
    private double gamma = 2.0;
    private double phi = 0.5;
    private double sigma = 0.5;
    private double startingSpread = 1.0;
    private int maxIterations = 2000;
    private Random random = new Random(0L);
    private IFunction function = null;
    DoubleDataset[] coordinates;
    DoubleDataset dataValues;

    public NelderMead() {
    }

    public NelderMead(double d) {
        this.accuracy = d;
    }

    public void setAccuracy(double d) {
        this.accuracy = d;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public void setAlpha(double d) {
        this.alpha = d;
    }

    public double getGamma() {
        return this.gamma;
    }

    public void setGamma(double d) {
        this.gamma = d;
    }

    public double getPhi() {
        return this.phi;
    }

    public void setPhi(double d) {
        this.phi = d;
    }

    public double getSigma() {
        return this.sigma;
    }

    public void setSigma(double d) {
        this.sigma = d;
    }

    public double getStartingSpread() {
        return this.startingSpread;
    }

    public void setStartingSpread(double d) {
        this.startingSpread = d;
    }

    @Override
    public void optimize(IDataset[] iDatasetArray, IDataset iDataset, IFunction iFunction) throws Exception {
        int n = iDatasetArray.length;
        this.coordinates = new DoubleDataset[n];
        int n2 = 0;
        while (n2 < n) {
            this.coordinates[n2] = (DoubleDataset)DatasetUtils.convertToAbstractDataset(iDatasetArray[n2]).cast(6);
            ++n2;
        }
        this.dataValues = (DoubleDataset)DatasetUtils.convertToAbstractDataset(iDataset).cast(6);
        this.function = iFunction;
        double[] dArray = this.optimise(iFunction.getParameterValues(), this.accuracy);
        iFunction.setParameterValues(dArray);
    }

    private double[] optimise(double[] dArray, double d) {
        double[] dArray2 = dArray;
        int n = 0;
        while (n < 5) {
            boolean bl = true;
            int n2 = 0;
            while (bl && n2 < 5) {
                Simplex simplex = new Simplex(dArray2, this.startingSpread);
                simplex.generateStartingFitnesses();
                int n3 = 0;
                do {
                    simplex.iterate();
                } while (simplex.improving(d) && ++n3 < this.maxIterations);
                dArray2 = simplex.getBestSolution();
                bl = simplex.hasCollapsed();
                ++n2;
            }
            if (n2 > 0) {
                logger.info("Error, the NelderMead simplex has collapsed, this minimisation may be flawed");
            }
            ++n;
        }
        return dArray2;
    }

    private class Simplex {
        private boolean collapsed = false;
        double[][] points;
        double[] fitnesses;
        double oldBest = 0.0;
        double oldSpread = 0.0;
        int reduceCount = 0;
        int contractCount = 0;
        int extendedCount = 0;
        int reflectedCount = 0;

        public int getReduceCount() {
            return this.reduceCount;
        }

        public int getContractCount() {
            return this.contractCount;
        }

        public int getExtendedCount() {
            return this.extendedCount;
        }

        public int getReflectedCount() {
            return this.reflectedCount;
        }

        public Simplex(double[] dArray, double d) {
            this.points = new double[dArray.length + 1][dArray.length];
            this.initialise(dArray, d);
        }

        public boolean hasCollapsed() {
            return this.collapsed;
        }

        public boolean improving(double d) {
            int[] nArray = this.sortFitnesses();
            double d2 = this.fitnesses[nArray[0]];
            double d3 = Math.abs(this.fitnesses[nArray[0]] - this.fitnesses[nArray[nArray.length - 1]]);
            if (d3 < d) {
                this.oldBest = d2;
                this.oldSpread = d3;
                return false;
            }
            if (d2 == this.oldBest && d3 == this.oldSpread) {
                this.collapsed = true;
                return false;
            }
            this.oldBest = d2;
            this.oldSpread = d3;
            return true;
        }

        public double[] getBestSolution() {
            int[] nArray = this.sortFitnesses();
            return this.points[nArray[0]];
        }

        public void iterate() {
            int[] nArray = this.sortFitnesses();
            double[] dArray = this.calculateCentreOfGravityIgnoringWorstValue(nArray);
            double[] dArray2 = this.calculateReflectedPoint(dArray, nArray);
            NelderMead.this.function.setParameterValues(dArray2);
            double d = NelderMead.this.function.residual(true, NelderMead.this.dataValues, NelderMead.this.coordinates);
            if (d < this.fitnesses[nArray[0]]) {
                double[] dArray3 = this.calculateExtendedPoint(dArray, nArray);
                NelderMead.this.function.setParameterValues(dArray3);
                double d2 = NelderMead.this.function.residual(true, NelderMead.this.dataValues, NelderMead.this.coordinates);
                if (d2 < d) {
                    this.replaceWorstPointWith(dArray3, d2, nArray);
                    return;
                }
                this.replaceWorstPointWith(dArray2, d, nArray);
                return;
            }
            double d3 = this.fitnesses[nArray[nArray.length - 2]];
            if (d > d3) {
                double[] dArray4 = this.calculateContractedPoint(dArray, nArray);
                NelderMead.this.function.setParameterValues(dArray4);
                double d4 = NelderMead.this.function.residual(true, NelderMead.this.dataValues, NelderMead.this.coordinates);
                if (d4 < this.fitnesses[nArray[nArray.length - 1]]) {
                    this.replaceWorstPointWith(dArray4, d4, nArray);
                    return;
                }
                this.reducePoints(nArray);
                return;
            }
            this.replaceWorstPointWith(dArray2, d, nArray);
        }

        private void reducePoints(int[] nArray) {
            ++this.reduceCount;
            int n = 1;
            while (n < nArray.length) {
                int n2 = 0;
                while (n2 < this.points[n].length) {
                    this.points[nArray[n]][n2] = this.points[nArray[0]][n2] + NelderMead.this.sigma * (this.points[nArray[n]][n2] - this.points[nArray[0]][n2]);
                    ++n2;
                }
                NelderMead.this.function.setParameterValues(this.points[nArray[n]]);
                this.fitnesses[nArray[n]] = NelderMead.this.function.residual(true, NelderMead.this.dataValues, NelderMead.this.coordinates);
                ++n;
            }
        }

        private double[] calculateContractedPoint(double[] dArray, int[] nArray) {
            ++this.contractCount;
            double[] dArray2 = new double[dArray.length];
            int n = nArray[nArray.length - 1];
            int n2 = 0;
            while (n2 < dArray2.length) {
                dArray2[n2] = dArray[n2] - NelderMead.this.phi * (dArray[n2] - this.points[n][n2]);
                ++n2;
            }
            return dArray2;
        }

        private void replaceWorstPointWith(double[] dArray, double d, int[] nArray) {
            int n = nArray[nArray.length - 1];
            int n2 = 0;
            while (n2 < dArray.length) {
                this.points[n][n2] = dArray[n2];
                ++n2;
            }
            this.fitnesses[n] = d;
        }

        private double[] calculateExtendedPoint(double[] dArray, int[] nArray) {
            ++this.extendedCount;
            double[] dArray2 = new double[dArray.length];
            int n = 0;
            while (n < dArray2.length) {
                dArray2[n] = dArray[n] + NelderMead.this.gamma * (dArray[n] - this.points[nArray[nArray.length - 1]][n]);
                ++n;
            }
            return dArray2;
        }

        private double[] calculateReflectedPoint(double[] dArray, int[] nArray) {
            ++this.reflectedCount;
            double[] dArray2 = new double[dArray.length];
            int n = nArray[nArray.length - 1];
            int n2 = 0;
            while (n2 < dArray2.length) {
                dArray2[n2] = dArray[n2] + NelderMead.this.alpha * (dArray[n2] - this.points[n][n2]);
                ++n2;
            }
            return dArray2;
        }

        private double[] calculateCentreOfGravityIgnoringWorstValue(int[] nArray) {
            double[] dArray = new double[this.points[0].length];
            int n = 0;
            while (n < dArray.length) {
                dArray[n] = 0.0;
                ++n;
            }
            n = 0;
            while (n < nArray.length - 1) {
                int n2 = 0;
                while (n2 < dArray.length) {
                    int n3 = n2;
                    dArray[n3] = dArray[n3] + this.points[nArray[n]][n2];
                    ++n2;
                }
                ++n;
            }
            n = 0;
            while (n < dArray.length) {
                dArray[n] = dArray[n] / (double)(nArray.length - 1);
                ++n;
            }
            return dArray;
        }

        private int[] sortFitnesses() {
            int[] nArray = new int[this.fitnesses.length];
            this.bubbleSort(nArray);
            return nArray;
        }

        private void bubbleSort(int[] nArray) {
            boolean bl = false;
            int n = 0;
            while (n < nArray.length) {
                nArray[n] = n;
                ++n;
            }
            while (!bl) {
                bl = true;
                n = 0;
                while (n < nArray.length - 1) {
                    if (this.fitnesses[nArray[n]] > this.fitnesses[nArray[n + 1]]) {
                        int n2 = nArray[n];
                        nArray[n] = nArray[n + 1];
                        nArray[n + 1] = n2;
                        bl = false;
                    }
                    ++n;
                }
            }
        }

        public void generateStartingFitnesses() {
            this.fitnesses = new double[this.points.length];
            int n = 0;
            while (n < this.fitnesses.length) {
                NelderMead.this.function.setParameterValues(this.points[n]);
                this.fitnesses[n] = NelderMead.this.function.residual(true, NelderMead.this.dataValues, NelderMead.this.coordinates);
                ++n;
            }
            int[] nArray = this.sortFitnesses();
            this.oldBest = this.fitnesses[nArray[0]];
            this.oldSpread = Math.abs(this.fitnesses[nArray[0]] - this.fitnesses[nArray[nArray.length - 1]]);
        }

        private void initialise(double[] dArray, double d) {
            int n = 0;
            while (n < this.points.length) {
                double[] dArray2 = this.createRandomUnitVector(dArray.length);
                int n2 = 0;
                while (n2 < dArray.length) {
                    this.points[n][n2] = dArray[n2] + dArray2[n2] * d;
                    ++n2;
                }
                ++n;
            }
        }

        private double[] createRandomUnitVector(int n) {
            double[] dArray = this.createRandomVector(n);
            double d = this.getVectorlength(dArray);
            int n2 = 0;
            while (n2 < dArray.length) {
                dArray[n2] = dArray[n2] / d;
                ++n2;
            }
            return dArray;
        }

        private double getVectorlength(double[] dArray) {
            double d = 0.0;
            int n = 0;
            while (n < dArray.length) {
                d += (double)(dArray.length * dArray.length);
                ++n;
            }
            return Math.sqrt(d);
        }

        private double[] createRandomVector(int n) {
            double[] dArray = new double[n];
            int n2 = 0;
            while (n2 < n) {
                dArray[n2] = NelderMead.this.random.nextDouble() - 0.5;
                ++n2;
            }
            return dArray;
        }
    }
}

