/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.optimize;

import Jama.Matrix;
import Jama.SingularValueDecomposition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.dataset.Maths;

public class LinearLeastSquares {
    private static final Logger logger = LoggerFactory.getLogger(LinearLeastSquares.class);
    private final double threshold;

    public LinearLeastSquares(double d) {
        this.threshold = d;
    }

    public double[] solve(AbstractDataset abstractDataset, AbstractDataset abstractDataset2, AbstractDataset abstractDataset3) {
        if (abstractDataset.getRank() != 2) {
            logger.error("Matrix was not 2D");
            throw new IllegalArgumentException("Matrix was not 2D");
        }
        int[] nArray = abstractDataset.getShape();
        int n = abstractDataset2.getShape()[0];
        if (abstractDataset2.getRank() != 1 && nArray[1] != n) {
            logger.error("Data was not 1D or else not correct length");
            throw new IllegalArgumentException("Data was not 2D or else not correct length");
        }
        Matrix matrix = new Matrix((double[][])DatasetUtils.createJavaArray(abstractDataset.cast(6)));
        Matrix matrix2 = new Matrix((double[][])DatasetUtils.createJavaArray(DatasetUtils.diag(Maths.reciprocal(abstractDataset3.cast(6)), 0)));
        Matrix matrix3 = matrix.transpose().times(matrix2);
        Matrix matrix4 = matrix3.times(matrix);
        SingularValueDecomposition singularValueDecomposition = matrix4.svd();
        double[] dArray = singularValueDecomposition.getSingularValues();
        Matrix matrix5 = new Matrix(n, n);
        int n2 = 0;
        while (n2 < n) {
            matrix5.set(n2, 0, abstractDataset2.getDouble(n2));
            ++n2;
        }
        Matrix matrix6 = singularValueDecomposition.getV().transpose().times(matrix3.times(matrix5));
        double d = this.threshold * dArray[0];
        int n3 = dArray.length;
        int n4 = 0;
        while (n4 < n3) {
            double d2 = dArray[n4];
            matrix6.set(n4, 0, d2 >= d ? matrix6.get(n4, 0) / d2 : 0.0);
            ++n4;
        }
        Matrix matrix7 = singularValueDecomposition.getU().times(matrix6);
        double[] dArray2 = new double[n3];
        int n5 = 0;
        while (n5 < n3) {
            dArray2[n5] = matrix7.get(n5, 0);
            ++n5;
        }
        return dArray2;
    }
}

