/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.optimize;

import Jama.Matrix;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.fitting.functions.IFunction;
import uk.ac.diamond.scisoft.analysis.optimize.IOptimizer;

public class LeastSquares
implements IOptimizer {
    private static final double PERT = 1.0E-4;

    public LeastSquares(double d) {
    }

    private double chiSquared(double[] dArray, IDataset iDataset, IDataset iDataset2, AbstractDataset abstractDataset, IFunction iFunction) {
        double d = 0.0;
        double[] dArray2 = iFunction.getParameterValues();
        iFunction.setParameterValues(dArray);
        int n = 0;
        while (n < iDataset.getSize()) {
            double d2 = (iDataset2.getDouble(n) - iFunction.val(iDataset.getDouble(n))) / abstractDataset.getDouble(n++);
            d += d2 * d2;
        }
        iFunction.setParameterValues(dArray2);
        return d;
    }

    private double alpha(int n, int n2, IDataset iDataset, AbstractDataset abstractDataset, IFunction iFunction) {
        double d = 0.0;
        int n3 = iDataset.getShape()[0];
        int n4 = 0;
        while (n4 < n3) {
            double d2 = 1.0 / Math.pow(abstractDataset.getDouble(n4), 2.0);
            d2 *= iFunction.partialDeriv(n, iDataset.getDouble(n4));
            d += (d2 *= iFunction.partialDeriv(n2, iDataset.getDouble(n4++)));
        }
        return d;
    }

    private double alphaPrime(int n, int n2, IDataset iDataset, AbstractDataset abstractDataset, IFunction iFunction, double d) {
        if (n == n2) {
            return this.alpha(n, n2, iDataset, abstractDataset, iFunction) * (1.0 + d);
        }
        return this.alpha(n, n2, iDataset, abstractDataset, iFunction);
    }

    private Matrix evaluateMatrix(IDataset iDataset, AbstractDataset abstractDataset, IFunction iFunction, double d) {
        int n = iFunction.getNoOfParameters();
        Matrix matrix = new Matrix(n, n);
        int n2 = 0;
        while (n2 < n) {
            int n3 = 0;
            while (n3 < n) {
                matrix.set(n2, n3, this.alphaPrime(n2, n3, iDataset, abstractDataset, iFunction, d));
                ++n3;
            }
            ++n2;
        }
        return matrix;
    }

    private double beta(int n, IDataset iDataset, IDataset iDataset2, AbstractDataset abstractDataset, IFunction iFunction) {
        double d;
        double d2;
        double[] dArray = iFunction.getParameterValues();
        double d3 = dArray[n];
        if (d3 != 0.0) {
            dArray[n] = d3 * 0.9999;
            d2 = this.chiSquared(dArray, iDataset, iDataset2, abstractDataset, iFunction);
            dArray[n] = d3 * 1.0001;
            d = this.chiSquared(dArray, iDataset, iDataset2, abstractDataset, iFunction);
            dArray[n] = d3;
        } else {
            dArray[n] = -1.0E-4;
            d2 = this.chiSquared(dArray, iDataset, iDataset2, abstractDataset, iFunction);
            dArray[n] = 1.0E-4;
            d = this.chiSquared(dArray, iDataset, iDataset2, abstractDataset, iFunction);
            dArray[n] = 0.0;
        }
        return -0.5 * (d - d2) / 2.0E-4;
    }

    private Matrix evaluateChiSquared(IDataset iDataset, IDataset iDataset2, AbstractDataset abstractDataset, IFunction iFunction) {
        int n = iFunction.getNoOfParameters();
        Matrix matrix = new Matrix(n, 1);
        int n2 = 0;
        while (n2 < n) {
            matrix.set(n2, 0, this.beta(n2, iDataset, iDataset2, abstractDataset, iFunction));
            ++n2;
        }
        return matrix;
    }

    private double[] solveDa(IDataset iDataset, IDataset iDataset2, AbstractDataset abstractDataset, IFunction iFunction, double d) {
        Matrix matrix = this.evaluateMatrix(iDataset, abstractDataset, iFunction, d);
        Matrix matrix2 = this.evaluateChiSquared(iDataset, iDataset2, abstractDataset, iFunction);
        Matrix matrix3 = matrix.inverse();
        matrix3 = matrix3.times(matrix2);
        double[] dArray = new double[iFunction.getNoOfParameters()];
        int n = 0;
        while (n < dArray.length) {
            dArray[n] = matrix3.get(n, 0);
            ++n;
        }
        return dArray;
    }

    @Override
    public void optimize(IDataset[] iDatasetArray, IDataset iDataset, IFunction iFunction) {
        AbstractDataset abstractDataset = AbstractDataset.ones(iDatasetArray[0].getShape(), 6);
        double[] dArray = iFunction.getParameterValues();
        double d = this.chiSquared(dArray, iDatasetArray[0], iDataset, abstractDataset, iFunction);
        double d2 = 0.001;
        double[] dArray2 = new double[dArray.length];
        int n = 0;
        while (n < 1) {
            double[] dArray3 = this.solveDa(iDatasetArray[0], iDataset, abstractDataset, iFunction, d2);
            int n2 = 0;
            while (n2 < dArray.length) {
                dArray2[n2] = dArray[n2] + dArray3[n2];
                ++n2;
            }
            double d3 = this.chiSquared(dArray2, iDatasetArray[0], iDataset, abstractDataset, iFunction);
            if (d3 >= d) {
                d2 *= 10.0;
            } else {
                d2 /= 10.0;
                d = d3;
                int n3 = 0;
                while (n3 < dArray.length) {
                    dArray[n3] = dArray2[n3];
                    ++n3;
                }
            }
            ++n;
        }
        iFunction.setParameterValues(dArray);
    }
}

