/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.optimize;

import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.fitting.functions.IFunction;
import uk.ac.diamond.scisoft.analysis.optimize.IOptimizer;

public class GradientDescent
implements IOptimizer {
    double qualityFactor = 0.1;
    private IFunction function = null;
    DoubleDataset[] coordinates;
    DoubleDataset dataValues;
    private double diffsize = 0.001;
    private double stepsize = 0.1;

    public GradientDescent() {
    }

    public GradientDescent(double d) {
        this.qualityFactor = d;
    }

    public void setAccuracy(double d) {
        this.qualityFactor = d;
    }

    @Override
    public void optimize(IDataset[] iDatasetArray, IDataset iDataset, IFunction iFunction) throws Exception {
        int n = iDatasetArray.length;
        this.coordinates = new DoubleDataset[n];
        int n2 = 0;
        while (n2 < n) {
            this.coordinates[n2] = (DoubleDataset)DatasetUtils.convertToAbstractDataset(iDatasetArray[n2]).cast(6);
            ++n2;
        }
        this.dataValues = (DoubleDataset)DatasetUtils.convertToAbstractDataset(iDataset).cast(6);
        this.function = iFunction;
        double[] dArray = this.optimise(iFunction.getParameterValues(), this.qualityFactor);
        iFunction.setParameterValues(dArray);
    }

    public double[] optimise(double[] dArray, double d) {
        double[] dArray2 = dArray;
        double[] dArray3 = (double[])dArray2.clone();
        int n = 0;
        while (n < dArray3.length) {
            dArray3[n] = 1.0;
            ++n;
        }
        double[] dArray4 = this.deriv(dArray2);
        while (this.stepsize > d * 0.1) {
            double[] dArray5 = this.deriv(dArray2);
            int n2 = 0;
            while (n2 < dArray3.length) {
                if (dArray5[n2] * dArray4[n2] < 0.0) {
                    int n3 = n2;
                    dArray3[n3] = dArray3[n3] * 0.5;
                } else {
                    int n4 = n2;
                    dArray3[n4] = dArray3[n4] * 1.1;
                }
                if (dArray3[n2] > 1.0) {
                    dArray3[n2] = 1.0;
                }
                ++n2;
            }
            dArray4 = dArray5;
            this.function.setParameterValues(dArray2);
            double d2 = this.function.residual(true, this.dataValues, this.coordinates);
            double[] dArray6 = (double[])dArray2.clone();
            int n5 = 0;
            while (n5 < dArray5.length) {
                int n6 = n5;
                dArray6[n6] = dArray6[n6] - dArray5[n5] * this.stepsize * dArray3[n5];
                ++n5;
            }
            this.function.setParameterValues(dArray6);
            double d3 = this.function.residual(true, this.dataValues, this.coordinates);
            if (d3 < d2) {
                dArray2 = dArray6;
                this.stepsize *= 1.1;
                continue;
            }
            this.stepsize *= 0.75;
        }
        return dArray2;
    }

    private double[] deriv(double[] dArray) {
        int n;
        double[] dArray2 = (double[])dArray.clone();
        double d = 0.0;
        boolean bl = false;
        block0: while (!bl) {
            bl = true;
            n = 0;
            while (n < dArray2.length) {
                double[] dArray3 = (double[])dArray.clone();
                double[] dArray4 = (double[])dArray.clone();
                int n2 = n;
                dArray3[n2] = dArray3[n2] + this.diffsize;
                int n3 = n;
                dArray4[n3] = dArray4[n3] - this.diffsize;
                this.function.setParameterValues(dArray3);
                double d2 = this.function.residual(true, this.dataValues, this.coordinates);
                this.function.setParameterValues(dArray4);
                double d3 = this.function.residual(true, this.dataValues, this.coordinates);
                dArray2[n] = (d2 - d3) * (2.0 * this.diffsize);
                if (dArray2[n] == 0.0) {
                    bl = false;
                    this.diffsize *= 1.5;
                    continue block0;
                }
                d += dArray2[n] * dArray2[n];
                ++n;
            }
        }
        d = Math.sqrt(d);
        n = 0;
        while (n < dArray2.length) {
            dArray2[n] = dArray2[n] / d;
            ++n;
        }
        return dArray2;
    }
}

