/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.optimize;

import org.apache.commons.math.random.JDKRandomGenerator;
import org.apache.commons.math.random.RandomDataImpl;
import org.apache.commons.math.random.RandomGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.fitting.functions.IFunction;
import uk.ac.diamond.scisoft.analysis.fitting.functions.IParameter;
import uk.ac.diamond.scisoft.analysis.optimize.IOptimizer;
import uk.ac.diamond.scisoft.analysis.optimize.IterationLimitException;

public class GeneticAlg
implements IOptimizer {
    protected static final transient Logger GAlogger = LoggerFactory.getLogger(GeneticAlg.class);
    private static final RandomGenerator generator = new JDKRandomGenerator();
    private static final RandomDataImpl prng = new RandomDataImpl(generator);
    private static final int MaxNumberOfStaticBestValue = 50;
    private double qualityFactor = 0.0;

    public GeneticAlg(double d) {
        this.qualityFactor = d;
    }

    public GeneticAlg(double d, Long l) {
        this.qualityFactor = d;
        if (l != null) {
            generator.setSeed(l.longValue());
        }
    }

    @Override
    public void optimize(IDataset[] iDatasetArray, IDataset iDataset, IFunction iFunction) {
        try {
            this.optimize(iDatasetArray, iDataset, iFunction, 10000);
        }
        catch (IterationLimitException iterationLimitException) {
            GAlogger.warn("Maximum number of itterations has been exceeded.  This solution may be suboptimal");
        }
    }

    public void optimize(IDataset[] iDatasetArray, IDataset iDataset, IFunction iFunction, int n) throws IterationLimitException {
        double d;
        int n2 = iFunction.getNoOfParameters();
        int n3 = n2 * 20;
        if (n3 < 100) {
            n3 = 100;
        }
        int n4 = iFunction.getNoOfFunctions();
        double[][] dArray = new double[n3][n2 + 1];
        double[][] dArray2 = new double[n3][n2 + 1];
        int n5 = 0;
        while (n5 < n2) {
            dArray[0][n5] = iFunction.getParameterValue(n5);
            ++n5;
        }
        n5 = 1;
        while (n5 < n3) {
            int n6 = 0;
            while (n6 < n2) {
                IParameter iParameter = iFunction.getParameter(n6);
                dArray[n5][n6] = prng.nextUniform(iParameter.getLowerLimit(), iParameter.getUpperLimit());
                ++n6;
            }
            ++n5;
        }
        n5 = 0;
        while (n5 < n3) {
            iFunction.setParameterValues(dArray[n5]);
            dArray[n5][n2] = iFunction.residual(true, iDataset, iDatasetArray);
            if (Double.valueOf(dArray[n5][n2]).isNaN()) {
                dArray[n5][n2] = Double.MAX_VALUE;
            }
            ++n5;
        }
        double d2 = d = Double.MAX_VALUE;
        int n7 = 0;
        int n8 = 0;
        while (d > this.qualityFactor) {
            double d3 = 0.0;
            double d4 = dArray[0][n2];
            int n9 = 0;
            int n10 = 1;
            while (n10 < n3) {
                if (dArray[n10][n2] < d4) {
                    d4 = dArray[n10][n2];
                    n9 = n10;
                }
                ++n10;
            }
            n10 = 0;
            while (n10 < n2) {
                dArray2[0][n10] = dArray[n9][n10];
                ++n10;
            }
            iFunction.setParameterValues(dArray2[0]);
            dArray2[0][n2] = iFunction.residual(true, iDataset, iDatasetArray);
            n10 = 1;
            while (n10 < n3) {
                int n11 = 0;
                int n12 = 0;
                int n13 = prng.nextInt(0, n3 - 1);
                int n14 = prng.nextInt(0, n3 - 1);
                int n15 = prng.nextInt(0, n3 - 1);
                int n16 = prng.nextInt(0, n3 - 1);
                while (Double.valueOf(dArray[n13][n2]).isNaN()) {
                    n13 = prng.nextInt(0, n3 - 1);
                }
                while (Double.valueOf(dArray[n14][n2]).isNaN()) {
                    n14 = prng.nextInt(0, n3 - 1);
                }
                while (Double.valueOf(dArray[n15][n2]).isNaN()) {
                    n15 = prng.nextInt(0, n3 - 1);
                }
                while (Double.valueOf(dArray[n16][n2]).isNaN()) {
                    n16 = prng.nextInt(0, n3 - 1);
                }
                n11 = dArray[n13][n2] < dArray[n14][n2] ? n13 : n14;
                n12 = dArray[n15][n2] < dArray[n16][n2] ? n15 : n16;
                int n17 = n4 > 1 ? prng.nextInt(0, n4 - 1) : prng.nextInt(0, n2 - 1);
                int n18 = n11;
                int n19 = 0;
                int n20 = 0;
                while (n20 < n4) {
                    if (n20 >= n17) {
                        n18 = n12;
                    }
                    int n21 = iFunction.getFunction(n20).getNoOfParameters();
                    int n22 = 0;
                    while (n22 < n21) {
                        dArray2[n10][n19] = dArray[n18][n19];
                        ++n19;
                        ++n22;
                    }
                    ++n20;
                }
                if (generator.nextDouble() > 0.5) {
                    n13 = prng.nextInt(0, n3 - 1);
                    n14 = prng.nextInt(0, n3 - 1);
                    n20 = 0;
                    while (n20 < n2) {
                        dArray2[n10][n20] = dArray2[n10][n20] + (dArray[n13][n20] - dArray[n14][n20]) * 0.5;
                        ++n20;
                    }
                }
                ++n10;
            }
            n10 = 0;
            while (n10 < n3) {
                int n23 = 0;
                while (n23 < n2) {
                    dArray[n10][n23] = dArray2[n10][n23];
                    IParameter iParameter = iFunction.getParameter(n23);
                    if (dArray[n10][n23] > iParameter.getUpperLimit()) {
                        dArray[n10][n23] = 2.0 * iParameter.getUpperLimit() - dArray[n10][n23];
                    }
                    if (dArray[n10][n23] < iParameter.getLowerLimit()) {
                        dArray[n10][n23] = 2.0 * iParameter.getLowerLimit() - dArray[n10][n23];
                    }
                    ++n23;
                }
                iFunction.setParameterValues(dArray[n10]);
                dArray[n10][n2] = iFunction.residual(true, iDataset, iDatasetArray);
                double d5 = dArray[n10][n2] - d3;
                d3 += d5 / (double)(n10 + 1);
                ++n10;
            }
            d = dArray[0][n2];
            n10 = 1;
            while (n10 < n3) {
                if (dArray[n10][n2] < d) {
                    d = dArray[0][n2];
                }
                ++n10;
            }
            if (++n8 > n) {
                throw new IterationLimitException("Too many itterations have been proformed, best available soulution has been provided");
            }
            if (d2 == d) {
                if (++n7 > 50) {
                    break;
                }
            } else {
                d2 = d;
                n7 = 0;
            }
            if (d == 0.0) break;
            d = Math.abs(d3 - d) / d;
        }
        d = dArray[0][n2];
        int n24 = 0;
        int n25 = 1;
        while (n25 < n3) {
            if (dArray[n25][n2] < d) {
                d = dArray[0][n2];
                n24 = n25;
            }
            ++n25;
        }
        iFunction.setParameterValues(dArray[n24]);
    }
}

