/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.optimize;

import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.analysis.MultivariateRealFunction;
import org.apache.commons.math.optimization.GoalType;
import org.apache.commons.math.optimization.RealPointValuePair;
import org.apache.commons.math.optimization.direct.MultiDirectional;
import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.fitting.functions.IFunction;
import uk.ac.diamond.scisoft.analysis.optimize.IOptimizer;

public class ApacheMultiDirectional
implements IOptimizer {
    @Override
    public void optimize(IDataset[] iDatasetArray, IDataset iDataset, final IFunction iFunction) throws Exception {
        int n = iDatasetArray.length;
        final DoubleDataset[] doubleDatasetArray = new DoubleDataset[n];
        int n2 = 0;
        while (n2 < n) {
            doubleDatasetArray[n2] = (DoubleDataset)DatasetUtils.convertToAbstractDataset(iDatasetArray[n2]).cast(6);
            ++n2;
        }
        final DoubleDataset doubleDataset = (DoubleDataset)DatasetUtils.convertToAbstractDataset(iDataset).cast(6);
        MultiDirectional multiDirectional = new MultiDirectional();
        MultivariateRealFunction multivariateRealFunction = new MultivariateRealFunction(){

            public double value(double[] dArray) throws FunctionEvaluationException, IllegalArgumentException {
                iFunction.setParameterValues(dArray);
                return iFunction.residual(true, doubleDataset, doubleDatasetArray);
            }
        };
        double[] dArray = iFunction.getParameterValues();
        RealPointValuePair realPointValuePair = multiDirectional.optimize(multivariateRealFunction, GoalType.MINIMIZE, dArray);
        iFunction.setParameterValues(realPointValuePair.getPoint());
    }
}

