/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.optimize;

import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.analysis.DifferentiableMultivariateRealFunction;
import org.apache.commons.math.analysis.MultivariateRealFunction;
import org.apache.commons.math.analysis.MultivariateVectorialFunction;
import org.apache.commons.math.optimization.GoalType;
import org.apache.commons.math.optimization.RealPointValuePair;
import org.apache.commons.math.optimization.general.ConjugateGradientFormula;
import org.apache.commons.math.optimization.general.NonLinearConjugateGradientOptimizer;
import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.fitting.functions.IFunction;
import uk.ac.diamond.scisoft.analysis.optimize.IOptimizer;

public class ApacheConjugateGradient
implements IOptimizer {
    @Override
    public void optimize(IDataset[] iDatasetArray, IDataset iDataset, final IFunction iFunction) throws Exception {
        int n = iDatasetArray.length;
        final DoubleDataset[] doubleDatasetArray = new DoubleDataset[n];
        int n2 = 0;
        while (n2 < n) {
            doubleDatasetArray[n2] = (DoubleDataset)DatasetUtils.convertToAbstractDataset(iDatasetArray[n2]).cast(6);
            ++n2;
        }
        final DoubleDataset doubleDataset = (DoubleDataset)DatasetUtils.convertToAbstractDataset(iDataset).cast(6);
        NonLinearConjugateGradientOptimizer nonLinearConjugateGradientOptimizer = new NonLinearConjugateGradientOptimizer(ConjugateGradientFormula.POLAK_RIBIERE);
        DifferentiableMultivariateRealFunction differentiableMultivariateRealFunction = new DifferentiableMultivariateRealFunction(){

            public double value(double[] dArray) throws FunctionEvaluationException, IllegalArgumentException {
                iFunction.setParameterValues(dArray);
                return iFunction.residual(true, doubleDataset, doubleDatasetArray);
            }

            public MultivariateRealFunction partialDerivative(final int n) {
                MultivariateRealFunction multivariateRealFunction = new MultivariateRealFunction(){

                    public double value(double[] dArray) throws FunctionEvaluationException, IllegalArgumentException {
                        double d = 0.1;
                        int n3 = n;
                        dArray[n3] = dArray[n3] - d;
                        iFunction.setParameterValues(dArray);
                        double d2 = iFunction.residual(true, doubleDataset, doubleDatasetArray);
                        int n2 = n;
                        dArray[n2] = dArray[n2] + 2.0 * d;
                        iFunction.setParameterValues(dArray);
                        double d3 = iFunction.residual(true, doubleDataset, doubleDatasetArray);
                        return -((d3 - d2) / (2.0 * d));
                    }
                };
                return multivariateRealFunction;
            }

            public MultivariateVectorialFunction gradient() {
                MultivariateVectorialFunction multivariateVectorialFunction = new MultivariateVectorialFunction(){

                    public double[] value(double[] dArray) throws FunctionEvaluationException, IllegalArgumentException {
                        double[] dArray2 = new double[dArray.length];
                        int n = 0;
                        while (n < dArray.length) {
                            dArray2[n] = this.partialDerivative(n).value(dArray);
                            ++n;
                        }
                        return dArray2;
                    }
                };
                return multivariateVectorialFunction;
            }
        };
        double[] dArray = iFunction.getParameterValues();
        RealPointValuePair realPointValuePair = nonLinearConjugateGradientOptimizer.optimize(differentiableMultivariateRealFunction, GoalType.MINIMIZE, dArray);
        iFunction.setParameterValues(realPointValuePair.getPoint());
    }
}

