/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io.tiff;

import it.tidalwave.imageio.io.RAWImageInputStream;
import it.tidalwave.imageio.raw.Packed12RasterReader;
import it.tidalwave.imageio.raw.RAWImageReaderSupport;
import it.tidalwave.imageio.raw.RasterReader;
import it.tidalwave.imageio.tiff.IFD;
import it.tidalwave.imageio.tiff.TIFFImageReaderSupport;
import it.tidalwave.imageio.tiff.TIFFMetadataSupport;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import java.io.IOException;
import javax.imageio.spi.ImageReaderSpi;

public class Grey12bitTIFFReader
extends TIFFImageReaderSupport {
    public Grey12bitTIFFReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi, IFD.class, TIFFMetadataSupport.class);
    }

    protected WritableRaster loadRAWRaster() throws IOException {
        IFD iFD = ((TIFFMetadataSupport)this.metadata).getPrimaryIFD();
        Grey12RasterReader grey12RasterReader = new Grey12RasterReader();
        int n = iFD.getImageWidth();
        int n2 = iFD.getImageLength();
        int n3 = iFD.getBitsPerSample()[0];
        this.initializeRasterReader(n, n2, n3, (RasterReader)grey12RasterReader);
        if (!iFD.isTileWidthAvailable()) {
            this.iis.seek((long)iFD.getStripOffsets());
        }
        WritableRaster writableRaster = grey12RasterReader.loadRaster(this.iis, (RAWImageReaderSupport)this);
        return writableRaster;
    }

    protected BufferedImage loadImage(int n) throws IOException {
        this.checkImageIndex(n);
        this.ensureMetadataIsLoaded(n);
        WritableRaster writableRaster = this.loadRAWRaster();
        int n2 = writableRaster.getWidth();
        int n3 = writableRaster.getHeight();
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 11);
        bufferedImage.setData(writableRaster);
        return bufferedImage;
    }

    protected void initializeRasterReader(int n, int n2, int n3, RasterReader rasterReader) {
        IFD iFD = ((TIFFMetadataSupport)this.metadata).getRasterIFD();
        rasterReader.setWidth(n);
        rasterReader.setHeight(n2);
        rasterReader.setBitsPerSample(n3);
        if (iFD != null && iFD.isCompressionAvailable()) {
            rasterReader.setCompression(iFD.getCompression().intValue());
        }
        if (iFD != null && iFD.isStripByteCountsAvailable()) {
            rasterReader.setStripByteCount(iFD.getStripByteCounts());
        }
        if (iFD != null && iFD.isTileWidthAvailable()) {
            int n4 = iFD.getImageWidth();
            int n5 = iFD.getImageLength();
            int n6 = iFD.getTileWidth();
            int n7 = iFD.getTileLength();
            rasterReader.setTileWidth(n6);
            rasterReader.setTileHeight(n7);
            rasterReader.setTilesAcross((n4 + n6 - 1) / n6);
            rasterReader.setTilesDown((n5 + n7 - 1) / n7);
            rasterReader.setTileOffsets(iFD.getTileOffsets());
        }
    }

    class Grey12RasterReader
    extends Packed12RasterReader {
        Grey12RasterReader() {
        }

        protected void loadUncompressedRaster(RAWImageInputStream rAWImageInputStream, WritableRaster writableRaster, RAWImageReaderSupport rAWImageReaderSupport) throws IOException {
            DataBufferUShort dataBufferUShort = (DataBufferUShort)writableRaster.getDataBuffer();
            short[] sArray = dataBufferUShort.getData();
            int n = writableRaster.getWidth();
            int n2 = writableRaster.getHeight();
            int n3 = n * 1;
            this.setBitsPerSample(12);
            this.selectBitReader(rAWImageInputStream, writableRaster, 12);
            int n4 = 0;
            while (n4 < n2) {
                int n5 = this.getRow(n4, n2);
                int n6 = n5 * n3;
                int n7 = 0;
                while (n7 < n) {
                    int n8 = (int)rAWImageInputStream.readBits(12);
                    sArray[n6] = (short)n8;
                    this.endOfColumn(n7, rAWImageInputStream);
                    ++n6;
                    ++n7;
                }
                rAWImageReaderSupport.processImageProgress(100.0f * (float)n4 / (float)n2);
                this.endOfRow(n4, rAWImageInputStream);
                ++n4;
            }
        }

        protected int[] getBandOffsets() {
            return new int[1];
        }
    }
}

