/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io.numpy;

import gda.analysis.io.ScanFileHolderException;
import java.io.File;
import java.util.Collection;
import java.util.LinkedList;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import uk.ac.diamond.scisoft.analysis.PythonHelper;
import uk.ac.diamond.scisoft.analysis.io.NumPyFileLoader;
import uk.ac.diamond.scisoft.analysis.io.numpy.NumPyTest;

@RunWith(value=Parameterized.class)
public class NumPyUnsupportedLoadTypesTest {
    private String numpyDataType;

    @Parameterized.Parameters
    public static Collection<Object[]> configs() {
        LinkedList<Object[]> linkedList = new LinkedList<Object[]>();
        linkedList.add(new Object[]{"'>i4'"});
        linkedList.add(new Object[]{"'<f12'"});
        linkedList.add(new Object[]{"'<c24'"});
        linkedList.add(new Object[]{"'|O4'"});
        return linkedList;
    }

    public NumPyUnsupportedLoadTypesTest(String string) {
        this.numpyDataType = string;
    }

    @Test(expected=ScanFileHolderException.class)
    public void testUnsupportedDataTypes() throws ScanFileHolderException, Exception {
        if (!PythonHelper.enablePythonTests()) {
            throw new ScanFileHolderException(null);
        }
        File file = NumPyTest.getTempFile();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("import numpy; ");
        stringBuilder.append("exp=numpy.array(1, dtype=" + this.numpyDataType + "); ");
        stringBuilder.append("numpy.save(r'" + file.toString() + "', exp)");
        PythonHelper.runPythonScript(stringBuilder.toString(), true);
        NumPyFileLoader.loadFileHelper(file.toString());
    }
}

