/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io.numpy;

import gda.analysis.io.ScanFileHolderException;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.commons.lang.ArrayUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import uk.ac.diamond.scisoft.analysis.PythonHelper;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.NumPyFileLoader;
import uk.ac.diamond.scisoft.analysis.io.NumPyFileSaver;

@RunWith(value=Parameterized.class)
public class NumPyTest {
    protected static final String PYTHON_NUMPY_PRINT_MATCHES = "print(exp.dtype==act.dtype and isinstance((exp==act), numpy.ndarray) and (exp==act).all())";
    static int[][] shapesToTest = new int[][]{{1}, {100}, {1000000}, {10, 10}, {5, 6, 7, 8}};
    static Object[][] types = new Object[][]{{"'|b1'", 0}, {"'|i1'", 1}, {"'<i2'", 2}, {"'<i4'", 3}, {"'<i8'", 4}, {"'<f4'", 5}, {"'<f8'", 6}, {"'<c8'", 7}, {"'<c16'", 8}};
    private int index = 0;
    private String numpyDataType;
    private int abstractDatasetDataType;
    private int[] shape;
    private String shapeStr;
    private int len;
    private boolean addInf;

    protected static File getTempFile() throws IOException {
        File file = File.createTempFile("scisoft", ".npy");
        file.deleteOnExit();
        return file;
    }

    protected static void saveNumPyFile(AbstractDataset abstractDataset, File file) throws ScanFileHolderException {
        DataHolder dataHolder = new DataHolder();
        dataHolder.addDataset("", abstractDataset);
        new NumPyFileSaver(file.toString()).saveFile(dataHolder);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> configs() {
        LinkedList<Object[]> linkedList = new LinkedList<Object[]>();
        int n = 0;
        int n2 = 0;
        while (n2 < types.length) {
            int n3 = 0;
            while (n3 < shapesToTest.length) {
                linkedList.add(new Object[]{n++, types[n2][0], types[n2][1], shapesToTest[n3], false});
                switch ((Integer)types[n2][1]) {
                    case 5: 
                    case 6: {
                        linkedList.add(new Object[]{n++, types[n2][0], types[n2][1], shapesToTest[n3], true});
                    }
                }
                ++n3;
            }
            ++n2;
        }
        return linkedList;
    }

    public NumPyTest(int n, String string, int n2, int[] nArray, boolean bl) {
        this.index = n;
        this.numpyDataType = string;
        this.abstractDatasetDataType = n2;
        this.shape = nArray;
        this.addInf = bl;
        this.len = 1;
        int n3 = 0;
        while (n3 < nArray.length) {
            this.len *= nArray[n3];
            ++n3;
        }
        this.shapeStr = ArrayUtils.toString((Object)nArray);
        this.shapeStr = this.shapeStr.substring(1, this.shapeStr.length() - 1);
    }

    public String toString() {
        return String.format("TEST %d: numpyType=%s datasetType=%d len=%d shape=%s", this.index, this.numpyDataType, this.abstractDatasetDataType, this.len, ArrayUtils.toString((Object)this.shape));
    }

    private AbstractDataset createDataset() {
        AbstractDataset abstractDataset;
        if (this.abstractDatasetDataType != 0) {
            abstractDataset = AbstractDataset.arange(this.len, this.abstractDatasetDataType);
        } else {
            boolean[] blArray = new boolean[this.len];
            if (this.len > 0) {
                blArray[0] = true;
            }
            if (this.len > 100) {
                blArray[100] = true;
            }
            abstractDataset = AbstractDataset.array((Object)blArray, this.abstractDatasetDataType);
        }
        if (this.addInf && this.len > 3) {
            abstractDataset.set(Double.POSITIVE_INFINITY, 2);
            abstractDataset.set(Double.NEGATIVE_INFINITY, 3);
        }
        abstractDataset.setShape(this.shape);
        return abstractDataset;
    }

    private String createNumPyArray(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("import numpy; ");
        if (this.abstractDatasetDataType != 0) {
            stringBuilder.append("exp=numpy.arange(" + this.len + ", dtype=" + this.numpyDataType + "); ");
        } else {
            stringBuilder.append("exp=numpy.array([False] * " + this.len + ", dtype=" + this.numpyDataType + "); ");
            if (this.len > 0) {
                stringBuilder.append("exp[0]=True; ");
            }
            if (this.len > 100) {
                stringBuilder.append("exp[100]=True; ");
            }
        }
        if (this.addInf && this.len > 3) {
            stringBuilder.append("exp[2]=float('Inf'); ");
            stringBuilder.append("exp[3]=-float('Inf'); ");
        }
        stringBuilder.append("exp.shape=" + this.shapeStr + "; ");
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    @Test
    public void testLoad() throws Exception {
        File file = NumPyTest.getTempFile();
        String string = this.createNumPyArray(" numpy.save(r'" + file.toString() + "', exp)");
        PythonHelper.runPythonScript(string, true);
        AbstractDataset abstractDataset = NumPyFileLoader.loadFileHelper(file.toString());
        AbstractDataset abstractDataset2 = this.createDataset();
        Assert.assertEquals((Object)abstractDataset2, (Object)abstractDataset);
    }

    @Test
    public void testSave() throws Exception {
        AbstractDataset abstractDataset = this.createDataset();
        File file = NumPyTest.getTempFile();
        NumPyTest.saveNumPyFile(abstractDataset, file);
        String string = this.createNumPyArray(" act=numpy.load(r'" + file.toString() + "');" + PYTHON_NUMPY_PRINT_MATCHES);
        String string2 = PythonHelper.runPythonScript(string, false);
        Assert.assertTrue((boolean)Boolean.parseBoolean(string2.trim()));
    }

    @Test
    public void testSaveAndLoad() throws Exception {
        AbstractDataset abstractDataset = this.createDataset();
        File file = NumPyTest.getTempFile();
        NumPyTest.saveNumPyFile(abstractDataset, file);
        AbstractDataset abstractDataset2 = NumPyFileLoader.loadFileHelper(file.toString());
        Assert.assertEquals((Object)abstractDataset, (Object)abstractDataset2);
    }
}

