/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io.numpy;

import gda.analysis.io.ScanFileHolderException;
import java.io.File;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.PythonHelper;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.NumPyFileSaver;
import uk.ac.diamond.scisoft.analysis.io.numpy.NumPyTest;

public class NumPySpecialsTest {
    @Test(expected=ScanFileHolderException.class)
    public void testExceptionOnRankOver255() throws Exception {
        int[] nArray = new int[500];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = 1;
            ++n;
        }
        AbstractDataset abstractDataset = AbstractDataset.ones(nArray, 6);
        NumPyTest.saveNumPyFile(abstractDataset, NumPyTest.getTempFile());
    }

    @Test(expected=ScanFileHolderException.class)
    public void testExceptionOnEmptyFile() throws Exception {
        AbstractDataset abstractDataset = AbstractDataset.ones(new int[]{2, 3}, 6);
        DataHolder dataHolder = new DataHolder();
        dataHolder.addDataset("", abstractDataset);
        new NumPyFileSaver("").saveFile(dataHolder);
    }

    @Test(expected=ScanFileHolderException.class)
    public void testExceptionOnNullFile() throws Exception {
        AbstractDataset abstractDataset = AbstractDataset.ones(new int[]{2, 3}, 6);
        DataHolder dataHolder = new DataHolder();
        dataHolder.addDataset("", abstractDataset);
        new NumPyFileSaver(null).saveFile(dataHolder);
    }

    @Test
    public void testSaveMultipleFiles() throws Exception {
        AbstractDataset abstractDataset = AbstractDataset.zeros(new int[]{20}, 6);
        AbstractDataset abstractDataset2 = AbstractDataset.ones(new int[]{20}, 6);
        DataHolder dataHolder = new DataHolder();
        dataHolder.addDataset("", abstractDataset);
        dataHolder.addDataset("", abstractDataset2);
        File file = NumPyTest.getTempFile();
        String string = file.toString();
        String string2 = string.substring(0, string.length() - ".npy".length());
        File file2 = new File(String.valueOf(string2) + "00001.npy");
        File file3 = new File(String.valueOf(string2) + "00002.npy");
        Assert.assertFalse((boolean)file2.exists());
        Assert.assertFalse((boolean)file3.exists());
        new NumPyFileSaver(string).saveFile(dataHolder);
        Assert.assertTrue((file2.exists() && file2.canRead() ? 1 : 0) != 0);
        Assert.assertTrue((file3.exists() && file3.canRead() ? 1 : 0) != 0);
        file2.deleteOnExit();
        file3.deleteOnExit();
        this.verifySave(0, file2);
        this.verifySave(1, file3);
    }

    private void verifySave(int n, File file) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("import numpy; ");
        stringBuilder.append("exp=numpy.array([" + n + "]*20, dtype=numpy.float64); ");
        stringBuilder.append("act=numpy.load(r'" + file.toString() + "');");
        stringBuilder.append("print(exp.dtype==act.dtype and isinstance((exp==act), numpy.ndarray) and (exp==act).all())");
        String string = PythonHelper.runPythonScript(stringBuilder.toString(), false);
        Assert.assertTrue((boolean)Boolean.parseBoolean(string.trim()));
    }
}

