/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io.numpy;

import java.io.File;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.commons.lang.ArrayUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import uk.ac.diamond.scisoft.analysis.PythonHelper;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.io.NumPyFileLoader;
import uk.ac.diamond.scisoft.analysis.io.numpy.NumPyTest;

@RunWith(value=Parameterized.class)
public class NumPyNanTest {
    private String numpyDataType;
    private int dtype;

    @Parameterized.Parameters
    public static Collection<Object[]> configs() {
        LinkedList<Object[]> linkedList = new LinkedList<Object[]>();
        linkedList.add(new Object[]{"'<f4'", 5});
        linkedList.add(new Object[]{"'<f8'", 6});
        return linkedList;
    }

    public NumPyNanTest(String string, int n) {
        this.numpyDataType = string;
        this.dtype = n;
    }

    @Test
    public void testLoad() throws Exception {
        File file = NumPyTest.getTempFile();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("import numpy; ");
        stringBuilder.append("exp=numpy.array([float('NaN')]*2, dtype=" + this.numpyDataType + "); ");
        stringBuilder.append("numpy.save(r'" + file.toString() + "', exp);");
        PythonHelper.runPythonScript(stringBuilder.toString(), true);
        AbstractDataset abstractDataset = NumPyFileLoader.loadFileHelper(file.toString());
        Assert.assertTrue((boolean)ArrayUtils.isEquals((Object)new int[]{2}, (Object)abstractDataset.getShape()));
        Assert.assertEquals((long)this.dtype, (long)abstractDataset.getDtype());
        Assert.assertTrue((boolean)Double.isNaN(abstractDataset.getDouble(0)));
        Assert.assertTrue((boolean)Double.isNaN(abstractDataset.getDouble(1)));
    }

    @Test
    public void testSave() throws Exception {
        AbstractDataset abstractDataset = AbstractDataset.array((Object)new double[]{Double.NaN, Double.NaN}, this.dtype);
        File file = NumPyTest.getTempFile();
        NumPyTest.saveNumPyFile(abstractDataset, file);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("import numpy; ");
        stringBuilder.append("exp=numpy.array([float('NaN')]*2, dtype=" + this.numpyDataType + "); ");
        stringBuilder.append("act=numpy.load(r'" + file.toString() + "');");
        stringBuilder.append("print(exp.dtype==act.dtype and exp.shape==act.shape and numpy.isnan(act[0]) and numpy.isnan(act[1]))");
        String string = PythonHelper.runPythonScript(stringBuilder.toString(), false);
        Assert.assertTrue((boolean)Boolean.parseBoolean(string.trim()));
    }
}

