/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io.emulated;

import gda.analysis.io.IFileLoader;
import gda.analysis.io.ScanFileHolderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.gda.monitor.IMonitor;

public class FileSystemEmulatingFileLoader
implements IFileLoader {
    private static final transient Logger logger = LoggerFactory.getLogger(FileSystemEmulatingFileLoader.class);
    private final IFileLoader loader;
    private long emulatedFileAvailableTimeMillis;
    private final long emulatedFileLoadTimeMillis;

    public FileSystemEmulatingFileLoader(IFileLoader iFileLoader, long l, long l2) {
        this.loader = iFileLoader;
        this.emulatedFileLoadTimeMillis = l2;
        long l3 = System.currentTimeMillis();
        this.emulatedFileAvailableTimeMillis = l3 + l;
    }

    @Override
    public DataHolder loadFile() throws ScanFileHolderException {
        this.waitForFileAvailable();
        long l = System.currentTimeMillis();
        DataHolder dataHolder = this.loader.loadFile();
        this.waitForFileLoaded(l);
        return dataHolder;
    }

    @Override
    public DataHolder loadFile(IMonitor iMonitor) throws ScanFileHolderException {
        this.waitForFileAvailable();
        long l = System.currentTimeMillis();
        DataHolder dataHolder = this.loader.loadFile(iMonitor);
        this.waitForFileLoaded(l);
        return dataHolder;
    }

    private void waitForFileAvailable() throws ScanFileHolderException {
        try {
            this.sleepUntil(this.emulatedFileAvailableTimeMillis);
        }
        catch (InterruptedException interruptedException) {
            throw new ScanFileHolderException("Interupted while sleeping to emulate file availability", interruptedException);
        }
    }

    private void waitForFileLoaded(long l) throws ScanFileHolderException {
        long l2 = System.currentTimeMillis() - l;
        if (l2 <= this.emulatedFileLoadTimeMillis) {
            try {
                Thread.sleep(this.emulatedFileLoadTimeMillis - l2);
            }
            catch (InterruptedException interruptedException) {
                throw new ScanFileHolderException("Interupted while sleeping to emulate file load time", interruptedException);
            }
        } else {
            logger.warn("File took longer to load ({}ms) than the desired emulated time ({}ms)", (Object)l2, (Object)this.emulatedFileLoadTimeMillis);
        }
    }

    private void sleepUntil(long l) throws InterruptedException {
        long l2 = l - System.currentTimeMillis();
        if (l2 > 0L) {
            Thread.sleep(l2);
        }
    }

    @Override
    public void setLoadMetadata(boolean bl) {
    }
}

