/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import gda.analysis.io.ScanFileHolderException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.SRSLoader;
import uk.ac.gda.monitor.IMonitor;

public class XasAsciiLoader
extends SRSLoader {
    public XasAsciiLoader(String string) {
        this.setFile(string);
    }

    @Override
    public DataHolder loadFile(IMonitor iMonitor) throws ScanFileHolderException {
        BufferedReader bufferedReader = null;
        try {
            String string;
            bufferedReader = new BufferedReader(new FileReader(this.fileName));
            String string2 = "";
            boolean bl = true;
            boolean bl2 = false;
            List[] listArray = null;
            while ((string = bufferedReader.readLine()) != null) {
                if (string.isEmpty()) continue;
                if (string.startsWith("#") && bl) {
                    this.readHeaderLine(string);
                    string2 = string;
                    continue;
                }
                bl = false;
                if (string.startsWith("#") && !bl) {
                    bl2 = true;
                    this.readFooterLine(string);
                    continue;
                }
                if (bl2) {
                    throw new ScanFileHolderException("Cannot read file");
                }
                if (listArray == null && this.datasetNames.size() == 0) {
                    listArray = this.parseHeaderString(string2);
                }
                XasAsciiLoader.parseColumns(this.splitLine(string.trim()), listArray);
            }
            String[] stringArray = this.datasetNames.toArray(new String[0]);
            DataHolder dataHolder = new DataHolder();
            try {
                XasAsciiLoader.convertToDatasets(dataHolder, stringArray, listArray, this.isStoreStringValues(), this.isUseImageLoaderForStrings(), new File(this.fileName).getParent());
            }
            catch (Exception exception) {
                logger.warn(exception.getMessage());
            }
            DataHolder dataHolder2 = dataHolder;
            return dataHolder2;
        }
        catch (Exception exception) {
            throw new ScanFileHolderException("XasAsciiLoader.loadFile exception loading  " + this.fileName, exception);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                throw new ScanFileHolderException("Cannot read file", iOException);
            }
        }
    }

    private List<?>[] parseHeaderString(String string) {
        string = string.substring(1).trim();
        String[] stringArray = this.splitLine(string);
        this.datasetNames.clear();
        this.datasetNames.addAll(Arrays.asList(stringArray));
        return new List[stringArray.length];
    }

    private String[] splitLine(String string) {
        return string.split("[\t ]+");
    }

    private void readFooterLine(String string) {
        this.readHeaderLine(string);
    }

    private void readHeaderLine(String string) {
        int n = (string = string.trim().substring(1)).indexOf(":");
        if (n == -1) {
            return;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        this.textMetadata.put(string2.trim(), string3.trim());
    }

    @Override
    public void loadMetaData(IMonitor iMonitor) throws Exception {
    }

    @Override
    public void saveFile(DataHolder dataHolder) throws ScanFileHolderException {
    }
}

