/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.io.Utils;

public class UtilsTest {
    static int answer = -559038737;
    static int sLeAnswer = 48879;
    static int sBeAnswer = 57005;
    static byte[] leAnswer = new byte[]{-17, -66, -83, -34};
    static byte[] beAnswer = new byte[]{-34, -83, -66, -17};

    @Test
    public void testLeInt() {
        int n = Utils.leInt(239, 190, 173, 222);
        Assert.assertEquals((double)answer, (double)n, (double)1.0E-8);
    }

    @Test
    public void testBeInt() {
        int n = Utils.beInt(222, 173, 190, 239);
        Assert.assertEquals((double)answer, (double)n, (double)1.0E-8);
    }

    @Test
    public void testLeIntSigns() {
        int n = Utils.leIntSE(255, -1);
        Assert.assertEquals((double)-1.0, (double)n, (double)1.0E-8);
        n = Utils.leInt(255, -1);
        Assert.assertEquals((double)65535.0, (double)n, (double)1.0E-8);
    }

    @Test
    public void testReadLeInt() throws Exception {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(leAnswer);
        int n = Utils.readLeInt(byteArrayInputStream);
        Assert.assertEquals((double)answer, (double)n, (double)1.0E-8);
    }

    @Test
    public void testReadBeInt() throws Exception {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(beAnswer);
        int n = Utils.readBeInt(byteArrayInputStream);
        Assert.assertEquals((double)answer, (double)n, (double)1.0E-8);
    }

    @Test
    public void testReadLeShort() throws Exception {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(leAnswer);
        int n = Utils.readLeShort(byteArrayInputStream);
        Assert.assertEquals((double)sLeAnswer, (double)n, (double)1.0E-8);
    }

    @Test
    public void testReadBeShort() throws Exception {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(beAnswer);
        int n = Utils.readBeShort(byteArrayInputStream);
        Assert.assertEquals((double)sBeAnswer, (double)n, (double)1.0E-8);
    }

    @Test
    public void testWriteLeInt() throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Utils.writeLeInt(byteArrayOutputStream, answer);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        Assert.assertArrayEquals((byte[])leAnswer, (byte[])byArray);
    }

    @Test
    public void testWriteBeInt() throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Utils.writeBeInt(byteArrayOutputStream, answer);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        Assert.assertArrayEquals((byte[])beAnswer, (byte[])byArray);
    }
}

