/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import uk.ac.diamond.scisoft.analysis.dataset.FloatDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IntegerDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ShortDataset;
import uk.ac.diamond.scisoft.analysis.io.SRSLoader;

public class Utils {
    public static int leInt(int ... nArray) {
        int n = 0;
        int n2 = nArray.length - 1;
        while (n2 >= 0) {
            n <<= 8;
            n |= nArray[n2] & 0xFF;
            --n2;
        }
        return n;
    }

    public static int leInt(int n, int n2) {
        return (n2 & 0xFF) << 8 | n & 0xFF;
    }

    public static int leIntSE(int n, int n2) {
        return n2 << 8 | n & 0xFF;
    }

    public static int leInt(int n, int n2, int n3, int n4) {
        return (n4 & 0xFF) << 24 | (n3 & 0xFF) << 16 | (n2 & 0xFF) << 8 | n & 0xFF;
    }

    public static int beInt(int ... nArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            n <<= 8;
            n |= nArray[n2] & 0xFF;
            ++n2;
        }
        return n;
    }

    public static int beInt(int n, int n2) {
        return (n & 0xFF) << 8 | n2 & 0xFF;
    }

    public static int beIntSE(int n, int n2) {
        return n << 8 | n2 & 0xFF;
    }

    public static int beInt(int n, int n2, int n3, int n4) {
        return (n & 0xFF) << 24 | (n2 & 0xFF) << 16 | (n3 & 0xFF) << 8 | n4 & 0xFF;
    }

    public static int readLeInt(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        int n2 = inputStream.read();
        int n3 = inputStream.read();
        int n4 = inputStream.read();
        return Utils.leInt(n, n2, n3, n4);
    }

    public static int readBeInt(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        int n2 = inputStream.read();
        int n3 = inputStream.read();
        int n4 = inputStream.read();
        return Utils.beInt(n, n2, n3, n4);
    }

    public static int readLeShort(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        int n2 = inputStream.read();
        return Utils.leInt(n, n2);
    }

    public static int readBeShort(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        int n2 = inputStream.read();
        return Utils.beInt(n, n2);
    }

    public static void writeLeInt(OutputStream outputStream, int n) throws IOException {
        byte[] byArray = new byte[]{(byte)(n & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 24 & 0xFF)};
        outputStream.write(byArray);
    }

    public static void writeBeInt(OutputStream outputStream, int n) throws IOException {
        byte[] byArray = new byte[]{(byte)(n >> 24 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
        outputStream.write(byArray);
    }

    public static void readLeInt(InputStream inputStream, IntegerDataset integerDataset, int n) throws IOException {
        int n2;
        int n3 = integerDataset.getSize();
        int[] nArray = integerDataset.getData();
        byte[] byArray = new byte[n + 4 * n3];
        inputStream.read(byArray);
        int n4 = Integer.MIN_VALUE;
        int n5 = Integer.MAX_VALUE;
        int n6 = 0;
        int n7 = n;
        int n8 = 0;
        while (n8 < n3) {
            n2 = Utils.leInt((int)byArray[n7], (int)byArray[n7 + 1], (int)byArray[n7 + 2], (int)byArray[n7 + 3]);
            n6 = n6 * 19 + n2;
            nArray[n8] = n2;
            if (n2 > n4) {
                n4 = n2;
            }
            if (n2 < n5) {
                n5 = n2;
            }
            n7 += 4;
            ++n8;
        }
        n6 = n6 * 19 + integerDataset.getDtype() * 17 + integerDataset.getElementsPerItem();
        int[] nArray2 = integerDataset.getShape();
        n2 = nArray2.length;
        int n9 = 0;
        while (n9 < n2) {
            n6 = n6 * 17 + nArray2[n9];
            ++n9;
        }
        integerDataset.setStoredValue("max", n4);
        integerDataset.setStoredValue("min", n5);
        integerDataset.setStoredValue("hash", n6);
    }

    public static void readBeInt(InputStream inputStream, IntegerDataset integerDataset, int n) throws IOException {
        int n2;
        int n3 = integerDataset.getSize();
        int[] nArray = integerDataset.getData();
        byte[] byArray = new byte[n + 4 * n3];
        inputStream.read(byArray);
        int n4 = Integer.MIN_VALUE;
        int n5 = Integer.MAX_VALUE;
        int n6 = 0;
        int n7 = n;
        int n8 = 0;
        while (n8 < n3) {
            n2 = Utils.beInt((int)byArray[n7], (int)byArray[n7 + 1], (int)byArray[n7 + 2], (int)byArray[n7 + 3]);
            n6 = n6 * 19 + n2;
            nArray[n8] = n2;
            if (n2 > n4) {
                n4 = n2;
            }
            if (n2 < n5) {
                n5 = n2;
            }
            n7 += 4;
            ++n8;
        }
        n6 = n6 * 19 + integerDataset.getDtype() * 17 + integerDataset.getElementsPerItem();
        int[] nArray2 = integerDataset.getShape();
        n2 = nArray2.length;
        int n9 = 0;
        while (n9 < n2) {
            n6 = n6 * 17 + nArray2[n9];
            ++n9;
        }
        integerDataset.setStoredValue("max", n4);
        integerDataset.setStoredValue("min", n5);
        integerDataset.setStoredValue("hash", n6);
    }

    public static void readBeShort(InputStream inputStream, IntegerDataset integerDataset, int n, boolean bl) throws IOException {
        int n2;
        int n3;
        int n4 = integerDataset.getSize();
        int[] nArray = integerDataset.getData();
        byte[] byArray = new byte[2 * n4 + n];
        inputStream.read(byArray);
        int n5 = Integer.MIN_VALUE;
        int n6 = Integer.MAX_VALUE;
        int n7 = 0;
        int n8 = n;
        if (bl) {
            n3 = 0;
            while (n3 < n4) {
                n2 = Utils.beIntSE(byArray[n8], byArray[n8 + 1]);
                n7 = n7 * 19 + n2;
                nArray[n3] = n2;
                if (n2 > n5) {
                    n5 = n2;
                }
                if (n2 < n6) {
                    n6 = n2;
                }
                n8 += 2;
                ++n3;
            }
        } else {
            n3 = 0;
            while (n3 < n4) {
                n2 = Utils.beInt((int)byArray[n8], (int)byArray[n8 + 1]);
                n7 = n7 * 19 + n2;
                nArray[n3] = n2;
                if (n2 > n5) {
                    n5 = n2;
                }
                if (n2 < n6) {
                    n6 = n2;
                }
                n8 += 2;
                ++n3;
            }
        }
        n7 = n7 * 19 + integerDataset.getDtype() * 17 + integerDataset.getElementsPerItem();
        int[] nArray2 = integerDataset.getShape();
        n2 = nArray2.length;
        int n9 = 0;
        while (n9 < n2) {
            n7 = n7 * 17 + nArray2[n9];
            ++n9;
        }
        integerDataset.setStoredValue("max", n5);
        integerDataset.setStoredValue("min", n6);
        integerDataset.setStoredValue("hash", n7);
    }

    public static void readLeShort(InputStream inputStream, IntegerDataset integerDataset, int n, boolean bl) throws IOException {
        int n2;
        int n3;
        int n4 = integerDataset.getSize();
        int[] nArray = integerDataset.getData();
        byte[] byArray = new byte[2 * n4 + n];
        inputStream.read(byArray);
        int n5 = Integer.MIN_VALUE;
        int n6 = Integer.MAX_VALUE;
        int n7 = 0;
        int n8 = n;
        if (bl) {
            n3 = 0;
            while (n3 < n4) {
                n2 = Utils.leIntSE(byArray[n8], byArray[n8 + 1]);
                n7 = n7 * 19 + n2;
                nArray[n3] = n2;
                if (n2 > n5) {
                    n5 = n2;
                }
                if (n2 < n6) {
                    n6 = n2;
                }
                n8 += 2;
                ++n3;
            }
        } else {
            n3 = 0;
            while (n3 < n4) {
                n2 = Utils.leInt((int)byArray[n8], (int)byArray[n8 + 1]);
                n7 = n7 * 19 + n2;
                nArray[n3] = n2;
                if (n2 > n5) {
                    n5 = n2;
                }
                if (n2 < n6) {
                    n6 = n2;
                }
                n8 += 2;
                ++n3;
            }
        }
        n7 = n7 * 19 + integerDataset.getDtype() * 17 + integerDataset.getElementsPerItem();
        int[] nArray2 = integerDataset.getShape();
        n2 = nArray2.length;
        int n9 = 0;
        while (n9 < n2) {
            n7 = n7 * 17 + nArray2[n9];
            ++n9;
        }
        integerDataset.setStoredValue("max", n5);
        integerDataset.setStoredValue("min", n6);
        integerDataset.setStoredValue("hash", n7);
    }

    public static void readByte(InputStream inputStream, ShortDataset shortDataset, int n) throws IOException {
        int n2;
        int n3 = shortDataset.getSize();
        short[] sArray = shortDataset.getData();
        byte[] byArray = new byte[n3 + n];
        inputStream.read(byArray);
        int n4 = Short.MIN_VALUE;
        int n5 = Short.MAX_VALUE;
        int n6 = 0;
        int n7 = n;
        int n8 = 0;
        while (n8 < n3) {
            n2 = byArray[n7] & 0xFF;
            n6 = n6 * 19 + n2;
            sArray[n8] = n2;
            if (n2 > n4) {
                n4 = n2;
            }
            if (n2 < n5) {
                n5 = n2;
            }
            ++n7;
            ++n8;
        }
        n6 = n6 * 19 + shortDataset.getDtype() * 17 + shortDataset.getElementsPerItem();
        int[] nArray = shortDataset.getShape();
        n2 = nArray.length;
        int n9 = 0;
        while (n9 < n2) {
            n6 = n6 * 17 + nArray[n9];
            ++n9;
        }
        shortDataset.setStoredValue("max", (short)n4);
        shortDataset.setStoredValue("min", (short)n5);
        shortDataset.setStoredValue("hash", n6);
    }

    public static void readFloat(InputStream inputStream, FloatDataset floatDataset, int n) throws IOException {
        int n2 = floatDataset.getSize();
        float[] fArray = floatDataset.getData();
        byte[] byArray = new byte[4 * n2 + n];
        inputStream.read(byArray);
        byte[] byArray2 = new byte[4];
        float f = Float.MIN_VALUE;
        float f2 = Float.MAX_VALUE;
        double d = 0.0;
        int n3 = n;
        int n4 = 0;
        while (n4 < n2) {
            byArray2[0] = byArray[n3 + 3];
            byArray2[1] = byArray[n3 + 2];
            byArray2[2] = byArray[n3 + 1];
            byArray2[3] = byArray[n3];
            float f3 = ByteBuffer.wrap(byArray2).getFloat();
            d = d * 19.0 + (double)f3;
            fArray[n4] = f3;
            if (f3 > f) {
                f = f3;
            }
            if (f3 < f2) {
                f2 = f3;
            }
            n3 += 4;
            ++n4;
        }
        d = d * 19.0 + (double)(floatDataset.getDtype() * 17) + (double)floatDataset.getElementsPerItem();
        int[] nArray = floatDataset.getShape();
        int n5 = nArray.length;
        int n6 = 0;
        while (n6 < n5) {
            d = d * 17.0 + (double)nArray[n6];
            ++n6;
        }
        floatDataset.setStoredValue("max", Float.valueOf(f));
        floatDataset.setStoredValue("min", Float.valueOf(f2));
        floatDataset.setStoredValue("hash", (int)d);
    }

    public static Number parseValue(String string) {
        try {
            return Byte.parseByte(string);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return Short.parseShort(string);
            }
            catch (NumberFormatException numberFormatException2) {
                try {
                    return Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException3) {
                    try {
                        return Long.parseLong(string);
                    }
                    catch (NumberFormatException numberFormatException4) {
                        try {
                            return Double.parseDouble(string);
                        }
                        catch (NumberFormatException numberFormatException5) {
                            SRSLoader.logger.info("Value {} is not a number", (Object)string);
                            return null;
                        }
                    }
                }
            }
        }
    }
}

