/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import gda.analysis.io.ScanFileHolderException;
import gda.util.TestUtils;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.LoaderFactory;
import uk.ac.diamond.scisoft.analysis.io.TIFFImageLoader;
import uk.ac.diamond.scisoft.analysis.io.TIFFImageSaver;

public class TiffLoaderTest {
    static String testfile1 = null;
    static String testfile2 = null;
    static String testfile3 = null;
    private static String testScratchDirectoryName;
    static String TestFileFolder;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        testScratchDirectoryName = TestUtils.generateDirectorynameFromClassname((String)TiffLoaderTest.class.getCanonicalName());
        TestUtils.makeScratchDirectory((String)testScratchDirectoryName);
    }

    @BeforeClass
    public static void setUpClass() {
        TestFileFolder = TestUtils.getGDALargeTestFilesLocation();
        if (TestFileFolder == null) {
            Assert.fail((String)"TestUtils.getGDALargeTestFilesLocation() returned null - test aborted");
        }
        TestFileFolder = String.valueOf(TestFileFolder) + "PilatusTiffLoaderTest/";
        testfile1 = String.valueOf(TestFileFolder) + "fcell_H_8GPa_20keV_18000s_0173.tif";
        testfile2 = String.valueOf(TestFileFolder) + "ipp16.TIF";
        testfile3 = String.valueOf(TestFileFolder) + "crl-bestfocus1.tif";
    }

    @Test
    public void testLoadFile() throws ScanFileHolderException {
        new TIFFImageLoader(testfile1).loadFile();
    }

    @Test
    public void testLoaderFactory() throws Exception {
        DataHolder dataHolder = LoaderFactory.getData(testfile1, null);
        if (dataHolder == null || dataHolder.getNames().length < 1) {
            throw new Exception();
        }
    }

    @Test
    public void testLoadFile12Bit() throws ScanFileHolderException {
        new TIFFImageLoader(testfile2).loadFile();
    }

    @Test
    public void testLoadFile16Bit() throws ScanFileHolderException {
        new TIFFImageLoader(testfile3).loadFile();
    }

    @Test
    public void testTruncatedFile() {
        try {
            DataHolder dataHolder = new TIFFImageLoader("testfiles/images/test-trunc.tiff").loadFile();
            System.err.println(dataHolder.size());
            Assert.fail((String)"Should have thrown an exception");
        }
        catch (ScanFileHolderException scanFileHolderException) {}
    }

    @Test
    public void testNullFile() {
        try {
            new TIFFImageLoader("testfiles/images/null.dat").loadFile();
            Assert.fail((String)"Should have thrown an exception");
        }
        catch (ScanFileHolderException scanFileHolderException) {}
    }

    @Test
    public void testSaveFile() throws ScanFileHolderException {
        AbstractDataset abstractDataset = AbstractDataset.arange(16384.0, 5).reshape(128, 128);
        DataHolder dataHolder = new DataHolder();
        dataHolder.addDataset("a", abstractDataset);
        String string = String.valueOf(testScratchDirectoryName) + "a.tif";
        TIFFImageSaver tIFFImageSaver = new TIFFImageSaver(string, true);
        tIFFImageSaver.saveFile(dataHolder);
        DataHolder dataHolder2 = new TIFFImageLoader(string).loadFile();
        this.checkDataset(abstractDataset, dataHolder2.getDataset(0));
        tIFFImageSaver = new TIFFImageSaver(string);
        tIFFImageSaver.saveFile(dataHolder);
        dataHolder2 = new TIFFImageLoader(string).loadFile();
        this.checkDataset(abstractDataset, dataHolder2.getDataset(0));
    }

    private void checkDataset(AbstractDataset abstractDataset, AbstractDataset abstractDataset2) {
        int[] nArray = abstractDataset.getShape();
        Assert.assertArrayEquals((String)"Shape not equal", (int[])nArray, (int[])abstractDataset2.getShape());
        Assert.assertEquals((String)"1st value", (double)abstractDataset.getDouble(0, 0), (double)abstractDataset2.getDouble(0, 0), (double)1.0E-5);
        Assert.assertEquals((String)"last value", (double)abstractDataset.getDouble(nArray[0] - 1, nArray[1] - 1), (double)abstractDataset2.getDouble(nArray[0] - 1, nArray[1] - 1), (double)1.0E-5);
    }
}

