/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import com.sun.media.imageioimpl.plugins.tiff.TIFFImageReader;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageReaderSpi;
import gda.analysis.io.ScanFileHolderException;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.FileImageInputStream;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.IMetaData;
import uk.ac.diamond.scisoft.analysis.io.IMetaLoader;
import uk.ac.diamond.scisoft.analysis.io.JavaImageLoader;
import uk.ac.diamond.scisoft.analysis.io.MetaDataAdapter;
import uk.ac.diamond.scisoft.analysis.io.tiff.Grey12bitTIFFReader;
import uk.ac.diamond.scisoft.analysis.io.tiff.Grey12bitTIFFReaderSpi;
import uk.ac.gda.monitor.IMonitor;

public class TIFFImageLoader
extends JavaImageLoader
implements IMetaLoader {
    protected Map<String, Serializable> metadata = null;
    private boolean loadData = true;

    public TIFFImageLoader() {
        this(null, false);
    }

    public TIFFImageLoader(String string) {
        this(string, false);
    }

    public TIFFImageLoader(String string, boolean bl) {
        super(string, "tiff", bl);
    }

    public TIFFImageLoader(String string, boolean bl, boolean bl2) {
        super(string, "tiff", bl, bl2);
    }

    @Override
    public DataHolder loadFile() throws ScanFileHolderException {
        Object object;
        AbstractDataset abstractDataset = null;
        File file = null;
        BufferedImage bufferedImage = null;
        file = new File(this.fileName);
        if (!file.exists()) {
            logger.warn("File, {}, did not exist. Now trying to replace suffix", (Object)this.fileName);
            file = this.findCorrectSuffix();
        }
        Object object2 = null;
        try {
            try {
                block15: {
                    file = new File(this.fileName);
                    object = new FileImageInputStream(file);
                    try {
                        object2 = new TIFFImageReader((ImageReaderSpi)new TIFFImageReaderSpi());
                        ((ImageReader)object2).setInput(object);
                        if (this.loadData) {
                            bufferedImage = ((ImageReader)object2).read(0);
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        object2 = new Grey12bitTIFFReader((ImageReaderSpi)((Object)new Grey12bitTIFFReaderSpi()));
                        ((ImageReader)object2).setInput(object);
                        if (!this.loadData) break block15;
                        bufferedImage = ((ImageReader)object2).read(0);
                    }
                }
                if (this.loadData && bufferedImage == null) {
                    throw new ScanFileHolderException("File format in '" + this.fileName + "' cannot be read");
                }
                if (this.loadMetadata) {
                    this.metadata = this.createMetadata(((ImageReader)object2).getImageMetadata(0));
                }
                if (this.loadData) {
                    abstractDataset = this.createDataset(bufferedImage);
                    abstractDataset.setMetadata(this.getMetaData());
                    abstractDataset.setName("image-01");
                }
            }
            catch (IOException iOException) {
                throw new ScanFileHolderException("IOException loading file '" + this.fileName + "'", iOException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ScanFileHolderException("IllegalArgumentException interpreting file '" + this.fileName + "'", illegalArgumentException);
            }
        }
        finally {
            if (object2 != null) {
                ((ImageReader)object2).dispose();
            }
        }
        if (!this.loadData || abstractDataset == null) {
            return null;
        }
        object = new DataHolder();
        ((DataHolder)object).addDataset(this.fileName, abstractDataset, abstractDataset.getMetadata());
        return object;
    }

    protected Map<String, Serializable> createMetadata(IIOMetadata iIOMetadata) throws ScanFileHolderException {
        return null;
    }

    @Override
    public void loadMetaData(IMonitor iMonitor) throws Exception {
        this.loadData = false;
        this.loadFile();
        this.loadData = true;
    }

    @Override
    public IMetaData getMetaData() {
        if (this.metadata == null) {
            return null;
        }
        return new MetaDataAdapter(){

            @Override
            public Collection<String> getMetaNames() throws Exception {
                return TIFFImageLoader.this.metadata.keySet();
            }

            @Override
            public Serializable getMetaValue(String string) throws Exception {
                return TIFFImageLoader.this.metadata.get(string);
            }
        };
    }
}

