/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;

public class SliceObject {
    private String path;
    private String name;
    private int[] fullShape;
    private int[] slicedShape;
    private int[] sliceStart;
    private int[] sliceStop;
    private int[] sliceStep;
    private int x = -1;
    private int y = -1;
    private boolean isRange;
    private List<AbstractDataset> axes;
    private String shapeMessage;

    public void clear() {
        this.path = null;
        this.name = null;
        this.slicedShape = null;
        this.sliceStart = null;
        this.sliceStop = null;
        this.sliceStep = null;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String string) {
        this.path = string;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.axes == null ? 0 : this.axes.hashCode());
        n = 31 * n + Arrays.hashCode(this.fullShape);
        n = 31 * n + (this.isRange ? 1231 : 1237);
        n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
        n = 31 * n + (this.path == null ? 0 : this.path.hashCode());
        n = 31 * n + (this.shapeMessage == null ? 0 : this.shapeMessage.hashCode());
        n = 31 * n + Arrays.hashCode(this.sliceStart);
        n = 31 * n + Arrays.hashCode(this.sliceStep);
        n = 31 * n + Arrays.hashCode(this.sliceStop);
        n = 31 * n + Arrays.hashCode(this.slicedShape);
        n = 31 * n + this.x;
        n = 31 * n + this.y;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SliceObject sliceObject = (SliceObject)object;
        if (this.axes == null ? sliceObject.axes != null : !this.axes.equals(sliceObject.axes)) {
            return false;
        }
        if (!Arrays.equals(this.fullShape, sliceObject.fullShape)) {
            return false;
        }
        if (this.isRange != sliceObject.isRange) {
            return false;
        }
        if (this.name == null ? sliceObject.name != null : !this.name.equals(sliceObject.name)) {
            return false;
        }
        if (this.path == null ? sliceObject.path != null : !this.path.equals(sliceObject.path)) {
            return false;
        }
        if (this.shapeMessage == null ? sliceObject.shapeMessage != null : !this.shapeMessage.equals(sliceObject.shapeMessage)) {
            return false;
        }
        if (!Arrays.equals(this.sliceStart, sliceObject.sliceStart)) {
            return false;
        }
        if (!Arrays.equals(this.sliceStep, sliceObject.sliceStep)) {
            return false;
        }
        if (!Arrays.equals(this.sliceStop, sliceObject.sliceStop)) {
            return false;
        }
        if (!Arrays.equals(this.slicedShape, sliceObject.slicedShape)) {
            return false;
        }
        if (this.x != sliceObject.x) {
            return false;
        }
        return this.y == sliceObject.y;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public int[] getSliceStart() {
        return this.sliceStart;
    }

    public void setSliceStart(int[] nArray) {
        this.sliceStart = nArray;
    }

    public int[] getSliceStop() {
        return this.sliceStop;
    }

    public void setSliceStop(int[] nArray) {
        this.sliceStop = nArray;
    }

    public int[] getSliceStep() {
        return this.sliceStep;
    }

    public void setSliceStep(int[] nArray) {
        this.sliceStep = nArray;
    }

    public String toString() {
        try {
            return BeanUtils.describe((Object)this).toString();
        }
        catch (Exception exception) {
            return exception.getMessage();
        }
    }

    public SliceObject clone() {
        SliceObject sliceObject = new SliceObject();
        sliceObject.fullShape = this.fullShape;
        sliceObject.name = this.name;
        sliceObject.path = this.path;
        sliceObject.sliceStart = this.sliceStart;
        sliceObject.sliceStop = this.sliceStop;
        sliceObject.sliceStep = this.sliceStep;
        return sliceObject;
    }

    public List<AbstractDataset> getAxes() {
        return this.axes;
    }

    public void setAxes(List<AbstractDataset> list) {
        this.axes = list;
    }

    public String getShapeMessage() {
        return this.shapeMessage;
    }

    public void setShapeMessage(String string) {
        this.shapeMessage = string;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int n) {
        this.x = n;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int n) {
        this.y = n;
    }

    public boolean isAxis(int n) {
        return this.x == n || this.y == n;
    }

    public int[] getSlicedShape() {
        return this.slicedShape;
    }

    public void setSlicedShape(int[] nArray) {
        this.slicedShape = nArray;
    }

    public boolean isRange() {
        return this.isRange;
    }

    public void setRange(boolean bl) {
        this.isRange = bl;
    }

    public int[] getFullShape() {
        return this.fullShape;
    }

    public void setFullShape(int[] nArray) {
        this.fullShape = nArray;
    }
}

