/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import gda.analysis.io.ScanFileHolderException;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ILazyDataset;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.ExtendedSRSLoader;
import uk.ac.diamond.scisoft.analysis.io.IMetaData;
import uk.ac.diamond.scisoft.analysis.io.LoaderFactory;
import uk.ac.diamond.scisoft.analysis.io.SRSLoader;

public class SRSLoaderTest {
    @Test
    public void testSS49() {
        try {
            String string = "testfiles/gda/analysis/io/SRSLoaderTest/96356.dat";
            DataHolder dataHolder = new SRSLoader(string).loadFile();
            Assert.assertEquals((String)"There is not the correct number of axis in the file", (long)7L, (long)dataHolder.size());
            int n = dataHolder.getDataset(6).getDtype();
            if (n == 5) {
                Assert.assertEquals((String)"The file does not contain NANs", (double)Double.NaN, (double)dataHolder.getDataset(6).getDouble(1), (double)10.0);
            }
            if (n == 6) {
                Assert.assertEquals((String)"The file does not contain NANs", (double)Double.NaN, (double)dataHolder.getDataset(6).getDouble(1), (double)10.0);
            }
            Assert.assertEquals((String)"The file does not contain data as well", (double)0.1, (double)dataHolder.getDataset(0).getDouble(1), (double)1.0);
        }
        catch (ScanFileHolderException scanFileHolderException) {
            Assert.fail((String)"Couldn't load the file");
        }
    }

    @Test
    public void testSRSLoaderLoop() {
        boolean bl = true;
        try {
            String string = "testfiles/gda/analysis/io/SRSLoaderTest/optics_april20110402.dat";
            DataHolder dataHolder = new SRSLoader(string).loadFile();
            int n = dataHolder.getList().size();
            if (n != 0) {
                Assert.fail((String)"Test file optics_april20110402.dat should not be parsed!");
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        if (bl) {
            Assert.fail((String)"Test file optics_april20110402.dat should not be parsed!");
        }
    }

    @Test
    public void testExtendedSRSLoaderLoop() {
        boolean bl = true;
        try {
            String string = "testfiles/gda/analysis/io/SRSLoaderTest/optics_april20110402.dat";
            DataHolder dataHolder = new ExtendedSRSLoader(string).loadFile();
            int n = dataHolder.getList().size();
            if (n != 0) {
                Assert.fail((String)"Test file optics_april20110402.dat should not be parsed!");
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        if (bl) {
            Assert.fail((String)"Test file optics_april20110402.dat should not be parsed!");
        }
    }

    @Test
    public void testLoaderFactory() throws Exception {
        DataHolder dataHolder = LoaderFactory.getData("testfiles/gda/analysis/io/SRSLoaderTest/96356.dat", null);
        if (dataHolder == null || dataHolder.getNames().length < 1) {
            throw new Exception();
        }
        Assert.assertEquals((String)"There is not the correct number of axis in the file", (long)7L, (long)dataHolder.size());
        int n = dataHolder.getDataset(6).getDtype();
        if (n == 5) {
            Assert.assertEquals((String)"The file does not contain NANs", (double)Double.NaN, (double)dataHolder.getDataset(6).getDouble(1), (double)10.0);
        }
        if (n == 6) {
            Assert.assertEquals((String)"The file does not contain NANs", (double)Double.NaN, (double)dataHolder.getDataset(6).getDouble(1), (double)10.0);
        }
        Assert.assertEquals((String)"The file does not contain data as well", (double)0.1, (double)dataHolder.getDataset(0).getDouble(1), (double)1.0);
    }

    private DataHolder testStoringString(String string, boolean bl) throws ScanFileHolderException {
        SRSLoader sRSLoader = new SRSLoader(string);
        sRSLoader.setStoreStringValues(bl);
        DataHolder dataHolder = sRSLoader.loadFile();
        return dataHolder;
    }

    private DataHolder testStoringStringNotValidImages(boolean bl) throws ScanFileHolderException {
        return this.testStoringString("testfiles/gda/analysis/io/SRSLoaderTest/testStoringStringNotValidImages.dat", bl);
    }

    private DataHolder testStoringStringValidImages(boolean bl) throws ScanFileHolderException {
        return this.testStoringString("testfiles/gda/analysis/io/SRSLoaderTest/testStoringStringValidImages.dat", bl);
    }

    @Test
    public void testStoringStringFalseNotValidImages() throws ScanFileHolderException {
        DataHolder dataHolder = this.testStoringStringNotValidImages(false);
        ILazyDataset iLazyDataset = dataHolder.getLazyDataset("filename");
        Assert.assertNull((Object)iLazyDataset);
    }

    @Test
    public void testStoringStringTrueNotValidImages() throws ScanFileHolderException {
        DataHolder dataHolder = this.testStoringStringNotValidImages(true);
        IDataset iDataset = (IDataset)dataHolder.getLazyDataset("filename");
        Assert.assertNotNull((Object)iDataset);
        Assert.assertEquals((long)3L, (long)iDataset.getSize());
        Assert.assertEquals((long)1L, (long)iDataset.getShape().length);
        Assert.assertEquals((long)3L, (long)iDataset.getShape()[0]);
        Assert.assertEquals((Object)"testfiles/gda/analysis/io/SRSLoaderTest/NotValidImage3.tif", (Object)iDataset.getObject(2));
    }

    @Test
    public void testStoringStringFalseValidImages() throws ScanFileHolderException {
        DataHolder dataHolder = this.testStoringStringValidImages(false);
        ILazyDataset iLazyDataset = dataHolder.getLazyDataset("filename");
        Assert.assertNull((Object)iLazyDataset);
        iLazyDataset = dataHolder.getLazyDataset("filename_image");
        Assert.assertNotNull((Object)iLazyDataset);
        Assert.assertEquals((long)3L, (long)iLazyDataset.getShape().length);
        Assert.assertEquals((long)3L, (long)iLazyDataset.getShape()[0]);
        IDataset iDataset = iLazyDataset.getSlice(new int[3], new int[]{1, 195, 1475}, new int[]{1, 1, 1});
        iDataset.squeeze();
        int[] nArray = iDataset.getShape();
        nArray.toString();
        int[] nArray2 = new int[3];
        nArray2[0] = 1;
        iDataset = iLazyDataset.getSlice(nArray2, new int[]{2, 195, 1024}, new int[]{1, 1, 1});
        iDataset.squeeze();
        nArray = iDataset.getShape();
        nArray.toString();
    }

    @Test
    public void testStoringStringTrueValidImages() throws ScanFileHolderException {
        DataHolder dataHolder = this.testStoringStringValidImages(true);
        IDataset iDataset = (IDataset)dataHolder.getLazyDataset("filename");
        Assert.assertNotNull((Object)iDataset);
        Assert.assertEquals((long)3L, (long)iDataset.getSize());
        Assert.assertEquals((long)1L, (long)iDataset.getShape().length);
        Assert.assertEquals((long)3L, (long)iDataset.getShape()[0]);
        Assert.assertEquals((Object)"testfiles/gda/analysis/io/SRSLoaderTest/simple_data.dat", (Object)iDataset.getObject(2));
    }

    @Test
    public void testWhiteSpaceBeforeNumberss() throws ScanFileHolderException {
        String string = "testfiles/gda/analysis/io/SRSLoaderTest/16446.dat";
        DataHolder dataHolder = new SRSLoader(string).loadFile();
        Assert.assertEquals((long)4L, (long)dataHolder.size());
        Assert.assertEquals((Object)"DCMFPitch", (Object)dataHolder.getNames()[0]);
    }

    @Test
    public void testB16data() {
        try {
            String string = "testfiles/gda/analysis/io/SRSLoaderTest/34146.dat";
            DataHolder dataHolder = new SRSLoader(string).loadFile();
            Assert.assertEquals((String)"There is not the correct number of axis in the file", (long)2L, (long)dataHolder.size());
            Assert.assertEquals((String)"The file does not contain correct data", (double)2.0, (double)dataHolder.getDataset(0).getDouble(1), (double)1.0E-5);
            IMetaData iMetaData = dataHolder.getMetadata();
            try {
                Collection<String> collection = iMetaData.getMetaNames();
                Assert.assertEquals((String)"Loaded incorrect number of metadata items", (long)11L, (long)collection.size());
                Assert.assertTrue((String)"Metadata item missing", (iMetaData.getMetaValue("cmd") != null ? 1 : 0) != 0);
                Assert.assertTrue((String)"Metadata item missing", (iMetaData.getMetaValue("SRSTIM") != null ? 1 : 0) != 0);
                Assert.assertEquals((String)"SRS metadata item wrong", (Object)"95827", (Object)iMetaData.getMetaValue("SRSTIM"));
            }
            catch (Exception exception) {
                Assert.fail((String)"Could not find metadata");
            }
        }
        catch (ScanFileHolderException scanFileHolderException) {
            Assert.fail((String)"Couldn't load the file");
        }
    }
}

