/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import gda.analysis.io.IFileSaver;
import gda.analysis.io.ScanFileHolderException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.LazyDataset;
import uk.ac.diamond.scisoft.analysis.dataset.StringDataset;
import uk.ac.diamond.scisoft.analysis.io.AbstractFileLoader;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.ExtendedMetadataAdapter;
import uk.ac.diamond.scisoft.analysis.io.IMetaData;
import uk.ac.diamond.scisoft.analysis.io.IMetaLoader;
import uk.ac.diamond.scisoft.analysis.io.ImageStackLoaderEx;
import uk.ac.diamond.scisoft.analysis.io.Utils;
import uk.ac.gda.monitor.IMonitor;

public class SRSLoader
extends AbstractFileLoader
implements IFileSaver,
IMetaLoader {
    protected static final transient Logger logger = LoggerFactory.getLogger(SRSLoader.class);
    protected String fileName;
    protected List<String> datasetNames = new ArrayList<String>();
    protected Map<String, String> textMetadata = new HashMap<String, String>();
    protected List<String> extraHeaders = new ArrayList<String>();
    private boolean storeStringValues = false;
    private boolean useImageLoaderForStrings = true;
    private final Pattern splitRegex = Pattern.compile("\\s+");
    private final int MARK_LIMIT = 1024;
    private final Pattern numberRegex = Pattern.compile("^\\d.+");

    public SRSLoader() {
    }

    public SRSLoader(String string) {
        this.fileName = string;
    }

    public void setFile(String string) {
        this.fileName = string;
    }

    public boolean isStoreStringValues() {
        return this.storeStringValues;
    }

    public void setStoreStringValues(boolean bl) {
        this.storeStringValues = bl;
    }

    public boolean isUseImageLoaderForStrings() {
        return this.useImageLoaderForStrings;
    }

    public void setUseImageLoaderForStrings(boolean bl) {
        this.useImageLoaderForStrings = bl;
    }

    @Override
    public DataHolder loadFile() throws ScanFileHolderException {
        return this.loadFile(null);
    }

    @Override
    public DataHolder loadFile(IMonitor iMonitor) throws ScanFileHolderException {
        DataHolder dataHolder = new DataHolder();
        BufferedReader bufferedReader = null;
        try {
            try {
                String string;
                bufferedReader = new BufferedReader(new FileReader(this.fileName));
                this.readMetadata(bufferedReader, iMonitor);
                if (this.textMetadata.size() > 0) {
                    dataHolder.setMetadata(this.getMetaData());
                }
                String string2 = bufferedReader.readLine();
                string2 = string2.trim();
                String[] stringArray = this.splitRegex.split(string2);
                this.datasetNames.clear();
                this.datasetNames.addAll(Arrays.asList(stringArray));
                List[] listArray = new List[stringArray.length];
                while ((string = bufferedReader.readLine()) != null) {
                    if (iMonitor != null) {
                        iMonitor.worked(1);
                        if (iMonitor.isCancelled()) {
                            throw new ScanFileHolderException("Load cancelled!");
                        }
                    }
                    SRSLoader.parseColumns(this.splitRegex.split(string.trim()), listArray);
                }
                SRSLoader.convertToDatasets(dataHolder, stringArray, listArray, this.isStoreStringValues(), this.isUseImageLoaderForStrings(), new File(this.fileName).getParent());
                if (dataHolder.getMap().isEmpty()) {
                    throw new Exception("Cannot parse " + this.fileName + " into datasets!");
                }
            }
            catch (Exception exception) {
                throw new ScanFileHolderException("SRSLoader.loadFile exception loading  " + this.fileName, exception);
            }
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                throw new ScanFileHolderException("Cannot read file", iOException);
            }
        }
        return dataHolder;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void parseColumns(String[] stringArray, List<?>[] listArray) throws ScanFileHolderException {
        int n = stringArray.length;
        if (n > listArray.length) {
            logger.warn("Number of columns on data line {} exceeds number of headers - ignoring excess columns", (Object)n);
            n = listArray.length;
        }
        int n2 = 0;
        while (n2 < n) {
            Object object;
            String string = stringArray[n2];
            if (listArray[n2] != null) {
                List<?> list;
                object = listArray[n2];
                Object e = object.get(0);
                if (e instanceof Number) {
                    list = object;
                    list.add(Utils.parseValue(string));
                } else {
                    if (!(e instanceof String)) throw new ScanFileHolderException("Type unknown");
                    list = object;
                    list.add(string);
                }
            } else {
                object = Utils.parseValue(string);
                if (object != null) {
                    listArray[n2] = new ArrayList();
                    listArray[n2].add(object);
                } else {
                    listArray[n2] = new ArrayList();
                    listArray[n2].add(string);
                }
            }
            ++n2;
        }
    }

    protected static void convertToDatasets(DataHolder dataHolder, String[] stringArray, List<?>[] listArray, boolean bl, boolean bl2, String string) {
        int n = 0;
        while (n < stringArray.length) {
            if (listArray[n] != null) {
                AbstractDataset abstractDataset = AbstractDataset.array(listArray[n]);
                abstractDataset.setName(stringArray[n]);
                if (abstractDataset.getDtype() == 9) {
                    StringDataset stringDataset = (StringDataset)abstractDataset;
                    if (bl) {
                        dataHolder.addDataset(stringArray[n], abstractDataset);
                    }
                    if (bl2) {
                        try {
                            String[] stringArray2 = stringDataset.getData();
                            String[] stringArray3 = new String[stringArray2.length];
                            int n2 = 0;
                            while (n2 < stringArray3.length) {
                                stringArray3[n2] = !new File(stringArray2[n2]).exists() ? new File(string, stringArray2[n2]).getAbsolutePath() : stringArray2[n2];
                                ++n2;
                            }
                            ImageStackLoaderEx imageStackLoaderEx = new ImageStackLoaderEx(stringDataset.getShape(), stringArray3);
                            String string2 = String.valueOf(stringArray[n]) + "_image";
                            LazyDataset lazyDataset = new LazyDataset(string2, imageStackLoaderEx.dtype, imageStackLoaderEx.getShape(), imageStackLoaderEx);
                            dataHolder.addDataset(string2, lazyDataset);
                        }
                        catch (Exception exception) {
                            logger.warn("Unable to treat " + stringDataset.getAbs(0) + " as an image file", (Throwable)exception);
                        }
                    }
                } else {
                    dataHolder.addDataset(stringArray[n], abstractDataset);
                }
            }
            ++n;
        }
    }

    protected void readMetadata(BufferedReader bufferedReader, IMonitor iMonitor) throws ScanFileHolderException {
        this.textMetadata.clear();
        try {
            block2: while (true) {
                String[] stringArray;
                String string;
                if (iMonitor != null) {
                    iMonitor.worked(1);
                    if (iMonitor.isCancelled()) {
                        throw new ScanFileHolderException("Load cancelled!");
                    }
                }
                if ((string = bufferedReader.readLine()) == null || string.contains("&END")) {
                    return;
                }
                if (string.contains("MetaDataAtStart") && (stringArray = string.split("</?MetaDataAtStart>")).length > 0) {
                    String[] stringArray2 = stringArray;
                    int n = stringArray.length;
                    int n2 = 0;
                    while (true) {
                        if (n2 >= n) continue block2;
                        String string2 = stringArray2[n2];
                        if (string2.contains("=")) {
                            bufferedReader.mark(1024);
                            this.parseString(string2);
                        } else {
                            this.extraHeaders.add(string2);
                        }
                        ++n2;
                    }
                }
                if (string.length() == 0) continue;
                if (string.contains("=")) {
                    bufferedReader.mark(1024);
                    this.parseString(string);
                    continue;
                }
                if (this.numberRegex.matcher(string).matches()) {
                    bufferedReader.reset();
                    return;
                }
                this.extraHeaders.add(string);
            }
        }
        catch (IOException iOException) {
            logger.error("Problem parsing header of SRS file {}", (Object)this.fileName);
            throw new ScanFileHolderException("There was a problem parsing header information", iOException);
        }
    }

    private void parseString(String string) {
        String string2 = null;
        String string3 = string.trim();
        int n = string3.indexOf(61);
        int n2 = string3.length();
        while (n >= 0) {
            string2 = string3.substring(0, n);
            if (n == n2 - 1 || (n = (string3 = string3.substring(n + 1).trim()).indexOf(44)) < 0) break;
            this.addMetadata(string2, string3.substring(0, n));
            string3 = string3.substring(n + 1).trim();
            string2 = null;
            n = string3.indexOf(61);
            n2 = string3.length();
        }
        if (string2 != null) {
            this.addMetadata(string2, string3);
        }
    }

    private void addMetadata(String string, String string2) {
        String string3 = this.extractQuotedString(string2, true);
        if (string3 == null && (string3 = this.extractQuotedString(string2, false)) == null) {
            string3 = string2;
        }
        this.textMetadata.put(string, string3);
    }

    private String extractQuotedString(String string, boolean bl) {
        char c = bl ? (char)'\'' : '\"';
        int n = this.findQuoteChar(string, c, 0);
        if (n < 0) {
            return null;
        }
        int n2 = this.findQuoteChar(string, c, n + 1);
        if (n2 < 0) {
            logger.warn("String was not quoted correctly: {} from {}", (Object)string.substring(n), (Object)string);
            return string.substring(n + 1);
        }
        return string.substring(n + 1, n2);
    }

    private int findQuoteChar(String string, char c, int n) {
        int n2 = string.indexOf(c, n);
        if (n2 <= 0) {
            return n2;
        }
        if (string.charAt(n2 - 1) == '\\') {
            return this.findQuoteChar(string, c, n2 + 1);
        }
        return n2;
    }

    @Override
    public void saveFile(DataHolder dataHolder) throws ScanFileHolderException {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.fileName));
            bufferedWriter.write("&SRS\n");
            this.writeMetadata(bufferedWriter, dataHolder);
            bufferedWriter.write("&END\n");
            int n = dataHolder.namesSize();
            int n2 = 0;
            while (n2 < n) {
                bufferedWriter.write(String.valueOf(dataHolder.getName(n2)) + "\t");
                ++n2;
            }
            bufferedWriter.write("\n");
            n2 = dataHolder.getDataset(0).getSize();
            AbstractDataset[] abstractDatasetArray = new AbstractDataset[n];
            int n3 = 0;
            while (n3 < n) {
                abstractDatasetArray[n3] = dataHolder.getDataset(n3);
                ++n3;
            }
            n3 = 0;
            while (n3 < n2) {
                int n4 = 0;
                while (n4 < n) {
                    try {
                        bufferedWriter.write(String.valueOf(abstractDatasetArray[n4].getElementDoubleAbs(n3)) + "\t");
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        bufferedWriter.write("0.0\t");
                    }
                    ++n4;
                }
                bufferedWriter.write("\n");
                ++n3;
            }
            bufferedWriter.close();
        }
        catch (Exception exception) {
            logger.error("Problem saving SRS file {}", (Object)this.fileName);
            throw new ScanFileHolderException("SRSLoader.saveFile exception saving to " + this.fileName, exception);
        }
    }

    protected void writeMetadata(BufferedWriter bufferedWriter, DataHolder dataHolder) throws IOException {
        String[] stringArray = this.getKeysToSave();
        if (!this.textMetadata.isEmpty() && stringArray != null) {
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray2[n2];
                String string2 = this.textMetadata.get(string);
                if (string2 == null) {
                    if (this.textMetadata.containsKey(string)) {
                        logger.warn("Metadata item (key {}) was null", (Object)string);
                    } else {
                        logger.warn("Metadata key {} is not contained in list", (Object)string);
                    }
                } else {
                    bufferedWriter.write(String.valueOf(string) + "=" + string2.toString() + "\n");
                }
                ++n2;
            }
        }
        if (!this.extraHeaders.isEmpty()) {
            for (String string : this.extraHeaders) {
                bufferedWriter.write(String.valueOf(string) + "\n");
            }
        }
    }

    protected String[] getKeysToSave() {
        return null;
    }

    @Override
    public IMetaData getMetaData() {
        return new ExtendedMetadataAdapter(){

            @Override
            public Collection<String> getDataNames() {
                return SRSLoader.this.datasetNames;
            }

            public String getMetaValue(String string) {
                return SRSLoader.this.textMetadata.get(string);
            }

            @Override
            public Collection<String> getMetaNames() throws Exception {
                return SRSLoader.this.textMetadata.keySet();
            }

            @Override
            public String getScanCommand() {
                String string = SRSLoader.this.textMetadata.get("cmd");
                if (string == null) {
                    string = SRSLoader.this.textMetadata.get("command");
                }
                if (string == null) {
                    string = SRSLoader.this.textMetadata.get("scancommand");
                }
                return string;
            }
        };
    }

    @Override
    public void loadMetaData(IMonitor iMonitor) throws Exception {
        BufferedReader bufferedReader = null;
        try {
            try {
                bufferedReader = new BufferedReader(new FileReader(this.fileName));
                this.readMetadata(bufferedReader, iMonitor);
                String string = bufferedReader.readLine();
                String[] stringArray = string.split("\\s{2,}|\\,\\s+|\\t");
                this.datasetNames.clear();
                this.datasetNames.addAll(Arrays.asList(stringArray));
            }
            catch (Exception exception) {
                throw new ScanFileHolderException("SRSLoader.loadFile exception loading  " + this.fileName, exception);
            }
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                throw new ScanFileHolderException("Cannot read file", iOException);
            }
        }
    }
}

