/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import gda.analysis.io.ScanFileHolderException;
import gda.util.TestUtils;
import junit.framework.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.PNGLoader;
import uk.ac.diamond.scisoft.analysis.io.RawTextLoader;
import uk.ac.diamond.scisoft.analysis.io.RawTextSaver;

public class RawTextTest {
    static final String testFileFolder = "testfiles/images/";
    static String testScratchDirectoryName = null;
    AbstractDataset data;
    int sizex = 240;
    int sizey = 240;
    int range = this.sizex * this.sizey;
    String filePath = "TestData.dat";

    @BeforeClass
    public static void setUpClass() throws Exception {
        testScratchDirectoryName = TestUtils.generateDirectorynameFromClassname((String)RawTextTest.class.getCanonicalName());
        TestUtils.makeScratchDirectory((String)testScratchDirectoryName);
    }

    @Test
    public void testSaveFile() throws ScanFileHolderException {
        DataHolder dataHolder = new DataHolder();
        this.data = DatasetUtils.linSpace(0.0, 576000.0, this.range, 6);
        this.data.setShape(this.sizex, this.sizey);
        try {
            dataHolder.addDataset("testing data", this.data);
            new RawTextSaver(String.valueOf(testScratchDirectoryName) + this.filePath).saveFile(dataHolder);
        }
        catch (Exception exception) {
            throw new ScanFileHolderException("Problem testing RawText class", exception);
        }
    }

    @Test
    public void testLoadFile() throws ScanFileHolderException {
        DataHolder dataHolder = new PNGLoader("testfiles/images/test.png").loadFile();
        AbstractDataset abstractDataset = dataHolder.getDataset(0);
        try {
            new RawTextSaver(String.valueOf(testScratchDirectoryName) + "test.txt").saveFile(dataHolder);
        }
        catch (Exception exception) {
            throw new ScanFileHolderException("Problem testing RawText class", exception);
        }
        try {
            dataHolder = new RawTextLoader(String.valueOf(testScratchDirectoryName) + "test.txt").loadFile();
        }
        catch (Exception exception) {
            throw new ScanFileHolderException("Problem testing rawOutput class", exception);
        }
        if (dataHolder == null || dataHolder.getNames().length < 1) {
            throw new ScanFileHolderException("");
        }
        Assert.assertEquals((String)"Datasets not equal", (Object)abstractDataset, (Object)dataHolder.getDataset(0));
    }
}

