/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import gda.analysis.io.ScanFileHolderException;
import gda.util.TestUtils;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.LoaderFactory;
import uk.ac.diamond.scisoft.analysis.io.RawBinaryLoader;
import uk.ac.diamond.scisoft.analysis.io.RawBinarySaver;

public class RawBinaryTest {
    static String testScratchDirectoryName = null;
    static String testpath = null;
    static double testValue1;
    static double testValue2;
    AbstractDataset data;
    int sizex = 240;
    int sizey = 240;
    int range = this.sizex * this.sizey;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        testScratchDirectoryName = TestUtils.generateDirectorynameFromClassname((String)RawBinaryTest.class.getCanonicalName());
        TestUtils.makeScratchDirectory((String)testScratchDirectoryName);
    }

    @Test
    public void test2DSaveFile() throws ScanFileHolderException {
        String string = "test2DSaveFile.raw";
        DataHolder dataHolder = new DataHolder();
        this.data = DatasetUtils.linSpace(0.0, this.range, this.range, 6);
        this.data.setShape(this.sizex, this.sizey);
        this.data.setName("test 2D");
        testValue1 = this.data.getDouble(this.sizex - 1);
        testValue2 = this.data.getDouble(10, 10);
        try {
            dataHolder.addDataset("testing data", this.data);
            new RawBinarySaver(String.valueOf(testScratchDirectoryName) + string).saveFile(dataHolder);
        }
        catch (Exception exception) {
            throw new ScanFileHolderException("Problem testing rawOutput class", exception);
        }
        try {
            dataHolder = new RawBinaryLoader(String.valueOf(testScratchDirectoryName) + string).loadFile();
            AbstractDataset abstractDataset = dataHolder.getDataset(0);
            Assert.assertEquals((long)abstractDataset.getDtype(), (long)6L);
            Assert.assertEquals((long)abstractDataset.getSize(), (long)this.range);
            Assert.assertEquals((Object)abstractDataset.getName(), (Object)"test 2D");
            Assert.assertEquals((long)abstractDataset.getShape().length, (long)2L);
            Assert.assertEquals((long)abstractDataset.getShape()[0], (long)this.sizey);
            Assert.assertEquals((long)abstractDataset.getShape()[1], (long)this.sizex);
            Assert.assertEquals((double)abstractDataset.getDouble(this.sizex - 1), (double)testValue1, (double)0.01);
            Assert.assertEquals((double)abstractDataset.getDouble(10, 10), (double)testValue2, (double)0.01);
        }
        catch (Exception exception) {
            throw new ScanFileHolderException("Problem testing rawOutput class", exception);
        }
    }

    @Test
    public void test1DSaveFile() throws ScanFileHolderException {
        String string = "test1DSaveFile.raw";
        DataHolder dataHolder = new DataHolder();
        this.data = DatasetUtils.linSpace(0.0, this.range, this.range, 5);
        this.data.setName("test 1D");
        try {
            dataHolder.addDataset("testing data", this.data);
            new RawBinarySaver(String.valueOf(testScratchDirectoryName) + string).saveFile(dataHolder);
        }
        catch (Exception exception) {
            throw new ScanFileHolderException("Problem testing rawOutput class", exception);
        }
        try {
            dataHolder = new RawBinaryLoader(String.valueOf(testScratchDirectoryName) + string).loadFile();
            AbstractDataset abstractDataset = dataHolder.getDataset(0);
            Assert.assertEquals((long)abstractDataset.getDtype(), (long)5L);
            Assert.assertEquals((long)abstractDataset.getSize(), (long)this.range);
            Assert.assertEquals((Object)abstractDataset.getName(), (Object)"test 1D");
            Assert.assertEquals((long)abstractDataset.getShape().length, (long)1L);
            Assert.assertEquals((long)abstractDataset.getShape()[0], (long)this.range);
        }
        catch (Exception exception) {
            throw new ScanFileHolderException("Problem testing rawOutput class", exception);
        }
    }

    @Test
    public void testLoaderFactory() throws Exception {
        String string = "testLoaderFactory.raw";
        DataHolder dataHolder = new DataHolder();
        this.data = DatasetUtils.linSpace(0.0, this.range, this.range, 2);
        this.data.setName("test factory");
        try {
            dataHolder.addDataset("testing data", this.data);
            new RawBinarySaver(String.valueOf(testScratchDirectoryName) + string).saveFile(dataHolder);
        }
        catch (Exception exception) {
            throw new ScanFileHolderException("Problem testing rawOutput class", exception);
        }
        dataHolder = LoaderFactory.getData(String.valueOf(testScratchDirectoryName) + string, null);
        if (dataHolder == null || dataHolder.getNames().length < 1) {
            throw new Exception();
        }
        AbstractDataset abstractDataset = dataHolder.getDataset(0);
        Assert.assertEquals((long)abstractDataset.getDtype(), (long)2L);
        Assert.assertEquals((long)abstractDataset.getSize(), (long)this.range);
        Assert.assertEquals((Object)abstractDataset.getName(), (Object)"test factory");
        Assert.assertEquals((long)abstractDataset.getShape().length, (long)1L);
        Assert.assertEquals((long)abstractDataset.getShape()[0], (long)this.range);
    }
}

