/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import gda.analysis.io.IFileSaver;
import gda.analysis.io.ScanFileHolderException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.text.DecimalFormat;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.BooleanDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ByteDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ComplexDoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ComplexFloatDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.FloatDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IntegerDataset;
import uk.ac.diamond.scisoft.analysis.dataset.LongDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ShortDataset;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;

public class RawBinarySaver
implements IFileSaver {
    private String filename = "";
    private static int formatTag = -1056630259;

    public static int getFormatTag() {
        return formatTag;
    }

    public RawBinarySaver(String string) {
        this.filename = string;
    }

    @Override
    public void saveFile(DataHolder dataHolder) throws ScanFileHolderException {
        File file = null;
        int n = dataHolder.size();
        int n2 = 0;
        while (n2 < n) {
            Object object;
            try {
                object = null;
                String string = null;
                if (n == 1) {
                    object = this.filename;
                } else {
                    try {
                        object = this.filename.substring(0, this.filename.lastIndexOf("."));
                        string = this.filename.substring(this.filename.lastIndexOf("."));
                    }
                    catch (Exception exception) {
                        object = this.filename;
                    }
                    DecimalFormat decimalFormat = new DecimalFormat("00000");
                    object = String.valueOf(object) + decimalFormat.format(n2 + 1) + string;
                }
                file = new File((String)object);
            }
            catch (Exception exception) {
                throw new ScanFileHolderException("Error saving file '" + this.filename + "'", exception);
            }
            object = DatasetUtils.convertToAbstractDataset(dataHolder.getDataset(n2));
            int n3 = ((AbstractDataset)object).getDtype();
            switch (n3) {
                case 100: {
                    n3 = 1;
                    break;
                }
                case 200: {
                    n3 = 2;
                    break;
                }
                case 300: {
                    n3 = 3;
                    break;
                }
                case 400: {
                    n3 = 4;
                    break;
                }
                case 500: {
                    n3 = 5;
                    break;
                }
                case 600: {
                    n3 = 6;
                }
            }
            int n4 = ((AbstractDataset)object).getElementsPerItem();
            if (n4 > 255) {
                throw new ScanFileHolderException("Number of elements in each item exceeds allowed maximum of 255");
            }
            byte by = (byte)n4;
            String string = ((AbstractDataset)object).getName();
            byte[] byArray = null;
            try {
                byArray = string.getBytes("UTF-8");
                int n5 = string.length() - 2;
                while (byArray.length > 65535) {
                    byArray = string.substring(0, n5).getBytes("UTF8");
                    --n5;
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new ScanFileHolderException("Problem dealing with dataset name", unsupportedEncodingException);
            }
            int[] nArray = ((AbstractDataset)object).getShape();
            if (nArray.length > 255) {
                throw new ScanFileHolderException("Rank exceeds 255!");
            }
            int n6 = nArray.length;
            int n7 = 7 + n6 * 4 + 2 + byArray.length;
            n7 = (n7 + 3) / 4 * 4;
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                FileChannel fileChannel = fileOutputStream.getChannel();
                ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n7);
                byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                byteBuffer.putInt(formatTag);
                byteBuffer.put((byte)n3);
                byteBuffer.put(by);
                byteBuffer.put((byte)n6);
                int n8 = 0;
                while (n8 < n6) {
                    byteBuffer.putInt(nArray[n8]);
                    ++n8;
                }
                byteBuffer.putShort((short)byArray.length);
                if (byArray.length > 0) {
                    byteBuffer.put(byArray);
                }
                while (byteBuffer.position() < n7) {
                    byteBuffer.put((byte)0);
                }
                byteBuffer.rewind();
                while (byteBuffer.hasRemaining()) {
                    fileChannel.write(byteBuffer);
                }
                ByteBuffer byteBuffer2 = RawBinarySaver.saveRawDataset((AbstractDataset)object, n3, by);
                byteBuffer2.rewind();
                while (byteBuffer2.hasRemaining()) {
                    fileChannel.write(byteBuffer2);
                }
                fileChannel.close();
                fileOutputStream.close();
            }
            catch (Exception exception) {
                throw new ScanFileHolderException("Error saving file '" + this.filename + "'", exception);
            }
            ++n2;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static ByteBuffer saveRawDataset(AbstractDataset var0, int var1_1, byte var2_2) {
        var3_3 = ByteBuffer.allocateDirect(var0.getNbytes());
        var3_3.order(ByteOrder.LITTLE_ENDIAN);
        switch (var1_1) {
            case 0: {
                var4_4 = (BooleanDataset)var0;
                var5_5 = var4_4.getData();
                var6_6 = var4_4.getIterator();
                while (var6_6.hasNext()) {
                    var3_3.put((byte)(var5_5[var6_6.index] != false));
                }
                break;
            }
            case 1: {
                var7_15 = (ByteDataset)var0;
                var8_16 = var7_15.getData();
                var6_7 = var7_15.getIterator();
                if (var2_2 != 1) ** GOTO lbl30
                while (var6_7.hasNext()) {
                    var3_3.put(var8_16[var6_7.index]);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    var9_17 = 0;
                    while (var9_17 < var2_2) {
                        var3_3.put(var8_16[var6_7.index + var9_17]);
                        ++var9_17;
                    }
lbl30:
                    // 2 sources

                    ** while (var6_7.hasNext())
                }
lbl31:
                // 1 sources

                break;
            }
            case 2: {
                var9_18 = (ShortDataset)var0;
                var10_19 = var3_3.asShortBuffer();
                var11_20 = var9_18.getData();
                var6_8 = var9_18.getIterator();
                if (var2_2 != 1) ** GOTO lbl49
                while (var6_8.hasNext()) {
                    var10_19.put(var11_20[var6_8.index]);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    var12_21 = 0;
                    while (var12_21 < var2_2) {
                        var10_19.put(var11_20[var6_8.index + var12_21]);
                        ++var12_21;
                    }
lbl49:
                    // 2 sources

                    ** while (var6_8.hasNext())
                }
lbl50:
                // 1 sources

                break;
            }
            case 3: {
                var12_22 = (IntegerDataset)var0;
                var13_23 = var3_3.asIntBuffer();
                var14_24 = var12_22.getData();
                var6_9 = var12_22.getIterator();
                if (var2_2 != 1) ** GOTO lbl68
                while (var6_9.hasNext()) {
                    var13_23.put(var14_24[var6_9.index]);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    var15_25 = 0;
                    while (var15_25 < var2_2) {
                        var13_23.put(var14_24[var6_9.index + var15_25]);
                        ++var15_25;
                    }
lbl68:
                    // 2 sources

                    ** while (var6_9.hasNext())
                }
lbl69:
                // 1 sources

                break;
            }
            case 4: {
                var15_26 = (LongDataset)var0;
                var16_27 = var3_3.asLongBuffer();
                var17_28 = var15_26.getData();
                var6_10 = var15_26.getIterator();
                if (var2_2 != 1) ** GOTO lbl87
                while (var6_10.hasNext()) {
                    var16_27.put(var17_28[var6_10.index]);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    var18_29 = 0;
                    while (var18_29 < var2_2) {
                        var16_27.put(var17_28[var6_10.index + var18_29]);
                        ++var18_29;
                    }
lbl87:
                    // 2 sources

                    ** while (var6_10.hasNext())
                }
lbl88:
                // 1 sources

                break;
            }
            case 5: {
                var18_30 = (FloatDataset)var0;
                var19_31 = var3_3.asFloatBuffer();
                var20_33 = var18_30.getData();
                var6_11 = var18_30.getIterator();
                if (var2_2 != 1) ** GOTO lbl106
                while (var6_11.hasNext()) {
                    var19_31.put(var20_33[var6_11.index]);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    var21_35 = 0;
                    while (var21_35 < var2_2) {
                        var19_31.put(var20_33[var6_11.index + var21_35]);
                        ++var21_35;
                    }
lbl106:
                    // 2 sources

                    ** while (var6_11.hasNext())
                }
lbl107:
                // 1 sources

                break;
            }
            case 6: {
                var21_36 = (DoubleDataset)var0;
                var22_37 = var3_3.asDoubleBuffer();
                var23_39 = var21_36.getData();
                var6_12 = var21_36.getIterator();
                if (var2_2 != 1) ** GOTO lbl125
                while (var6_12.hasNext()) {
                    var22_37.put(var23_39[var6_12.index]);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    var24_41 = 0;
                    while (var24_41 < var2_2) {
                        var22_37.put(var23_39[var6_12.index + var24_41]);
                        ++var24_41;
                    }
lbl125:
                    // 2 sources

                    ** while (var6_12.hasNext())
                }
lbl126:
                // 1 sources

                break;
            }
            case 7: {
                var24_42 = (ComplexFloatDataset)var0;
                var19_32 = var3_3.asFloatBuffer();
                var20_34 = var24_42.getData();
                var6_13 = var24_42.getIterator();
                while (var6_13.hasNext()) {
                    var19_32.put(var20_34[var6_13.index]);
                    var19_32.put(var20_34[var6_13.index + 1]);
                }
                break;
            }
            case 8: {
                var25_43 = (ComplexDoubleDataset)var0;
                var22_38 = var3_3.asDoubleBuffer();
                var23_40 = var25_43.getData();
                var6_14 = var25_43.getIterator();
                while (var6_14.hasNext()) {
                    var22_38.put(var23_40[var6_14.index]);
                    var22_38.put(var23_40[var6_14.index + 1]);
                }
                break;
            }
        }
        return var3_3;
    }
}

