/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import gda.analysis.io.ScanFileHolderException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.MappedByteBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.FileChannel;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.BooleanDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ByteDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ComplexDoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ComplexFloatDataset;
import uk.ac.diamond.scisoft.analysis.dataset.CompoundByteDataset;
import uk.ac.diamond.scisoft.analysis.dataset.CompoundDoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.CompoundFloatDataset;
import uk.ac.diamond.scisoft.analysis.dataset.CompoundIntegerDataset;
import uk.ac.diamond.scisoft.analysis.dataset.CompoundLongDataset;
import uk.ac.diamond.scisoft.analysis.dataset.CompoundShortDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.FloatDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IntegerDataset;
import uk.ac.diamond.scisoft.analysis.dataset.LongDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ShortDataset;
import uk.ac.diamond.scisoft.analysis.io.AbstractFileLoader;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.RawBinarySaver;

public class RawBinaryLoader
extends AbstractFileLoader {
    private String fileName;

    public RawBinaryLoader() {
    }

    public RawBinaryLoader(String string) {
        this.fileName = string;
    }

    public void setFile(String string) {
        this.fileName = string;
    }

    @Override
    public DataHolder loadFile() throws ScanFileHolderException {
        DataHolder dataHolder = new DataHolder();
        File file = null;
        FileInputStream fileInputStream = null;
        try {
            try {
                int n;
                file = new File(this.fileName);
                fileInputStream = new FileInputStream(file);
                FileChannel fileChannel = fileInputStream.getChannel();
                MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fileChannel.size());
                mappedByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                if (RawBinarySaver.getFormatTag() != mappedByteBuffer.getInt()) {
                    throw new ScanFileHolderException("File does not start with a Diamond format tag " + String.format("%x", mappedByteBuffer.getInt()));
                }
                int n2 = mappedByteBuffer.get();
                int n3 = mappedByteBuffer.get();
                if (n3 < 0) {
                    n3 += 256;
                }
                if ((n = mappedByteBuffer.get()) < 0) {
                    n += 256;
                }
                int n4 = n3;
                int[] nArray = new int[n];
                int n5 = 0;
                while (n5 < n) {
                    nArray[n5] = mappedByteBuffer.getInt();
                    n4 *= nArray[n5];
                    ++n5;
                }
                n5 = mappedByteBuffer.getShort();
                if (n5 < 0) {
                    n5 += 65536;
                }
                byte[] byArray = new byte[n5];
                if (n5 > 0) {
                    mappedByteBuffer.get(byArray);
                }
                while (mappedByteBuffer.position() % 4 != 0) {
                    mappedByteBuffer.get();
                }
                if (n3 != 1) {
                    switch (n2) {
                        case 1: {
                            n2 = 100;
                            break;
                        }
                        case 2: {
                            n2 = 200;
                            break;
                        }
                        case 3: {
                            n2 = 300;
                            break;
                        }
                        case 4: {
                            n2 = 400;
                            break;
                        }
                        case 5: {
                            n2 = 500;
                            break;
                        }
                        case 6: {
                            n2 = 600;
                        }
                    }
                }
                AbstractDataset abstractDataset = RawBinaryLoader.loadRawDataset(mappedByteBuffer, n2, n3, n4, nArray);
                fileChannel.close();
                if (n5 > 0) {
                    String string = new String(byArray, "UTF-8");
                    abstractDataset.setName(string);
                    dataHolder.addDataset(string, abstractDataset);
                } else {
                    dataHolder.addDataset("RAW file", abstractDataset);
                }
                abstractDataset.setDirty();
            }
            catch (Exception exception) {
                if (exception instanceof ScanFileHolderException) {
                    throw (ScanFileHolderException)exception;
                }
                throw new ScanFileHolderException("There was a problem reading the Raw file", exception);
            }
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return dataHolder;
    }

    public static AbstractDataset loadRawDataset(ByteBuffer byteBuffer, int n, int n2, int n3, int[] nArray) throws ScanFileHolderException {
        AbstractDataset abstractDataset = null;
        int n4 = 0;
        double d = 0.0;
        switch (n) {
            case 0: {
                BooleanDataset booleanDataset = new BooleanDataset(nArray);
                if (byteBuffer.remaining() != n3) {
                    throw new ScanFileHolderException("Data size, " + byteBuffer.remaining() + ", does not match expected, " + n3);
                }
                boolean[] blArray = booleanDataset.getData();
                boolean bl = false;
                boolean bl2 = true;
                int n5 = 0;
                while (n5 < n3) {
                    boolean bl3 = byteBuffer.get() != 0;
                    n4 = n4 * 19 + (bl3 ? 0 : 1);
                    blArray[n5] = bl3;
                    if (!bl && bl3) {
                        bl = true;
                    }
                    if (bl2 && !bl3) {
                        bl2 = false;
                    }
                    ++n5;
                }
                abstractDataset = booleanDataset;
                abstractDataset.setStoredValue("max", bl);
                abstractDataset.setStoredValue("min", bl2);
                break;
            }
            case 1: {
                ByteDataset byteDataset = new ByteDataset(nArray);
                if (byteBuffer.remaining() != n3) {
                    throw new ScanFileHolderException("Data size, " + byteBuffer.remaining() + ", does not match expected, " + n3);
                }
                byte[] byArray = byteDataset.getData();
                byte by = -128;
                byte by2 = 127;
                int n6 = 0;
                while (n6 < n3) {
                    byte by3 = byteBuffer.get();
                    n4 = n4 * 19 + by3;
                    byArray[n6] = by3;
                    if (by3 > by) {
                        by = by3;
                    }
                    if (by3 < by2) {
                        by2 = by3;
                    }
                    ++n6;
                }
                abstractDataset = byteDataset;
                abstractDataset.setStoredValue("max", by);
                abstractDataset.setStoredValue("min", by2);
                break;
            }
            case 2: {
                ShortDataset shortDataset = new ShortDataset(nArray);
                ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
                if (shortBuffer.remaining() != n3) {
                    throw new ScanFileHolderException("Data size, " + shortBuffer.remaining() + ", does not match expected, " + n3);
                }
                short[] sArray = shortDataset.getData();
                short s = Short.MIN_VALUE;
                short s2 = Short.MAX_VALUE;
                int n7 = 0;
                while (n7 < n3) {
                    short s3 = shortBuffer.get();
                    n4 = n4 * 19 + s3;
                    sArray[n7] = s3;
                    if (s3 > s) {
                        s = s3;
                    }
                    if (s3 < s2) {
                        s2 = s3;
                    }
                    ++n7;
                }
                abstractDataset = shortDataset;
                abstractDataset.setStoredValue("max", s);
                abstractDataset.setStoredValue("min", s2);
                break;
            }
            case 3: {
                IntegerDataset integerDataset = new IntegerDataset(nArray);
                IntBuffer intBuffer = byteBuffer.asIntBuffer();
                if (intBuffer.remaining() != n3) {
                    throw new ScanFileHolderException("Data size, " + intBuffer.remaining() + ", does not match expected, " + n3);
                }
                int[] nArray2 = integerDataset.getData();
                int n8 = Integer.MIN_VALUE;
                int n9 = Integer.MAX_VALUE;
                int n10 = 0;
                while (n10 < n3) {
                    int n11 = intBuffer.get();
                    n4 = n4 * 19 + n11;
                    nArray2[n10] = n11;
                    if (n11 > n8) {
                        n8 = n11;
                    }
                    if (n11 < n9) {
                        n9 = n11;
                    }
                    ++n10;
                }
                abstractDataset = integerDataset;
                abstractDataset.setStoredValue("max", n8);
                abstractDataset.setStoredValue("min", n9);
                break;
            }
            case 4: {
                LongDataset longDataset = new LongDataset(nArray);
                LongBuffer longBuffer = byteBuffer.asLongBuffer();
                if (longBuffer.remaining() != n3) {
                    throw new ScanFileHolderException("Data size, " + longBuffer.remaining() + ", does not match expected, " + n3);
                }
                long[] lArray = longDataset.getData();
                long l = Long.MIN_VALUE;
                long l2 = Long.MAX_VALUE;
                int n12 = 0;
                while (n12 < n3) {
                    long l3 = longBuffer.get();
                    n4 = n4 * 19 + (int)l3;
                    lArray[n12] = l3;
                    if (l3 > l) {
                        l = l3;
                    }
                    if (l3 < l2) {
                        l2 = l3;
                    }
                    ++n12;
                }
                abstractDataset = longDataset;
                abstractDataset.setStoredValue("max", l);
                abstractDataset.setStoredValue("min", l2);
                break;
            }
            case 100: {
                CompoundByteDataset compoundByteDataset = new CompoundByteDataset(n2, nArray);
                if (byteBuffer.remaining() != n3) {
                    throw new ScanFileHolderException("Data size, " + byteBuffer.remaining() + ", does not match expected, " + n3);
                }
                byte[] byArray = compoundByteDataset.getData();
                int n13 = 0;
                while (n13 < n3) {
                    byte by = byteBuffer.get();
                    n4 = n4 * 19 + by;
                    byArray[n13] = by;
                    ++n13;
                }
                abstractDataset = compoundByteDataset;
                break;
            }
            case 200: {
                CompoundShortDataset compoundShortDataset = new CompoundShortDataset(n2, nArray);
                ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
                if (shortBuffer.remaining() != n3) {
                    throw new ScanFileHolderException("Data size, " + shortBuffer.remaining() + ", does not match expected, " + n3);
                }
                short[] sArray = compoundShortDataset.getData();
                int n14 = 0;
                while (n14 < n3) {
                    short s = shortBuffer.get();
                    n4 = n4 * 19 + s;
                    sArray[n14] = s;
                    ++n14;
                }
                abstractDataset = compoundShortDataset;
                break;
            }
            case 300: {
                CompoundIntegerDataset compoundIntegerDataset = new CompoundIntegerDataset(n2, nArray);
                IntBuffer intBuffer = byteBuffer.asIntBuffer();
                if (intBuffer.remaining() != n3) {
                    throw new ScanFileHolderException("Data size, " + intBuffer.remaining() + ", does not match expected, " + n3);
                }
                int[] nArray2 = compoundIntegerDataset.getData();
                int n15 = 0;
                while (n15 < n3) {
                    int n16 = intBuffer.get();
                    n4 = n4 * 19 + n16;
                    nArray2[n15] = n16;
                    ++n15;
                }
                abstractDataset = compoundIntegerDataset;
                break;
            }
            case 400: {
                CompoundLongDataset compoundLongDataset = new CompoundLongDataset(n2, nArray);
                LongBuffer longBuffer = byteBuffer.asLongBuffer();
                if (longBuffer.remaining() != n3) {
                    throw new ScanFileHolderException("Data size, " + longBuffer.remaining() + ", does not match expected, " + n3);
                }
                long[] lArray = compoundLongDataset.getData();
                int n17 = 0;
                while (n17 < n3) {
                    long l = longBuffer.get();
                    n4 = n4 * 19 + (int)l;
                    lArray[n17] = l;
                    ++n17;
                }
                abstractDataset = compoundLongDataset;
                break;
            }
            case 5: {
                FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
                FloatDataset floatDataset = new FloatDataset(nArray);
                if (floatBuffer.remaining() != n3) {
                    throw new ScanFileHolderException("Data size, " + floatBuffer.remaining() + ", does not match expected, " + n3);
                }
                float[] fArray = floatDataset.getData();
                float f = -3.4028235E38f;
                float f2 = Float.MAX_VALUE;
                int n18 = 0;
                while (n18 < n3) {
                    float f3 = floatBuffer.get();
                    d = Float.isInfinite(f3) || Float.isNaN(f3) ? d * 19.0 % 2.147483647E9 : (d * 19.0 + (double)f3) % 2.147483647E9;
                    fArray[n18] = f3;
                    if (Float.isNaN(f)) {
                        f = f3;
                    }
                    if (Float.isNaN(f2)) {
                        f2 = f3;
                    }
                    if (f3 > f) {
                        f = f3;
                    }
                    if (f3 < f2) {
                        f2 = f3;
                    }
                    ++n18;
                }
                abstractDataset = floatDataset;
                abstractDataset.setStoredValue("max", Float.valueOf(f));
                abstractDataset.setStoredValue("min", Float.valueOf(f2));
                n4 = (int)d;
                break;
            }
            case 500: {
                CompoundFloatDataset compoundFloatDataset = new CompoundFloatDataset(n2, nArray);
                FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
                if (floatBuffer.remaining() != n3) {
                    throw new ScanFileHolderException("Data size, " + floatBuffer.remaining() + ", does not match expected, " + n3);
                }
                float[] fArray = compoundFloatDataset.getData();
                int n19 = 0;
                while (n19 < n3) {
                    float f = floatBuffer.get();
                    d = Float.isInfinite(f) || Float.isNaN(f) ? d * 19.0 % 2.147483647E9 : (d * 19.0 + (double)f) % 2.147483647E9;
                    fArray[n19] = f;
                    ++n19;
                }
                abstractDataset = compoundFloatDataset;
                n4 = (int)d;
                break;
            }
            case 7: {
                ComplexFloatDataset complexFloatDataset = new ComplexFloatDataset(nArray);
                FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
                if (floatBuffer.remaining() != n3) {
                    throw new ScanFileHolderException("Data size, " + floatBuffer.remaining() + ", does not match expected, " + n3);
                }
                float[] fArray = complexFloatDataset.getData();
                d = 0.0;
                int n20 = 0;
                while (n20 < n3) {
                    float f = floatBuffer.get();
                    d = Float.isInfinite(f) || Float.isNaN(f) ? d * 19.0 % 2.147483647E9 : (d * 19.0 + (double)f) % 2.147483647E9;
                    fArray[n20] = f;
                    ++n20;
                }
                abstractDataset = complexFloatDataset;
                n4 = (int)d;
                break;
            }
            case -1: 
            case 6: {
                DoubleDataset doubleDataset = new DoubleDataset(nArray);
                DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
                if (doubleBuffer.remaining() != n3) {
                    throw new ScanFileHolderException("Data size, " + doubleBuffer.remaining() + ", does not match expected, " + n3);
                }
                double[] dArray = doubleDataset.getData();
                double d2 = -1.7976931348623157E308;
                double d3 = Double.MAX_VALUE;
                int n21 = 0;
                while (n21 < n3) {
                    double d4 = doubleBuffer.get();
                    d = Double.isInfinite(d4) || Double.isNaN(d4) ? d * 19.0 % 2.147483647E9 : (d * 19.0 + d4) % 2.147483647E9;
                    dArray[n21] = d4;
                    if (Double.isNaN(d2)) {
                        d2 = d4;
                    }
                    if (Double.isNaN(d3)) {
                        d3 = d4;
                    }
                    if (d4 > d2) {
                        d2 = d4;
                    }
                    if (d4 < d3) {
                        d3 = d4;
                    }
                    ++n21;
                }
                abstractDataset = doubleDataset;
                abstractDataset.setStoredValue("max", d2);
                abstractDataset.setStoredValue("min", d3);
                n4 = (int)d;
                break;
            }
            case 600: {
                CompoundDoubleDataset compoundDoubleDataset = new CompoundDoubleDataset(n2, nArray);
                DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
                if (doubleBuffer.remaining() != n3) {
                    throw new ScanFileHolderException("Data size, " + doubleBuffer.remaining() + ", does not match expected, " + n3);
                }
                double[] dArray = compoundDoubleDataset.getData();
                int n22 = 0;
                while (n22 < n3) {
                    double d5 = doubleBuffer.get();
                    d = Double.isInfinite(d5) || Double.isNaN(d5) ? d * 19.0 % 2.147483647E9 : (d * 19.0 + d5) % 2.147483647E9;
                    dArray[n22] = d5;
                    ++n22;
                }
                abstractDataset = compoundDoubleDataset;
                n4 = (int)d;
                break;
            }
            case 8: {
                ComplexDoubleDataset complexDoubleDataset = new ComplexDoubleDataset(nArray);
                DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
                if (doubleBuffer.remaining() != n3) {
                    throw new ScanFileHolderException("Data size, " + doubleBuffer.remaining() + ", does not match expected, " + n3);
                }
                double[] dArray = complexDoubleDataset.getData();
                int n23 = 0;
                while (n23 < n3) {
                    double d6 = doubleBuffer.get();
                    d = Double.isInfinite(d6) || Double.isNaN(d6) ? d * 19.0 % 2.147483647E9 : (d * 19.0 + d6) % 2.147483647E9;
                    dArray[n23] = d6;
                    ++n23;
                }
                abstractDataset = complexDoubleDataset;
                n4 = (int)d;
                break;
            }
            default: {
                throw new ScanFileHolderException("Dataset type not supported");
            }
        }
        n4 = n4 * 19 + abstractDataset.getDtype() * 17 + abstractDataset.getElementsPerItem();
        int n24 = nArray.length;
        int n25 = 0;
        while (n25 < n24) {
            n4 = n4 * 17 + nArray[n25];
            ++n25;
        }
        abstractDataset.setStoredValue("hash", n4);
        return abstractDataset;
    }
}

