/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import gda.analysis.io.ScanFileHolderException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.dataset.IntegerDataset;
import uk.ac.diamond.scisoft.analysis.io.AbstractFileLoader;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.IMetaData;
import uk.ac.diamond.scisoft.analysis.io.IMetaLoader;
import uk.ac.diamond.scisoft.analysis.io.MetaDataAdapter;
import uk.ac.diamond.scisoft.analysis.io.Utils;
import uk.ac.gda.monitor.IMonitor;

public class RAxisImageLoader
extends AbstractFileLoader
implements IMetaLoader {
    private String fileName = "";
    private HashMap<String, Object> metadata = new HashMap();
    public HashMap<String, Serializable> GDAMetadata = new HashMap();
    private boolean keepBitWidth = false;

    public boolean isKeepBitWidth() {
        return this.keepBitWidth;
    }

    public void setKeepBitWidth(boolean bl) {
        this.keepBitWidth = bl;
    }

    public RAxisImageLoader() {
    }

    public RAxisImageLoader(String string) {
        this(string, false);
    }

    public RAxisImageLoader(String string, boolean bl) {
        this.setFile(string);
        this.keepBitWidth = bl;
    }

    public void setFile(String string) {
        this.fileName = string;
        this.metadata.clear();
        this.GDAMetadata.clear();
    }

    @Override
    public DataHolder loadFile() throws ScanFileHolderException {
        DataHolder dataHolder = new DataHolder();
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(this.fileName, "r");
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ScanFileHolderException("File not found", fileNotFoundException);
        }
        catch (Exception exception) {
            try {
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            throw new ScanFileHolderException("There was a problem loading or reading metadata", exception);
        }
        this.processingMetadata(randomAccessFile);
        this.createGDAMetatdata();
        try {
            try {
                int n = (Integer)this.metadata.get("nFast");
                int n2 = (Integer)this.metadata.get("nSlow");
                int[] nArray = new int[]{n2, n};
                byte[] byArray = new byte[n * n2 * 2];
                randomAccessFile.read(byArray);
                AbstractDataset abstractDataset = new IntegerDataset(nArray);
                int[] nArray2 = ((IntegerDataset)abstractDataset).getData();
                int n3 = Integer.MIN_VALUE;
                int n4 = Integer.MAX_VALUE;
                int n5 = 0;
                int n6 = 0;
                int n7 = 0;
                while (n6 < nArray2.length) {
                    int n8 = Utils.beInt((int)byArray[n7++], (int)byArray[n7++]);
                    n5 = n5 * 19 + n8;
                    nArray2[n6] = n8;
                    if (n8 > n3) {
                        n3 = n8;
                    }
                    if (n8 < n4) {
                        n4 = n8;
                    }
                    ++n6;
                }
                if (this.keepBitWidth || n3 < 32768) {
                    abstractDataset = DatasetUtils.cast(abstractDataset, 2);
                }
                n5 = n5 * 19 + abstractDataset.getDtype() * 17 + abstractDataset.getElementsPerItem();
                n6 = nArray.length;
                n7 = 0;
                while (n7 < n6) {
                    n5 = n5 * 17 + nArray[n7];
                    ++n7;
                }
                abstractDataset.setStoredValue("max", n3);
                abstractDataset.setStoredValue("min", n4);
                abstractDataset.setStoredValue("hash", n5);
                abstractDataset.setName("image-01");
                dataHolder.addDataset("RAxis Image", abstractDataset, this.getMetaData());
            }
            catch (Exception exception) {
                throw new ScanFileHolderException("There was a problem reading the RAxis image", exception);
            }
        }
        finally {
            try {
                randomAccessFile.close();
            }
            catch (IOException iOException) {
                throw new ScanFileHolderException("Problem closing RAxis file", iOException);
            }
        }
        return dataHolder;
    }

    private void processingMetadata(RandomAccessFile randomAccessFile) throws ScanFileHolderException {
        try {
            byte[] byArray = new byte[10];
            randomAccessFile.readFully(byArray);
            this.metadata.put("Device", new String(byArray).trim());
            if (!new String(byArray).trim().contains("RAXIS")) {
                throw new ScanFileHolderException("This image does not appear to be an RAxis image");
            }
            byArray = new byte[10];
            randomAccessFile.readFully(byArray);
            this.metadata.put("Version", new String(byArray).trim());
            byArray = new byte[20];
            randomAccessFile.readFully(byArray);
            this.metadata.put("Crystal", new String(byArray).trim());
            byArray = new byte[12];
            randomAccessFile.readFully(byArray);
            this.metadata.put("Crystal system", new String(byArray).trim());
            randomAccessFile.skipBytes(24);
            byArray = new byte[12];
            randomAccessFile.readFully(byArray);
            this.metadata.put("SpaceGroup", new String(byArray).trim());
            this.metadata.put("mosaic1", Float.valueOf(randomAccessFile.readFloat()));
            byArray = new byte[80];
            randomAccessFile.readFully(byArray);
            this.metadata.put("memo", new String(byArray).trim());
            byArray = new byte[84];
            randomAccessFile.readFully(byArray);
            this.metadata.put("reserve1", new String(byArray).trim());
            byArray = new byte[12];
            randomAccessFile.readFully(byArray);
            this.metadata.put("date", new String(byArray).trim());
            byArray = new byte[20];
            randomAccessFile.readFully(byArray);
            this.metadata.put("operatorname", new String(byArray).trim());
            byArray = new byte[4];
            randomAccessFile.readFully(byArray);
            this.metadata.put("target", new String(byArray).trim());
            this.metadata.put("wavelength", Float.valueOf(randomAccessFile.readFloat()));
            byArray = new byte[20];
            randomAccessFile.readFully(byArray);
            this.metadata.put("monotype", new String(byArray).trim());
            this.metadata.put("mono2theta", Float.valueOf(randomAccessFile.readFloat()));
            byArray = new byte[20];
            randomAccessFile.readFully(byArray);
            this.metadata.put("collimator", new String(byArray).trim());
            byArray = new byte[4];
            randomAccessFile.readFully(byArray);
            this.metadata.put("filter", new String(byArray).trim());
            this.metadata.put("distance", Float.valueOf(randomAccessFile.readFloat()));
            this.metadata.put("Kv", Float.valueOf(randomAccessFile.readFloat()));
            this.metadata.put("mA", Float.valueOf(randomAccessFile.readFloat()));
            byArray = new byte[12];
            randomAccessFile.readFully(byArray);
            this.metadata.put("focus", new String(byArray).trim());
            byArray = new byte[80];
            randomAccessFile.readFully(byArray);
            this.metadata.put("Xmemo", new String(byArray).trim());
            this.metadata.put("cyl", randomAccessFile.readInt());
            randomAccessFile.skipBytes(60);
            byArray = new byte[4];
            randomAccessFile.readFully(byArray);
            this.metadata.put("Spindle", new String(byArray).trim());
            byArray = new byte[4];
            randomAccessFile.readFully(byArray);
            this.metadata.put("Xray_axis", new String(byArray).trim());
            this.metadata.put("phidatum", Float.valueOf(randomAccessFile.readFloat()));
            this.metadata.put("phistart", Float.valueOf(randomAccessFile.readFloat()));
            this.metadata.put("phiend", Float.valueOf(randomAccessFile.readFloat()));
            this.metadata.put("noscillations", randomAccessFile.readInt());
            this.metadata.put("minutes", Float.valueOf(randomAccessFile.readFloat()));
            this.metadata.put("beampixels_x", Float.valueOf(randomAccessFile.readFloat()));
            this.metadata.put("beampixels_y", Float.valueOf(randomAccessFile.readFloat()));
            this.metadata.put("omega", Float.valueOf(randomAccessFile.readFloat()));
            this.metadata.put("chi", Float.valueOf(randomAccessFile.readFloat()));
            this.metadata.put("twotheta", Float.valueOf(randomAccessFile.readFloat()));
            this.metadata.put("Mu", Float.valueOf(randomAccessFile.readFloat()));
            byArray = new byte[204];
            randomAccessFile.readFully(byArray);
            this.metadata.put("ScanTemplate", new String(byArray).trim());
            this.metadata.put("nFast", randomAccessFile.readInt());
            this.metadata.put("nSlow", randomAccessFile.readInt());
            this.metadata.put("sizeFast", Float.valueOf(randomAccessFile.readFloat()));
            this.metadata.put("sizeSlow", Float.valueOf(randomAccessFile.readFloat()));
            this.metadata.put("record_length", randomAccessFile.readInt());
            this.metadata.put("number_records", randomAccessFile.readInt());
            this.metadata.put("Read_start", randomAccessFile.readInt());
            this.metadata.put("IP_num", randomAccessFile.readInt());
            this.metadata.put("Ratio", Float.valueOf(randomAccessFile.readFloat()));
            this.metadata.put("Fading_start", Float.valueOf(randomAccessFile.readFloat()));
            this.metadata.put("Fading_end", Float.valueOf(randomAccessFile.readFloat()));
            byArray = new byte[10];
            randomAccessFile.readFully(byArray);
            this.metadata.put("computer", new String(byArray).trim());
            byArray = new byte[10];
            randomAccessFile.readFully(byArray);
            this.metadata.put("plate_type", new String(byArray).trim());
            this.metadata.put("Dr", randomAccessFile.readInt());
            this.metadata.put("Dx", randomAccessFile.readInt());
            this.metadata.put("Dz", randomAccessFile.readInt());
            this.metadata.put("PixShiftOdd", Float.valueOf(randomAccessFile.readFloat()));
            this.metadata.put("IntRatioOdd", Float.valueOf(randomAccessFile.readFloat()));
            this.metadata.put("MagicNum'", randomAccessFile.readInt());
            this.metadata.put("NumGonAxes'", randomAccessFile.readInt());
            float[] fArray = new float[]{randomAccessFile.readFloat(), randomAccessFile.readFloat(), randomAccessFile.readFloat(), randomAccessFile.readFloat(), randomAccessFile.readFloat(), randomAccessFile.readFloat(), randomAccessFile.readFloat(), randomAccessFile.readFloat(), randomAccessFile.readFloat(), randomAccessFile.readFloat(), randomAccessFile.readFloat(), randomAccessFile.readFloat(), randomAccessFile.readFloat(), randomAccessFile.readFloat(), randomAccessFile.readFloat()};
            this.metadata.put("a5x3fGonVecs", fArray);
            float[] fArray2 = new float[]{randomAccessFile.readFloat(), randomAccessFile.readFloat(), randomAccessFile.readFloat(), randomAccessFile.readFloat(), randomAccessFile.readFloat()};
            this.metadata.put("a5x3fGonStart", fArray2);
            float[] fArray3 = new float[]{randomAccessFile.readFloat(), randomAccessFile.readFloat(), randomAccessFile.readFloat(), randomAccessFile.readFloat(), randomAccessFile.readFloat()};
            this.metadata.put("a5fGonEnd", fArray3);
            float[] fArray4 = new float[]{randomAccessFile.readFloat(), randomAccessFile.readFloat(), randomAccessFile.readFloat(), randomAccessFile.readFloat(), randomAccessFile.readFloat()};
            this.metadata.put("a5fGonOffset", fArray4);
            this.metadata.put("ScanAxisNum", randomAccessFile.readInt());
            byArray = new byte[10];
            randomAccessFile.readFully(byArray);
            this.metadata.put("ScanAxisNum", new String(byArray).trim());
            randomAccessFile.skipBytes((int)((long)((Integer)this.metadata.get("record_length")).intValue() - randomAccessFile.getFilePointer()));
        }
        catch (IOException iOException) {
            throw new ScanFileHolderException("There was a problem parsing the RAxis header information", iOException);
        }
    }

    private void createGDAMetatdata() throws ScanFileHolderException {
        try {
            double d = ((float)((Integer)this.metadata.get("nFast")).intValue() - ((float)((Integer)this.metadata.get("nFast")).intValue() - ((Float)this.metadata.get("beampixels_x")).floatValue())) * ((Float)this.metadata.get("sizeFast")).floatValue();
            double d2 = ((float)((Integer)this.metadata.get("nSlow")).intValue() - ((float)((Integer)this.metadata.get("nSlow")).intValue() - ((Float)this.metadata.get("beampixels_y")).floatValue())) * ((Float)this.metadata.get("sizeSlow")).floatValue();
            double[] dArray = new double[]{d, d2, ((Float)this.metadata.get("distance")).floatValue()};
            this.GDAMetadata.put("NXdetector:NXgeometery:NXtranslation", (Serializable)dArray);
            this.GDAMetadata.put("NXdetector:NXgeometery:NXtranslation:NXunits", (Serializable)((Object)"milli*meter"));
            double[] dArray2 = new double[]{1.0, 0.0, 0.0, 0.0, 1.0, 0.0};
            this.GDAMetadata.put("NXdetector:NXgeometery:NXorientation", (Serializable)dArray2);
            double[] dArray3 = new double[]{(float)((Integer)this.metadata.get("nFast")).intValue() * ((Float)this.metadata.get("sizeFast")).floatValue(), (float)((Integer)this.metadata.get("nSlow")).intValue() * ((Float)this.metadata.get("sizeSlow")).floatValue(), 0.0, 0.0, 0.0, 0.0};
            this.GDAMetadata.put("NXdetector:NXgeometery:NXshape", (Serializable)dArray3);
            this.GDAMetadata.put("NXdetector:NXgeometery:NXshape:NXshape", (Serializable)((Object)"milli*metre"));
            double[] dArray4 = new double[]{((Float)this.metadata.get("sizeFast")).floatValue(), ((Float)this.metadata.get("sizeSlow")).floatValue()};
            this.GDAMetadata.put("NXdetector:x_pixel_size", Double.valueOf(dArray4[0]));
            this.GDAMetadata.put("NXdetector:x_pixel_size:NXunits", (Serializable)((Object)"milli*metre"));
            this.GDAMetadata.put("NXdetector:y_pixel_size", Double.valueOf(dArray4[1]));
            this.GDAMetadata.put("NXdetector:y_pixel_size:NXunits", (Serializable)((Object)"milli*metre"));
            this.GDAMetadata.put("NXmonochromator:wavelength", (Float)this.metadata.get("wavelength"));
            this.GDAMetadata.put("NXmonochromator:wavelength:NXunits", (Serializable)((Object)"Angstrom"));
            double d3 = ((Float)this.metadata.get("phistart")).floatValue();
            this.GDAMetadata.put("NXSample:rotation_start", Double.valueOf(d3));
            this.GDAMetadata.put("NXSample:rotation_start:NXUnits", (Serializable)((Object)"degree"));
            this.GDAMetadata.put("NXSample:rotation_range", Double.valueOf((double)((Float)this.metadata.get("phiend")).floatValue() - d3));
            this.GDAMetadata.put("NXSample:rotation_range:NXUnits", (Serializable)((Object)"degree"));
            this.GDAMetadata.put("NXSample:exposure_time", Float.valueOf(((Float)this.metadata.get("minutes")).floatValue() * 60.0f));
            this.GDAMetadata.put("NXSample:exposure_time:NXUnits", (Serializable)((Object)"seconds"));
        }
        catch (Exception exception) {
            throw new ScanFileHolderException("There was a problem creating the GDA metatdata", exception);
        }
    }

    @Override
    public void loadMetaData(IMonitor iMonitor) throws Exception {
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(this.fileName, "r");
            this.processingMetadata(randomAccessFile);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ScanFileHolderException("File not found", fileNotFoundException);
        }
        catch (Exception exception) {
            try {
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            throw new ScanFileHolderException("There was a problem loading or reading metadata", exception);
        }
    }

    @Override
    public IMetaData getMetaData() {
        return new MetaDataAdapter(){

            public String getMetaValue(String string) {
                if (RAxisImageLoader.this.metadata.containsKey(string)) {
                    return RAxisImageLoader.this.metadata.get(string).toString();
                }
                if (RAxisImageLoader.this.GDAMetadata.containsKey(string)) {
                    return RAxisImageLoader.this.GDAMetadata.get(string).toString();
                }
                return null;
            }

            @Override
            public Collection<String> getMetaNames() throws Exception {
                HashSet<String> hashSet = new HashSet<String>(RAxisImageLoader.this.metadata.keySet());
                hashSet.addAll(RAxisImageLoader.this.GDAMetadata.keySet());
                return hashSet;
            }

            @Override
            public Map<String, int[]> getDataShapes() {
                int n = (Integer)RAxisImageLoader.this.metadata.get("nFast");
                int n2 = (Integer)RAxisImageLoader.this.metadata.get("nSlow");
                HashMap<String, int[]> hashMap = new HashMap<String, int[]>(1);
                hashMap.put("RAXIS osc", new int[]{n2, n});
                return hashMap;
            }
        };
    }
}

