/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import gda.analysis.io.ScanFileHolderException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.metadata.IIOMetadata;
import uk.ac.diamond.scisoft.analysis.io.TIFFImageLoader;

public class PixiumLoader
extends TIFFImageLoader {
    public PixiumLoader(String string) {
        super(string, false);
    }

    @Override
    protected Map<String, Serializable> createMetadata(IIOMetadata iIOMetadata) throws ScanFileHolderException {
        File file = new File(this.fileName);
        File file2 = new File(file.getParent(), "metadata.inf");
        if (!file2.exists()) {
            throw new ScanFileHolderException("No metadata found, please create metadata.inf file");
        }
        try {
            return this.readMetadata(file2);
        }
        catch (Exception exception) {
            throw new ScanFileHolderException("Could not read metadata file contents, check the metadata.inf file is correct", exception);
        }
    }

    private Map<String, Serializable> readMetadata(File file) throws NumberFormatException, IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        double d = Double.parseDouble(bufferedReader.readLine().split("\t")[1]);
        double d2 = Double.parseDouble(bufferedReader.readLine().split("\t")[1]);
        double d3 = Double.parseDouble(bufferedReader.readLine().split("\t")[1]);
        double d4 = Double.parseDouble(bufferedReader.readLine().split("\t")[1]);
        double d5 = Double.parseDouble(bufferedReader.readLine().split("\t")[1]);
        double d6 = Double.parseDouble(bufferedReader.readLine().split("\t")[1]);
        double d7 = Double.parseDouble(bufferedReader.readLine().split("\t")[1]);
        HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
        double d8 = d;
        double[] dArray = new double[]{d2 * d8 - d5, d3 * d8 - d6, d4};
        hashMap.put("NXdetector:NXgeometery:NXtranslation", (Serializable)dArray);
        hashMap.put("NXdetector:NXgeometery:NXtranslation:NXunits", (Serializable)((Object)"milli*meter"));
        double[] dArray2 = new double[]{1.0, 0.0, 0.0, 0.0, 1.0, 0.0};
        hashMap.put("NXdetector:NXgeometery:NXorientation", (Serializable)dArray2);
        double[] dArray3 = new double[]{d2 * d, d3 * d, 0.0, 0.0, 0.0, 0.0};
        hashMap.put("NXdetector:NXgeometery:NXshape", (Serializable)dArray3);
        hashMap.put("NXdetector:NXgeometery:NXshape:NXshape", (Serializable)((Object)"milli*metre"));
        double[] dArray4 = new double[]{d, d};
        hashMap.put("NXdetector:x_pixel_size", Double.valueOf(dArray4[0]));
        hashMap.put("NXdetector:x_pixel_size:NXunits", (Serializable)((Object)"milli*metre"));
        hashMap.put("NXdetector:y_pixel_size", Double.valueOf(dArray4[1]));
        hashMap.put("NXdetector:y_pixel_size:NXunits", (Serializable)((Object)"milli*metre"));
        hashMap.put("NXmonochromator:wavelength", Double.valueOf(d7));
        hashMap.put("NXmonochromator:wavelength:NXunits", (Serializable)((Object)"Angstrom"));
        hashMap.put("NXSample:rotation_start", Double.valueOf(0.0));
        hashMap.put("NXSample:rotation_start:NXUnits", (Serializable)((Object)"degree"));
        hashMap.put("NXSample:rotation_range", Double.valueOf(0.0));
        hashMap.put("NXSample:rotation_range:NXUnits", (Serializable)((Object)"degree"));
        hashMap.put("NXSample:exposure_time", Double.valueOf(0.0));
        hashMap.put("NXSample:exposure_time:NXUnits", (Serializable)((Object)"seconds"));
        return hashMap;
    }
}

