/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import com.sun.media.imageio.plugins.tiff.TIFFDirectory;
import com.sun.media.imageio.plugins.tiff.TIFFField;
import gda.analysis.io.ScanFileHolderException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import uk.ac.diamond.scisoft.analysis.io.TIFFImageLoader;

public class PilatusTiffLoader
extends TIFFImageLoader {
    private Map<String, String> metadataTable = new HashMap<String, String>();
    static String[] PILATUS_NAMES = new String[]{"Pixel_size", "Silicon sensor, thickness", "Exposure_time", "Exposure_period", "Tau =", "Threshold_setting", "N_excluded_pixels", "Excluded_pixels:", "Trim_directory:", "Flat_field:"};

    public PilatusTiffLoader(String string) {
        super(string);
    }

    @Override
    protected Map<String, Serializable> createMetadata(IIOMetadata iIOMetadata) throws ScanFileHolderException {
        TIFFDirectory tIFFDirectory;
        String string = "";
        try {
            tIFFDirectory = TIFFDirectory.createFromMetadata((IIOMetadata)iIOMetadata);
        }
        catch (IIOInvalidTreeException iIOInvalidTreeException) {
            throw new ScanFileHolderException("Problem creating TIFF directory from header", iIOInvalidTreeException);
        }
        TIFFField[] tIFFFieldArray = tIFFDirectory.getTIFFFields();
        int n = 0;
        boolean bl = false;
        int n2 = 0;
        while (n2 < tIFFFieldArray.length) {
            TIFFField tIFFField = tIFFFieldArray[n2];
            if (tIFFField.getTag().getName().equalsIgnoreCase("ImageDescription")) {
                BufferedReader bufferedReader = new BufferedReader(new StringReader(tIFFField.getValueAsString(0)));
                try {
                    while ((string = bufferedReader.readLine()) != null) {
                        bl = false;
                        int n3 = 0;
                        while (n3 < PILATUS_NAMES.length) {
                            if (string.contains(PILATUS_NAMES[n3])) {
                                this.metadataTable.put(PILATUS_NAMES[n3], string.substring(string.indexOf(PILATUS_NAMES[n3]) + PILATUS_NAMES[n3].length(), string.length()).trim());
                                bl = true;
                                break;
                            }
                            ++n3;
                        }
                        if (bl) continue;
                        this.metadataTable.put("Unknown " + n, string);
                        ++n;
                    }
                }
                catch (IOException iOException) {
                    throw new ScanFileHolderException("Problem reading TIFF header", iOException);
                }
            } else {
                this.metadataTable.put(tIFFField.getTag().getName(), tIFFField.getValueAsString(0));
            }
            ++n2;
        }
        return this.createGDAMetadata();
    }

    private Map<String, Serializable> createGDAMetadata() {
        String string = this.metadataTable.get("Pixel_size");
        if (string == null) {
            return null;
        }
        String[] stringArray = string.split("m x");
        double d = Double.parseDouble(stringArray[0]) * 1000.0;
        double d2 = Double.parseDouble(stringArray[1].split("m")[0]) * 1000.0;
        HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
        hashMap.put("NXdetector:x_pixel_size", Double.valueOf(d));
        hashMap.put("NXdetector:x_pixel_size:NXunits", (Serializable)((Object)"milli*metre"));
        hashMap.put("NXdetector:y_pixel_size", Double.valueOf(d2));
        hashMap.put("NXdetector:y_pixel_size:NXunits", (Serializable)((Object)"milli*metre"));
        return hashMap;
    }
}

