/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import gda.analysis.io.ScanFileHolderException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.FloatDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IntegerDataset;
import uk.ac.diamond.scisoft.analysis.io.AbstractFileLoader;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.IMetaData;
import uk.ac.diamond.scisoft.analysis.io.IMetaLoader;
import uk.ac.diamond.scisoft.analysis.io.MetaDataAdapter;
import uk.ac.diamond.scisoft.analysis.io.Utils;
import uk.ac.gda.monitor.IMonitor;

public class PilatusEdfLoader
extends AbstractFileLoader
implements IMetaLoader {
    private String fileName;
    private Map<String, String> textMetadata = new HashMap<String, String>();

    public PilatusEdfLoader(String string) {
        this.fileName = string;
    }

    @Override
    public DataHolder loadFile() throws ScanFileHolderException {
        return this.loadFile(null);
    }

    @Override
    public DataHolder loadFile(IMonitor iMonitor) throws ScanFileHolderException {
        AbstractDataset abstractDataset = null;
        DataHolder dataHolder = new DataHolder();
        File file = null;
        FileInputStream fileInputStream = null;
        try {
            try {
                file = new File(this.fileName);
                fileInputStream = new FileInputStream(file);
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                String string = bufferedReader.readLine();
                if (!string.trim().startsWith("{")) {
                    throw new ScanFileHolderException("EDF File should start with {");
                }
                if (string.contains("{")) {
                    int n = this.readMetaData(bufferedReader, string.length() + 1, iMonitor);
                    int n2 = Integer.parseInt(this.textMetadata.get("Dim_1"));
                    int n3 = Integer.parseInt(this.textMetadata.get("Dim_2"));
                    String string2 = this.textMetadata.get("DataType");
                    if (string2.equals("Float")) {
                        abstractDataset = new FloatDataset(n3, n2);
                        Utils.readFloat(fileInputStream, (FloatDataset)abstractDataset, n);
                    } else {
                        abstractDataset = new IntegerDataset(n3, n2);
                        boolean bl = "LowByteFirst".equals(this.textMetadata.get("ByteOrder"));
                        if (string2.contains("Short")) {
                            boolean bl2 = string2.startsWith("Signed");
                            if (bl) {
                                Utils.readLeShort(fileInputStream, (IntegerDataset)abstractDataset, n, bl2);
                            } else {
                                Utils.readBeShort(fileInputStream, (IntegerDataset)abstractDataset, n, bl2);
                            }
                        } else if (bl) {
                            Utils.readLeInt(fileInputStream, (IntegerDataset)abstractDataset, n);
                        } else {
                            Utils.readBeInt(fileInputStream, (IntegerDataset)abstractDataset, n);
                        }
                    }
                    abstractDataset.setName("image-01");
                }
            }
            catch (Exception exception) {
                throw new ScanFileHolderException("File failed to load " + this.fileName, exception);
            }
        }
        catch (Throwable throwable) {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
                fileInputStream = null;
            }
            throw throwable;
        }
        if (fileInputStream != null) {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
            fileInputStream = null;
        }
        if (abstractDataset != null) {
            dataHolder.addDataset("ESRF Pilatus Data", abstractDataset);
        }
        return dataHolder;
    }

    @Override
    public void loadMetaData(IMonitor iMonitor) throws Exception {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(new File(this.fileName)));
        try {
            String string = bufferedReader.readLine();
            this.readMetaData(bufferedReader, string.length() + 1, iMonitor);
        }
        finally {
            bufferedReader.close();
        }
    }

    @Override
    public IMetaData getMetaData() {
        return new MetaDataAdapter(){

            public String getMetaValue(String string) {
                return (String)PilatusEdfLoader.this.textMetadata.get(string);
            }

            @Override
            public Collection<String> getMetaNames() throws Exception {
                return PilatusEdfLoader.this.textMetadata.keySet();
            }

            @Override
            public Map<String, int[]> getDataShapes() {
                int n = Integer.parseInt((String)PilatusEdfLoader.this.textMetadata.get("Dim_1"));
                int n2 = Integer.parseInt((String)PilatusEdfLoader.this.textMetadata.get("Dim_2"));
                HashMap<String, int[]> hashMap = new HashMap<String, int[]>(1);
                hashMap.put("ESRF Pilatus Data", new int[]{n2, n});
                return hashMap;
            }

            @Override
            public Collection<String> getDataNames() {
                return Collections.unmodifiableCollection(Arrays.asList("ESRF Pilatus Data"));
            }
        };
    }

    private int readMetaData(BufferedReader bufferedReader, int n, IMonitor iMonitor) throws Exception {
        this.textMetadata.clear();
        while (true) {
            if (iMonitor != null) {
                iMonitor.worked(1);
            }
            if (iMonitor != null && iMonitor.isCancelled()) {
                throw new ScanFileHolderException("Loader cancelled during reading!");
            }
            String string = bufferedReader.readLine();
            n += string.length() + 1;
            if (string.contains("}")) break;
            String[] stringArray = string.split("=");
            if (stringArray.length == 1) {
                this.textMetadata.put(stringArray[0].trim(), "");
                continue;
            }
            int n2 = stringArray[1].endsWith(";") ? stringArray[1].length() - 1 : stringArray[1].length();
            String string2 = stringArray[1].substring(0, n2);
            this.textMetadata.put(stringArray[0].trim(), string2.trim());
        }
        return n;
    }
}

