/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import gda.util.TestUtils;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.IMetaData;
import uk.ac.diamond.scisoft.analysis.io.LoaderFactory;
import uk.ac.diamond.scisoft.analysis.io.PgmLoader;
import uk.ac.diamond.scisoft.analysis.io.PilatusEdfLoader;

public class PgmLoaderTest {
    static String testScratchDirectoryName = null;
    static final String testFileFolder = "testfiles/gda/analysis/io/PGMLoaderTest/";
    private String file = "image0001.pgm";

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        testScratchDirectoryName = TestUtils.generateDirectorynameFromClassname((String)PilatusEdfLoader.class.getCanonicalName());
        TestUtils.makeScratchDirectory((String)testScratchDirectoryName);
    }

    @Test
    public void load() throws Exception {
        PgmLoader pgmLoader = new PgmLoader(testFileFolder + this.file);
        DataHolder dataHolder = pgmLoader.loadFile();
        Assert.assertEquals((Object)pgmLoader.getHeaderValue("MagicNumber"), (Object)"P5");
        Assert.assertEquals((Object)pgmLoader.getHeaderValue("Width"), (Object)"1024");
        Assert.assertEquals((Object)pgmLoader.getHeaderValue("Height"), (Object)"1024");
        Assert.assertEquals((Object)pgmLoader.getHeaderValue("Maxval"), (Object)"65535");
        AbstractDataset abstractDataset = dataHolder.getDataset("Portable Grey Map");
        Assert.assertEquals((double)abstractDataset.getDouble(0, 0), (double)0.0, (double)0.0);
        Assert.assertEquals((double)abstractDataset.getDouble(512, 511), (double)15104.0, (double)0.0);
        Assert.assertEquals((double)abstractDataset.getDouble(1023, 1023), (double)0.0, (double)0.0);
    }

    @Test
    public void loadLoaderFactory() throws Exception {
        DataHolder dataHolder = LoaderFactory.getData(testFileFolder + this.file, null);
        AbstractDataset abstractDataset = dataHolder.getDataset("Portable Grey Map");
        Assert.assertEquals((double)abstractDataset.getDouble(0, 0), (double)0.0, (double)0.0);
        Assert.assertEquals((double)abstractDataset.getDouble(512, 511), (double)15104.0, (double)0.0);
        Assert.assertEquals((double)abstractDataset.getDouble(1023, 1023), (double)0.0, (double)0.0);
    }

    @Test
    public void loadLoaderFactoryMetaData() throws Exception {
        IMetaData iMetaData = LoaderFactory.getMetaData(testFileFolder + this.file, null);
        Assert.assertEquals((Object)iMetaData.getMetaValue("MagicNumber"), (Object)"P5");
        Assert.assertEquals((Object)iMetaData.getMetaValue("Width"), (Object)"1024");
        Assert.assertEquals((Object)iMetaData.getMetaValue("Height"), (Object)"1024");
        Assert.assertEquals((Object)iMetaData.getMetaValue("Maxval"), (Object)"65535");
    }
}

