/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import gda.analysis.io.ScanFileHolderException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IntegerDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ShortDataset;
import uk.ac.diamond.scisoft.analysis.io.AbstractFileLoader;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.IMetaData;
import uk.ac.diamond.scisoft.analysis.io.IMetaLoader;
import uk.ac.diamond.scisoft.analysis.io.MetaDataAdapter;
import uk.ac.diamond.scisoft.analysis.io.Utils;
import uk.ac.gda.monitor.IMonitor;

public class PgmLoader
extends AbstractFileLoader
implements IMetaLoader {
    private String fileName;
    private Map<String, String> textMetadata = new HashMap<String, String>();

    public PgmLoader() {
    }

    public PgmLoader(String string) {
        this.fileName = string;
    }

    @Override
    public DataHolder loadFile() throws ScanFileHolderException {
        return this.loadFile(null);
    }

    @Override
    public DataHolder loadFile(IMonitor iMonitor) throws ScanFileHolderException {
        AbstractDataset abstractDataset = null;
        DataHolder dataHolder = new DataHolder();
        File file = null;
        FileInputStream fileInputStream = null;
        try {
            try {
                file = new File(this.fileName);
                fileInputStream = new FileInputStream(file);
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                int[] nArray = this.readMetaData(bufferedReader, iMonitor);
                int n = nArray[0];
                int n2 = nArray[1];
                int n3 = nArray[2];
                int n4 = nArray[3];
                if (n4 < 256) {
                    abstractDataset = new ShortDataset(n3, n2);
                    Utils.readByte(fileInputStream, (ShortDataset)abstractDataset, n);
                } else {
                    abstractDataset = new IntegerDataset(n3, n2);
                    Utils.readBeShort(fileInputStream, (IntegerDataset)abstractDataset, n, false);
                }
                abstractDataset.setName("image-01");
            }
            catch (Exception exception) {
                throw new ScanFileHolderException("File failed to load " + this.fileName, exception);
            }
        }
        catch (Throwable throwable) {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
                fileInputStream = null;
            }
            throw throwable;
        }
        if (fileInputStream != null) {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
            fileInputStream = null;
        }
        dataHolder.addDataset("Portable Grey Map", abstractDataset);
        return dataHolder;
    }

    private int[] readMetaData(BufferedReader bufferedReader, IMonitor iMonitor) throws Exception {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        this.textMetadata.clear();
        if (iMonitor != null) {
            iMonitor.worked(1);
        }
        if (iMonitor != null && iMonitor.isCancelled()) {
            throw new ScanFileHolderException("Loader cancelled during reading!");
        }
        String string = bufferedReader.readLine();
        int n4 = string.length() + 1;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string2 = stringTokenizer.nextToken();
        this.textMetadata.put("MagicNumber", string2);
        if (string2.startsWith("P5")) {
            if (!stringTokenizer.hasMoreTokens()) {
                do {
                    string = bufferedReader.readLine();
                    n4 += string.length() + 1;
                } while (string.startsWith("#"));
                stringTokenizer = new StringTokenizer(string);
            }
            string2 = stringTokenizer.nextToken();
            this.textMetadata.put("Width", string2);
            n = Integer.parseInt(string2);
            if (!stringTokenizer.hasMoreTokens()) {
                string = bufferedReader.readLine();
                n4 += string.length() + 1;
                stringTokenizer = new StringTokenizer(string);
            }
            string2 = stringTokenizer.nextToken();
            this.textMetadata.put("Height", string2);
            n2 = Integer.parseInt(string2);
            if (!stringTokenizer.hasMoreTokens()) {
                string = bufferedReader.readLine();
                n4 += string.length() + 1;
                stringTokenizer = new StringTokenizer(string);
            }
            string2 = stringTokenizer.nextToken();
            this.textMetadata.put("Maxval", string2);
            n3 = Integer.parseInt(string2);
        }
        return new int[]{n4, n, n2, n3};
    }

    @Override
    public void loadMetaData(IMonitor iMonitor) throws Exception {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(new File(this.fileName)));
        try {
            this.readMetaData(bufferedReader, iMonitor);
        }
        finally {
            bufferedReader.close();
        }
    }

    @Override
    public IMetaData getMetaData() {
        return new MetaDataAdapter(){

            public String getMetaValue(String string) {
                return (String)PgmLoader.this.textMetadata.get(string);
            }

            @Override
            public Collection<String> getMetaNames() throws Exception {
                return PgmLoader.this.textMetadata.keySet();
            }

            @Override
            public Collection<String> getDataNames() {
                return Collections.unmodifiableCollection(Arrays.asList("Portable Grey Map"));
            }
        };
    }

    public String getHeaderValue(String string) {
        return this.textMetadata.get(string);
    }
}

