/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import gda.analysis.io.ScanFileHolderException;
import gda.util.TestUtils;
import java.io.FileNotFoundException;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.Comparisons;
import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.dataset.Maths;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.LoaderFactory;
import uk.ac.diamond.scisoft.analysis.io.PNGLoader;
import uk.ac.diamond.scisoft.analysis.io.PNGSaver;
import uk.ac.diamond.scisoft.analysis.io.PNGScaledSaver;

public class PNGTest {
    static final String TestFileFolder = "testfiles/images/";
    static String testScratchDirectoryName = null;
    AbstractDataset data;
    DataHolder dh = new DataHolder();
    int sizex = 500;
    int sizey = 500;
    int range = this.sizex * this.sizey;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        testScratchDirectoryName = TestUtils.generateDirectorynameFromClassname((String)PNGTest.class.getCanonicalName());
        TestUtils.makeScratchDirectory((String)testScratchDirectoryName);
    }

    @Test
    public void testSaveFile() throws Exception {
        String string = "testSaveFile.png";
        DataHolder dataHolder = new DataHolder();
        this.data = DatasetUtils.linSpace(0.0, 32000.0, this.range, 2);
        this.data.setShape(this.sizex, this.sizey);
        dataHolder.addDataset("testing data", this.data);
        new PNGSaver(String.valueOf(testScratchDirectoryName) + string).saveFile(dataHolder);
        DataHolder dataHolder2 = new PNGLoader(String.valueOf(testScratchDirectoryName) + string, false, true).loadFile();
        short[] sArray = (short[])this.data.getBuffer();
        AbstractDataset abstractDataset = dataHolder2.getDataset(0);
        short[] sArray2 = (short[])abstractDataset.getBuffer();
        Assert.assertEquals((long)sArray.length, (long)sArray2.length);
        int n = 0;
        while (n < sArray.length) {
            Assert.assertEquals((String)("" + n), (long)sArray[n], (long)sArray2[n]);
            ++n;
        }
    }

    @Test
    public void testLoaderFactory() throws Exception {
        String string = "testLoaderFactory.png";
        DataHolder dataHolder = new DataHolder();
        this.data = DatasetUtils.linSpace(0.0, 32000.0, this.range, 2);
        this.data.setShape(this.sizex, this.sizey);
        dataHolder.addDataset("testing data", this.data);
        new PNGSaver(String.valueOf(testScratchDirectoryName) + string).saveFile(dataHolder);
        DataHolder dataHolder2 = LoaderFactory.getData(String.valueOf(testScratchDirectoryName) + string, null);
        if (dataHolder2 == null || dataHolder2.getNames().length < 1) {
            throw new Exception();
        }
    }

    @Test
    public void testPNGLoader2() throws Exception {
        new PNGLoader("testfiles/images/test.png", true).loadFile();
    }

    @Test
    public void manyImages() throws ScanFileHolderException {
        String string = "manyImages.png";
        DataHolder dataHolder = new DataHolder();
        this.data = DatasetUtils.linSpace(0.0, 32000.0, this.range, 2);
        this.data.setShape(this.sizex, this.sizey);
        int n = 0;
        while (n < 5) {
            dataHolder.addDataset("testing data " + n, this.data);
            ++n;
        }
        new PNGSaver(String.valueOf(testScratchDirectoryName) + string).saveFile(dataHolder);
    }

    @Test
    public void manyImagesScaled() throws ScanFileHolderException {
        String string = "manyImagesScaled.png";
        DataHolder dataHolder = new DataHolder();
        this.data = DatasetUtils.linSpace(0.0, 250000.0, this.range, 3);
        this.data.setShape(this.sizex, this.sizey);
        int n = 0;
        while (n < 5) {
            dataHolder.addDataset("testing data " + n, this.data);
            ++n;
        }
        new PNGScaledSaver(String.valueOf(testScratchDirectoryName) + string).saveFile(dataHolder);
    }

    @Test
    public void compareDataset() throws ScanFileHolderException {
        String string = "compareDataset.png";
        DataHolder dataHolder = new DataHolder();
        this.data = DatasetUtils.linSpace(0.0, 32000.0, this.range, 2);
        this.data.setShape(this.sizex, this.sizey);
        dataHolder.addDataset("testing data", this.data);
        new PNGSaver(String.valueOf(testScratchDirectoryName) + string).saveFile(dataHolder);
        DataHolder dataHolder2 = new PNGLoader(String.valueOf(testScratchDirectoryName) + string, false, true).loadFile();
        AbstractDataset abstractDataset = dataHolder2.getDataset(0);
        Assert.assertTrue((String)"Saved and loaded datasets are not equal", (boolean)Comparisons.allTrue(Comparisons.equalTo(abstractDataset, this.data)));
    }

    @Test
    public void compareScaledDataset() throws ScanFileHolderException {
        String string = "compareScaledDataset.png";
        DataHolder dataHolder = new DataHolder();
        this.data = DatasetUtils.linSpace(0.0, 250000.0, this.range, 3);
        this.data.setShape(this.sizex, this.sizey);
        dataHolder.addDataset("testing data", this.data);
        new PNGScaledSaver(String.valueOf(testScratchDirectoryName) + string).saveFile(dataHolder);
        DataHolder dataHolder2 = new PNGLoader(String.valueOf(testScratchDirectoryName) + string, false, false).loadFile();
        AbstractDataset abstractDataset = dataHolder2.getDataset(0);
        Number number = abstractDataset.min();
        Number number2 = abstractDataset.peakToPeak();
        abstractDataset = Maths.multiply(Maths.subtract((Object)abstractDataset, number), this.data.max().doubleValue() / number2.doubleValue());
        Assert.assertTrue((String)"Saved and loaded datasets are not equal", (boolean)Comparisons.allTrue(Comparisons.almostEqualTo(abstractDataset, this.data, 1.0E-5, 4.0)));
    }

    @Test
    public void noEnding() throws Exception {
        DataHolder dataHolder = new DataHolder();
        this.data = DatasetUtils.linSpace(0.0, 32000.0, this.range, 2);
        this.data.setShape(this.sizex, this.sizey);
        dataHolder.addDataset("testing data", this.data);
        new PNGSaver(String.valueOf(testScratchDirectoryName) + "noEnding.png").saveFile(dataHolder);
        this.dh = new PNGLoader(String.valueOf(testScratchDirectoryName) + "noEnding").loadFile();
        Assert.assertTrue((String)"Saved and loaded datasets are not equal", (boolean)Comparisons.allTrue(Comparisons.equalTo(this.dh.getDataset(0), this.data)));
        new PNGScaledSaver(String.valueOf(testScratchDirectoryName) + "noEnding1").saveFile(this.dh);
        this.dh = new PNGLoader(String.valueOf(testScratchDirectoryName) + "noEnding1").loadFile();
    }

    @Test
    public void incorrectEnding() throws Exception {
        String string = "incorrectEnding.txt";
        String string2 = "incorrectEnding1.txt";
        DataHolder dataHolder = new DataHolder();
        this.data = DatasetUtils.linSpace(0.0, 32000.0, this.range, 2);
        this.data.setShape(this.sizex, this.sizey);
        dataHolder.addDataset("testing data", this.data);
        new PNGScaledSaver(String.valueOf(testScratchDirectoryName) + string).saveFile(dataHolder);
        new PNGSaver(String.valueOf(testScratchDirectoryName) + string2).saveFile(dataHolder);
        new PNGLoader(String.valueOf(testScratchDirectoryName) + string).loadFile();
        new PNGLoader(String.valueOf(testScratchDirectoryName) + string2).loadFile();
    }

    @Test
    public void testNoFile() throws ScanFileHolderException {
        block2: {
            try {
                new PNGLoader(String.valueOf(testScratchDirectoryName) + "NoFile.png").loadFile();
            }
            catch (ScanFileHolderException scanFileHolderException) {
                if (scanFileHolderException.getCause() instanceof FileNotFoundException) break block2;
                throw scanFileHolderException;
            }
        }
    }
}

