/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import gda.analysis.io.IFileSaver;
import gda.analysis.io.ScanFileHolderException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.text.DecimalFormat;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.dataset.ILazyDataset;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.NumPyFile;
import uk.ac.diamond.scisoft.analysis.io.RawBinarySaver;

public class NumPyFileSaver
implements IFileSaver {
    private String filename = "";

    public NumPyFileSaver(String string) {
        this.filename = string;
    }

    @Override
    public void saveFile(DataHolder dataHolder) throws ScanFileHolderException {
        File file = null;
        int n = dataHolder.size();
        int n2 = 0;
        while (n2 < n) {
            byte[] byArray;
            Object object;
            Object object2;
            try {
                object2 = null;
                object = null;
                if (n == 1) {
                    object2 = this.filename;
                } else {
                    try {
                        object2 = this.filename.substring(0, this.filename.lastIndexOf("."));
                        object = this.filename.substring(this.filename.lastIndexOf("."));
                    }
                    catch (Exception exception) {
                        object2 = this.filename;
                    }
                    DecimalFormat decimalFormat = new DecimalFormat("00000");
                    object2 = String.valueOf(object2) + decimalFormat.format(n2 + 1) + (String)object;
                }
                file = new File((String)object2);
            }
            catch (Exception exception) {
                throw new ScanFileHolderException("Error saving file '" + this.filename + "'", exception);
            }
            object2 = dataHolder.getDataset(n2);
            if (object2 == null) {
                throw new ScanFileHolderException("Dataset null at index " + n2 + " unsupported");
            }
            object = DatasetUtils.convertToAbstractDataset((ILazyDataset)object2);
            int n3 = ((AbstractDataset)object).getDtype();
            NumPyFile.DataTypeInfo dataTypeInfo = NumPyFile.numPyTypeMap.get(n3);
            if (dataTypeInfo == null) {
                throw new ScanFileHolderException("Unsupported data types for NumPy File Saver");
            }
            int n4 = ((AbstractDataset)object).getElementsPerItem();
            if (n4 > 255) {
                throw new ScanFileHolderException("Number of elements in each item exceeds allowed maximum of 255");
            }
            byte by = (byte)n4;
            int[] nArray = ((AbstractDataset)object).getShape();
            if (nArray.length > 255) {
                throw new ScanFileHolderException("Rank exceeds 255!");
            }
            StringBuilder stringBuilder = new StringBuilder();
            int n5 = 0;
            while (n5 < nArray.length) {
                stringBuilder.append(nArray[n5]);
                stringBuilder.append(", ");
                ++n5;
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            if (nArray.length > 1) {
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            }
            StringBuilder stringBuilder2 = new StringBuilder();
            stringBuilder2.append("{'descr': '");
            stringBuilder2.append(dataTypeInfo.numPyType);
            stringBuilder2.append("', 'fortran_order': False, 'shape': (");
            stringBuilder2.append((CharSequence)stringBuilder);
            stringBuilder2.append("), }");
            int n6 = stringBuilder2.length() + NumPyFile.magic.length + 2;
            n6 = (n6 + 15) / 16 * 16;
            while (stringBuilder2.length() + NumPyFile.magic.length + 2 < n6) {
                stringBuilder2.append(' ');
            }
            try {
                byArray = stringBuilder2.toString().getBytes("US-ASCII");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new ScanFileHolderException("Impossible error, US-ASCII is always available?", unsupportedEncodingException);
            }
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                FileChannel fileChannel = fileOutputStream.getChannel();
                ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n6);
                byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                int n7 = 0;
                while (n7 < NumPyFile.magic.length) {
                    byteBuffer.put(NumPyFile.magic[n7]);
                    ++n7;
                }
                byteBuffer.putShort((short)byArray.length);
                n7 = 0;
                while (n7 < byArray.length) {
                    byteBuffer.put(byArray[n7]);
                    ++n7;
                }
                byteBuffer.rewind();
                while (byteBuffer.hasRemaining()) {
                    fileChannel.write(byteBuffer);
                }
                ByteBuffer byteBuffer2 = RawBinarySaver.saveRawDataset((AbstractDataset)object, n3, by);
                byteBuffer2.rewind();
                while (byteBuffer2.hasRemaining()) {
                    fileChannel.write(byteBuffer2);
                }
                fileChannel.close();
                fileOutputStream.close();
            }
            catch (Exception exception) {
                throw new ScanFileHolderException("Error saving file '" + this.filename + "'", exception);
            }
            ++n2;
        }
    }
}

