/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import gda.analysis.io.ScanFileHolderException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.io.AbstractFileLoader;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.NumPyFile;
import uk.ac.diamond.scisoft.analysis.io.RawBinaryLoader;

public class NumPyFileLoader
extends AbstractFileLoader {
    private static final transient Logger logger = LoggerFactory.getLogger(NumPyFileLoader.class);
    private String fileName;

    public NumPyFileLoader() {
    }

    public NumPyFileLoader(String string) {
        this.fileName = string;
    }

    public void setFile(String string) {
        this.fileName = string;
    }

    @Override
    public DataHolder loadFile() throws ScanFileHolderException {
        DataHolder dataHolder = new DataHolder();
        File file = null;
        FileInputStream fileInputStream = null;
        try {
            try {
                ByteBuffer byteBuffer;
                file = new File(this.fileName);
                fileInputStream = new FileInputStream(file);
                FileChannel fileChannel = null;
                if (System.getProperty("os.name").contains("Windows")) {
                    long l = file.length();
                    if (l > Integer.MAX_VALUE) {
                        throw new IOException("File too big " + file.getName());
                    }
                    int n = (int)l;
                    byte[] byArray = new byte[n];
                    int n2 = 0;
                    for (int i = 0; i < n; i += n2) {
                        n2 = fileInputStream.read(byArray, i, n - i);
                        if (n2 >= 0) {
                            continue;
                        }
                        throw new IOException("Can't read file " + file.getName());
                    }
                    byteBuffer = ByteBuffer.wrap(byArray);
                } else {
                    fileChannel = fileInputStream.getChannel();
                    byteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fileChannel.size());
                }
                AbstractDataset abstractDataset = NumPyFileLoader.loadDataset(byteBuffer);
                if (fileChannel != null) {
                    fileChannel.close();
                }
                dataHolder.addDataset("NumPy file", abstractDataset);
                abstractDataset.setDirty();
            }
            catch (Exception exception) {
                if (exception instanceof ScanFileHolderException) {
                    throw (ScanFileHolderException)exception;
                }
                throw new ScanFileHolderException("There was a problem reading the NumPy file", exception);
            }
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    logger.error("Exception when closing file", (Throwable)iOException);
                }
            }
        }
        return dataHolder;
    }

    public static AbstractDataset loadDataset(ByteBuffer byteBuffer) throws ScanFileHolderException {
        int n;
        int n2;
        String string;
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        int n3 = 0;
        while (n3 < NumPyFile.magic.length) {
            byte by = byteBuffer.get();
            if (NumPyFile.magic[n3] != by) {
                throw new ScanFileHolderException("File does not start npy magic number/version");
            }
            ++n3;
        }
        n3 = byteBuffer.getShort();
        byte[] byArray = new byte[n3];
        byteBuffer.get(byArray);
        try {
            string = new String(byArray, "US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new ScanFileHolderException("Impossible error, US-ASCII is always available?", unsupportedEncodingException);
        }
        String[] stringArray = string.split(", ", 3);
        String[] stringArray2 = stringArray[0].split(": ");
        String string2 = stringArray2[1].substring(1, stringArray2[1].length() - 1);
        String[] stringArray3 = stringArray[1].split(": ");
        Boolean bl = Boolean.parseBoolean(stringArray3[1]);
        String[] stringArray4 = stringArray[2].split(": ");
        String string3 = stringArray4[1].substring(1, stringArray4[1].lastIndexOf(41));
        String[] stringArray5 = string3.split(", ?");
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (stringArray5.length == 1 && "".equals(stringArray5[0])) {
            arrayList.add(1);
        } else {
            n2 = 0;
            while (n2 < stringArray5.length) {
                arrayList.add(Integer.parseInt(stringArray5[n2]));
                ++n2;
            }
        }
        n2 = arrayList.size();
        int[] nArray = new int[n2];
        int n4 = 0;
        while (n4 < n2) {
            nArray[n4] = (Integer)arrayList.get(n4);
            ++n4;
        }
        if (bl.booleanValue()) {
            throw new ScanFileHolderException("Only Non-fortran order is supported");
        }
        NumPyFile.DataTypeInfo dataTypeInfo = NumPyFile.dataTypeMap.get(string2);
        if (dataTypeInfo == null) {
            throw new ScanFileHolderException("Unknown/unsupported data type description: " + string2);
        }
        int n5 = dataTypeInfo.dType;
        int n6 = n = dataTypeInfo.iSize;
        int n7 = 0;
        while (n7 < n2) {
            n6 *= nArray[n7];
            ++n7;
        }
        AbstractDataset abstractDataset = RawBinaryLoader.loadRawDataset(byteBuffer, n5, n, n6, nArray);
        return abstractDataset;
    }

    public static AbstractDataset loadFileHelper(String string) throws ScanFileHolderException {
        NumPyFileLoader numPyFileLoader = new NumPyFileLoader(string);
        DataHolder dataHolder = numPyFileLoader.loadFile();
        AbstractDataset abstractDataset = dataHolder.getDataset(0);
        return abstractDataset;
    }
}

