/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import java.io.File;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.io.LoaderFactory;
import uk.ac.diamond.scisoft.analysis.io.LoaderThreadTestBase;
import uk.ac.diamond.scisoft.analysis.io.SliceObject;

public class NexusLoaderSliceThreadTest
extends LoaderThreadTestBase {
    private static String filename = String.valueOf(System.getProperty("GDALargeTestFilesLocation")) + "NexusUITest/DCT_201006-good.h5";
    private SliceObject sliceObject;

    @Before
    public void createSliceObject() {
        this.sliceObject = new SliceObject();
        this.sliceObject.setName("/RawDCT/NXdata/data");
        this.sliceObject.setPath(filename);
        int[] nArray = new int[3];
        nArray[2] = 1;
        this.sliceObject.setSliceStart(nArray);
        this.sliceObject.setSliceStop(new int[]{61, 171, 2});
    }

    @Override
    @Test
    public void testInTestThread() throws Exception {
        super.testInTestThread();
    }

    @Override
    @Test
    public void testWithTenThreads() throws Exception {
        super.testWithTenThreads();
    }

    @Test
    public void testWithNThreads() throws Exception {
        super.testWithNThreads(100);
    }

    @Override
    public void doTestOfDataSet(int n) throws Exception {
        Assert.assertTrue((boolean)new File(filename).canRead());
        SliceObject sliceObject = this.sliceObject.clone();
        int[] nArray = new int[3];
        nArray[2] = n + 10;
        sliceObject.setSliceStart(nArray);
        sliceObject.setSliceStop(new int[]{61, 171, n + 11});
        AbstractDataset abstractDataset = LoaderFactory.getSlice(sliceObject, null);
        Assert.assertTrue((abstractDataset.getSize() == 10431 ? 1 : 0) != 0);
    }
}

