/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import com.sun.media.imageio.plugins.tiff.TIFFDirectory;
import com.sun.media.imageio.plugins.tiff.TIFFField;
import gda.analysis.io.ScanFileHolderException;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.metadata.IIOMetadata;
import javax.vecmath.Matrix3d;
import javax.vecmath.Vector3d;
import uk.ac.diamond.scisoft.analysis.diffraction.DetectorProperties;
import uk.ac.diamond.scisoft.analysis.diffraction.DiffractionCrystalEnvironment;
import uk.ac.diamond.scisoft.analysis.io.DiffractionMetaDataAdapter;
import uk.ac.diamond.scisoft.analysis.io.IMetaData;
import uk.ac.diamond.scisoft.analysis.io.IMetaLoader;
import uk.ac.diamond.scisoft.analysis.io.TIFFImageLoader;
import uk.ac.diamond.scisoft.analysis.io.Utils;
import uk.ac.gda.monitor.IMonitor;

public class MARLoader
extends TIFFImageLoader
implements IMetaLoader {
    static final int MAX_IMAGES = 9;
    static final int MAR_HEADER_SIZE = 3072;
    private boolean littleEndian;
    Map<String, Serializable> metadataTable = new HashMap<String, Serializable>();
    private DetectorProperties detProps;
    private DiffractionCrystalEnvironment diffEnv;

    public MARLoader(String string) {
        super(string);
    }

    @Override
    protected Map<String, Serializable> createMetadata(IIOMetadata iIOMetadata) throws ScanFileHolderException {
        Object object;
        int n;
        Object object2;
        Object object3;
        long l = -1L;
        try {
            object3 = TIFFDirectory.createFromMetadata((IIOMetadata)iIOMetadata);
            object2 = object3.getTIFFFields();
            TIFFField[] tIFFFieldArray = object2;
            int n2 = ((TIFFField[])object2).length;
            n = 0;
            while (n < n2) {
                object = tIFFFieldArray[n];
                if (object.getTagNumber() == 34710) {
                    l = object.getAsLong(0);
                } else {
                    this.metadataTable.put(object.getTag().getName(), (Serializable)((Object)object.getValueAsString(0)));
                }
                ++n;
            }
            if (l < 0L) {
                throw new ScanFileHolderException("There was a problem getting to the begining of the MAR of the header");
            }
        }
        catch (Exception exception) {
            throw new ScanFileHolderException("Problem loading tiff header metadata in the MAR Loader class", exception);
        }
        object3 = new File(this.fileName);
        try {
            object2 = new FileInputStream((File)object3);
            object = new byte[3072];
            ((InputStream)object2).skip(l);
            ((InputStream)object2).read((byte[])object, 0, 3072);
            n = 28;
            if (Utils.beInt((int)object[n], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3]) == 4321) {
                this.littleEndian = false;
            }
            if (Utils.leInt((int)object[n], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3]) != 1234) {
                throw new ScanFileHolderException("Unknown endian");
            }
            this.littleEndian = true;
            this.metadataTable.put("headerByteOrderLE", Boolean.valueOf(this.littleEndian));
            n = 0;
            this.metadataTable.put("headerType", Integer.valueOf(this.getHeaderInt((int)object[n], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])));
            byte[] byArray = new byte[16];
            System.arraycopy(object, n += 4, byArray, 0, 16);
            this.metadataTable.put("headerName", (Serializable)((Object)new String(byArray, "US-ASCII")));
            this.metadataTable.put("headerMajorVersion", Integer.valueOf(this.getHeaderInt((int)object[n += 16], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])));
            this.metadataTable.put("headerMinorVersion", Integer.valueOf(this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])));
            n += 4;
            boolean bl = false;
            if (Utils.beInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3]) == 4321) {
                bl = false;
            }
            if (Utils.leInt((int)object[n], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3]) == 1234) {
                bl = true;
            }
            this.metadataTable.put("dataByteOrder", Boolean.valueOf(bl));
            this.metadataTable.put("headerSize", Integer.valueOf(this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])));
            this.metadataTable.put("frameType", Integer.valueOf(this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])));
            this.metadataTable.put("magicNumber", Integer.valueOf(this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])));
            this.metadataTable.put("compressionType", Integer.valueOf(this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])));
            this.metadataTable.put("compression1", Integer.valueOf(this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])));
            this.metadataTable.put("compression2", Integer.valueOf(this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])));
            this.metadataTable.put("compression3", Integer.valueOf(this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])));
            this.metadataTable.put("compression4", Integer.valueOf(this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])));
            this.metadataTable.put("compression5", Integer.valueOf(this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])));
            this.metadataTable.put("compression6", Integer.valueOf(this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])));
            this.metadataTable.put("nHeaders", Integer.valueOf(this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])));
            this.metadataTable.put("nFast", Integer.valueOf(this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])));
            this.metadataTable.put("nSlow", Integer.valueOf(this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])));
            this.metadataTable.put("depth", Integer.valueOf(this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])));
            this.metadataTable.put("recordLength", Integer.valueOf(this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])));
            this.metadataTable.put("signifBits", Integer.valueOf(this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])));
            this.metadataTable.put("dataType", Integer.valueOf(this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])));
            this.metadataTable.put("saturatedValue", Integer.valueOf(this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])));
            this.metadataTable.put("sequence", Integer.valueOf(this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])));
            this.metadataTable.put("nImages", Integer.valueOf(this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])));
            this.metadataTable.put("origin", Integer.valueOf(this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])));
            this.metadataTable.put("orientation", Integer.valueOf(this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])));
            this.metadataTable.put("viewDirection", Integer.valueOf(this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])));
            this.metadataTable.put("overflowLocation", Integer.valueOf(this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])));
            this.metadataTable.put("over8Bits", Integer.valueOf(this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])));
            this.metadataTable.put("over16Bits", Integer.valueOf(this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])));
            this.metadataTable.put("multiplexed", Integer.valueOf(this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])));
            this.metadataTable.put("numFastImages", Integer.valueOf(this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])));
            this.metadataTable.put("numSlowImages", Integer.valueOf(this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])));
            this.metadataTable.put("backgroundApplied", Integer.valueOf(this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])));
            this.metadataTable.put("biasApplied", Integer.valueOf(this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])));
            this.metadataTable.put("flatFieldApplied", Integer.valueOf(this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])));
            this.metadataTable.put("distortionApplied", Integer.valueOf(this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])));
            this.metadataTable.put("originalHeaderType", Integer.valueOf(this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])));
            this.metadataTable.put("fileSaved", Integer.valueOf(this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])));
            n += 4;
            int[] nArray = new int[]{this.getHeaderInt((int)object[n += 80], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3]), this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])};
            this.metadataTable.put("totalCounts", (Serializable)nArray);
            int[] nArray2 = new int[]{this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3]), this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])};
            this.metadataTable.put("specialCounts1", (Serializable)nArray2);
            int[] nArray3 = new int[]{this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3]), this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])};
            this.metadataTable.put("specialCounts2", (Serializable)nArray2);
            this.metadataTable.put("min", Integer.valueOf(this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])));
            this.metadataTable.put("max", Integer.valueOf(this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])));
            this.metadataTable.put("mean", Integer.valueOf(this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])));
            this.metadataTable.put("rms", Integer.valueOf(this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])));
            this.metadataTable.put("p10", Integer.valueOf(this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])));
            this.metadataTable.put("p90", Integer.valueOf(this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])));
            this.metadataTable.put("statsUpToDate", Integer.valueOf(this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])));
            n += 4;
            int[] nArray4 = new int[9];
            int n3 = 0;
            while (n3 < 9) {
                nArray4[n3] = this.getHeaderInt((int)object[n], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3]);
                n += 4;
                ++n3;
            }
            this.metadataTable.put("pixelNoise", (Serializable)nArray4);
            n += 40;
            int[] nArray5 = new int[128];
            int n4 = 0;
            while (n4 < 128) {
                nArray5[n4] = this.littleEndian ? Utils.leInt((int)object[n], (int)object[n + 1]) : Utils.beInt((int)object[n], (int)object[n + 1]);
                n += 2;
                ++n4;
            }
            this.metadataTable.put("xtaltoDetector", Double.valueOf((double)this.getHeaderInt((int)object[n], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3]) / 1000.0));
            this.metadataTable.put("beamX", Double.valueOf((double)this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3]) / 1000.0));
            this.metadataTable.put("beamY", Double.valueOf((double)this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3]) / 1000.0));
            this.metadataTable.put("intergrationTime", Double.valueOf((double)this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3]) / 1000.0));
            this.metadataTable.put("exposureTime", Double.valueOf((double)this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3]) / 1000.0));
            this.metadataTable.put("readoutTime", Double.valueOf((double)this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3]) / 1000.0));
            this.metadataTable.put("nReads", Double.valueOf((double)this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3]) / 1000.0));
            this.metadataTable.put("start2theta", Double.valueOf((double)this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3]) / 1000.0));
            this.metadataTable.put("startOmega", Double.valueOf((double)this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3]) / 1000.0));
            this.metadataTable.put("startChi", Double.valueOf((double)this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3]) / 1000.0));
            this.metadataTable.put("startKappa", Double.valueOf((double)this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3]) / 1000.0));
            this.metadataTable.put("startPhi", Double.valueOf((double)this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3]) / 1000.0));
            this.metadataTable.put("startDelta", Double.valueOf((double)this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3]) / 1000.0));
            this.metadataTable.put("startGamma", Double.valueOf((double)this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3]) / 1000.0));
            this.metadataTable.put("startXtaltoDetector", Double.valueOf((double)this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3]) / 1000.0));
            this.metadataTable.put("stop2theta", Double.valueOf((double)this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3]) / 1000.0));
            this.metadataTable.put("stopOmega", Double.valueOf((double)this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3]) / 1000.0));
            this.metadataTable.put("stopChi", Double.valueOf((double)this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3]) / 1000.0));
            this.metadataTable.put("stopKappa", Double.valueOf((double)this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3]) / 1000.0));
            this.metadataTable.put("stopPhi", Double.valueOf((double)this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3]) / 1000.0));
            this.metadataTable.put("stopDelta", Double.valueOf((double)this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3]) / 1000.0));
            this.metadataTable.put("stopGamma", Double.valueOf((double)this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3]) / 1000.0));
            this.metadataTable.put("stopXtaltoDetector", Double.valueOf((double)this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3]) / 1000.0));
            this.metadataTable.put("rotationAxis", Integer.valueOf(this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])));
            this.metadataTable.put("rotationRange", Double.valueOf((double)this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3]) / 1000.0));
            this.metadataTable.put("detectorRotateX", Double.valueOf((double)this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3]) / 1000.0));
            this.metadataTable.put("detectorRotateY", Double.valueOf((double)this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3]) / 1000.0));
            this.metadataTable.put("detectorRotateZ", Double.valueOf((double)this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3]) / 1000.0));
            n += 4;
            this.metadataTable.put("detectorType", Integer.valueOf(this.getHeaderInt((int)object[n += 16], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])));
            this.metadataTable.put("pixelSizeX", Integer.valueOf(this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])));
            this.metadataTable.put("pixelSizeY", Integer.valueOf(this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])));
            this.metadataTable.put("meanBias", Double.valueOf((double)this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3]) / 1000.0));
            this.metadataTable.put("photonPer100ADU", Integer.valueOf(this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])));
            n += 4;
            int[] nArray6 = new int[9];
            int n5 = 0;
            while (n5 < 9) {
                nArray6[n5] = this.getHeaderInt((int)object[n], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3]);
                n += 4;
                ++n5;
            }
            this.metadataTable.put("measuredBias", (Serializable)nArray6);
            int[] nArray7 = new int[9];
            int n6 = 0;
            while (n6 < 9) {
                nArray7[n6] = this.getHeaderInt((int)object[n], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3]);
                n += 4;
                ++n6;
            }
            this.metadataTable.put("measuredTemperature", (Serializable)nArray7);
            int[] nArray8 = new int[9];
            int n7 = 0;
            while (n7 < 9) {
                nArray8[n7] = this.getHeaderInt((int)object[n], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3]);
                n += 4;
                ++n7;
            }
            this.metadataTable.put("measuredPressure", (Serializable)nArray8);
            this.metadataTable.put("sourceType", Integer.valueOf(this.getHeaderInt((int)object[n], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])));
            this.metadataTable.put("sourcedx", Integer.valueOf(this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])));
            this.metadataTable.put("sourcedy", Integer.valueOf(this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])));
            this.metadataTable.put("sourceWavelength", Integer.valueOf(this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])));
            this.metadataTable.put("sourcePower", Integer.valueOf(this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])));
            this.metadataTable.put("sourceVoltage", Integer.valueOf(this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])));
            this.metadataTable.put("sourceCurrent", Integer.valueOf(this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])));
            this.metadataTable.put("sourceBias", Integer.valueOf(this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])));
            this.metadataTable.put("sourcePolerizationX", Integer.valueOf(this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])));
            this.metadataTable.put("sourcePolerizationY", Integer.valueOf(this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])));
            n += 4;
            this.metadataTable.put("opticsType", Integer.valueOf(this.getHeaderInt((int)object[n += 16], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])));
            this.metadataTable.put("opticsdx", Integer.valueOf(this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])));
            this.metadataTable.put("opticsdy", Integer.valueOf(this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])));
            this.metadataTable.put("opticsWavelength", Integer.valueOf(this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])));
            this.metadataTable.put("opticsDispersion", Integer.valueOf(this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])));
            this.metadataTable.put("opticsCrossfireX", Integer.valueOf(this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])));
            this.metadataTable.put("opticsCrossfireY", Integer.valueOf(this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])));
            this.metadataTable.put("opticsAngle", Integer.valueOf(this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])));
            this.metadataTable.put("opticsPolerizationX", Integer.valueOf(this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])));
            this.metadataTable.put("opticsPolerizationY", Integer.valueOf(this.getHeaderInt((int)object[n += 4], (int)object[n + 1], (int)object[n + 2], (int)object[n + 3])));
            n += 4;
            n += 16;
            byArray = new byte[128];
            System.arraycopy(object, n += 16, byArray, 0, 128);
            this.metadataTable.put("filetitle", (Serializable)((Object)new String(byArray, "US-ASCII")));
            byArray = new byte[128];
            System.arraycopy(object, n += 128, byArray, 0, 128);
            this.metadataTable.put("filepath", (Serializable)((Object)new String(byArray, "US-ASCII")));
            byArray = new byte[64];
            System.arraycopy(object, n += 128, byArray, 0, 64);
            this.metadataTable.put("filename", (Serializable)((Object)new String(byArray, "US-ASCII")));
            byArray = new byte[32];
            System.arraycopy(object, n += 64, byArray, 0, 32);
            this.metadataTable.put("AcquireTimestamp", (Serializable)((Object)new String(byArray, "US-ASCII")));
            byArray = new byte[32];
            System.arraycopy(object, n += 32, byArray, 0, 32);
            this.metadataTable.put("headerTimestamp", (Serializable)((Object)new String(byArray, "US-ASCII")));
            byArray = new byte[512];
            System.arraycopy(object, n += 32, byArray, 0, 512);
            this.metadataTable.put("fileComment", (Serializable)((Object)new String(byArray, "US-ASCII")));
            n += 512;
            byArray = new byte[512];
            System.arraycopy(object, n += 96, byArray, 0, 512);
            this.metadataTable.put("datasetComments", (Serializable)((Object)new String(byArray, "US-ASCII")));
            n += 512;
        }
        catch (Exception exception) {
            throw new ScanFileHolderException("Problem loading MAR metadata", exception);
        }
        return this.createGDAMetatdata();
    }

    private int getHeaderInt(int n, int n2, int n3, int n4) {
        int n5 = this.littleEndian ? Utils.leInt(n, n2, n3, n4) : Utils.beInt(n, n2, n3, n4);
        return n5;
    }

    private Map<String, Serializable> createGDAMetatdata() throws ScanFileHolderException {
        HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
        try {
            double d = (double)((Integer)this.getMetadataValue("pixelSizeX")).intValue() / 1000000.0;
            int n = Integer.parseInt((String)((Object)this.getMetadataValue("ImageWidth")));
            double d2 = (Double)this.getMetadataValue("beamX");
            double d3 = (double)((Integer)this.getMetadataValue("pixelSizeY")).intValue() / 1000000.0;
            int n2 = Integer.parseInt((String)((Object)this.getMetadataValue("ImageLength")));
            double d4 = (Double)this.getMetadataValue("beamY");
            double d5 = (Double)this.getMetadataValue("xtaltoDetector");
            double[] dArray = new double[]{((double)n - d2) * d, ((double)n2 - d4) * d3, d5};
            hashMap.put("NXdetector:NXgeometery:NXtranslation", (Serializable)dArray);
            hashMap.put("NXdetector:NXgeometery:NXtranslation:NXunits", (Serializable)((Object)"metre"));
            double d6 = (Double)this.getMetadataValue("detectorRotateX");
            double d7 = (Double)this.getMetadataValue("detectorRotateY");
            double d8 = (Double)this.getMetadataValue("detectorRotateZ");
            Matrix3d matrix3d = new Matrix3d();
            matrix3d.rotX(d6);
            Matrix3d matrix3d2 = new Matrix3d();
            matrix3d2.rotY(d7);
            Matrix3d matrix3d3 = new Matrix3d();
            matrix3d3.rotZ(d8);
            Matrix3d matrix3d4 = new Matrix3d();
            matrix3d4.mul(matrix3d, matrix3d2);
            matrix3d4.mul(matrix3d3);
            double[] dArray2 = new double[3];
            double[] dArray3 = new double[3];
            double[] dArray4 = new double[6];
            matrix3d4.getColumn(0, dArray2);
            matrix3d4.getColumn(1, dArray3);
            int n3 = 0;
            while (n3 < dArray4.length / 2) {
                dArray4[n3] = dArray2[n3];
                dArray4[3 + n3] = dArray3[n3];
                ++n3;
            }
            hashMap.put("NXdetector:NXgeometery:NXorientation", (Serializable)dArray4);
            double[] dArray5 = new double[]{((double)n - d2) * d, ((double)n2 - d4) * d3, 0.0, 0.0, 0.0, 0.0};
            hashMap.put("NXdetector:NXgeometery:NXshape", (Serializable)dArray5);
            hashMap.put("NXdetector:NXgeometery:NXshape:NXshape", (Serializable)((Object)"milli*metre"));
            hashMap.put("NXdetector:x_pixel_size", Double.valueOf(d));
            hashMap.put("NXdetector:x_pixel_size:NXunits", (Serializable)((Object)"milli*metre"));
            hashMap.put("NXdetector:y_pixel_size", Double.valueOf(d3));
            hashMap.put("NXdetector:y_pixel_size:NXunits", (Serializable)((Object)"milli*metre"));
            double d9 = (double)((Integer)this.getMetadataValue("sourceWavelength")).intValue() / 100000.0;
            hashMap.put("NXmonochromator:wavelength", Double.valueOf(d9));
            hashMap.put("NXmonochromator:wavelength:NXunits", (Serializable)((Object)"Angstrom"));
            double d10 = Double.parseDouble(this.getMetadataValue("startOmega").toString());
            double d11 = d10 - Double.parseDouble(this.getMetadataValue("stopOmega").toString());
            hashMap.put("NXSample:rotation_start", Double.valueOf(d10));
            hashMap.put("NXSample:rotation_start:NXUnits", (Serializable)((Object)"degree"));
            hashMap.put("NXSample:rotation_range", Double.valueOf(d11));
            hashMap.put("NXSample:rotation_range:NXUnits", (Serializable)((Object)"degree"));
            hashMap.put("NXSample:exposure_time", this.getMetadataValue("exposureTime"));
            hashMap.put("NXSample:exposure_time:NXUnits", (Serializable)((Object)"seconds"));
            this.detProps = new DetectorProperties(new Vector3d(dArray), n2, n, d, d3, matrix3d4);
            this.diffEnv = new DiffractionCrystalEnvironment(d9, d10, d11, (Double)this.getMetadataValue("exposureTime"));
        }
        catch (NumberFormatException numberFormatException) {
            throw new ScanFileHolderException("There was a problem parsing numerical value from string", numberFormatException);
        }
        catch (ScanFileHolderException scanFileHolderException) {
            throw new ScanFileHolderException("A problem occoured parsing the internal metatdata into the GDA metadata", scanFileHolderException);
        }
        return hashMap;
    }

    private Serializable getMetadataValue(String string) throws ScanFileHolderException {
        try {
            Serializable serializable = this.metadataTable.get(string);
            return serializable;
        }
        catch (Exception exception) {
            throw new ScanFileHolderException("The keyword " + string + " was not found in the MAR header", exception);
        }
    }

    @Override
    public void loadMetaData(IMonitor iMonitor) throws Exception {
        boolean bl = this.loadMetadata;
        try {
            this.loadMetadata = true;
            this.loadFile();
        }
        finally {
            this.loadMetadata = bl;
        }
    }

    @Override
    public IMetaData getMetaData() {
        return new DiffractionMetaDataAdapter(){
            final Map<String, String> vals = this.createStringMap();

            public String getMetaValue(String string) throws Exception {
                return this.vals.get(string);
            }

            @Override
            public Collection<String> getMetaNames() throws Exception {
                return this.vals.keySet();
            }

            private Map<String, String> createStringMap() {
                HashMap<String, String> hashMap = new HashMap<String, String>(7);
                for (String string : MARLoader.this.metadataTable.keySet()) {
                    hashMap.put(string, MARLoader.this.metadataTable.get(string).toString().trim());
                }
                return hashMap;
            }

            @Override
            public DetectorProperties getDetector2DProperties() {
                return MARLoader.this.detProps;
            }

            @Override
            public DiffractionCrystalEnvironment getDiffractionCrystalEnvironment() {
                return MARLoader.this.diffEnv;
            }

            @Override
            public DiffractionMetaDataAdapter clone() {
                final HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.putAll(this.vals);
                return new DiffractionMetaDataAdapter(){

                    public String getMetaValue(String string) throws Exception {
                        return (String)hashMap.get(string);
                    }

                    @Override
                    public Collection<String> getMetaNames() throws Exception {
                        return hashMap.keySet();
                    }

                    @Override
                    public DetectorProperties getDetector2DProperties() {
                        return MARLoader.this.detProps.clone();
                    }

                    @Override
                    public DiffractionCrystalEnvironment getDiffractionCrystalEnvironment() {
                        return MARLoader.this.diffEnv.clone();
                    }
                };
            }
        };
    }
}

